/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.reconstruction;

import com.mulesoft.connectivity.codegen.internal.Helpers;
import com.mulesoft.connectivity.fixengine.reconstruction.AbstractTypeRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.FieldReplacementInstruction;
import com.mulesoft.connectivity.fixengine.types.TypeIndexer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.parser.ast.types.ObjectTypeNode;
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode;
import org.mule.weave.v2.ts.ObjectType;
import scala.Option;
import scala.collection.Seq;

public class ObjectTypeRebuildBlueprint
extends AbstractTypeRebuildBlueprint<ObjectTypeNode> {
    private final Collection<FieldReplacementInstruction> fieldReplacementInstructions = new LinkedHashSet<FieldReplacementInstruction>();
    private final ObjectType source;

    public ObjectTypeRebuildBlueprint(ObjectType source, TypeIndexer indexer) {
        super(indexer);
        this.source = source;
    }

    public void addInstruction(FieldReplacementInstruction instruction) {
        this.fieldReplacementInstructions.add(instruction);
    }

    @Override
    public ObjectTypeNode rebuild() {
        List<WeaveTypeNode> filteredFields = Stream.of(this.source.getProperties()).flatMap(this::replace).filter(ObjectTypeRebuildBlueprint.distinctByKey()).map(keyValue -> this.convertKeyValuePairTypeToKeyValueTypeNode((KeyValuePairType)keyValue)).toList();
        return ObjectTypeNode.apply((Seq)Helpers.asSeq(filteredFields), (Option)Option.empty(), (Option)Option.empty(), (boolean)false, (boolean)false, (Seq)Helpers.seq());
    }

    private Stream<KeyValuePairType> replace(KeyValuePairType keyValue) {
        Stream<Object> values = Stream.of(keyValue);
        for (FieldReplacementInstruction instruction : this.fieldReplacementInstructions) {
            values = values.flatMap(instruction::getReplacements);
        }
        return values;
    }

    private static Predicate<KeyValuePairType> distinctByKey() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return keyValuePairType -> seen.putIfAbsent(keyValuePairType.getKeyName(), true) == null;
    }
}

