/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.flow.applier;

import com.google.common.collect.Maps;
import com.mulesoft.connectivity.codegen.internal.Helpers;
import com.mulesoft.connectivity.fixengine.MitigationIssue;
import com.mulesoft.connectivity.fixengine.PlatformGapsContext;
import com.mulesoft.connectivity.fixengine.api.strategies.RemoveUnsupportedNonRequiredFieldsStrategy;
import com.mulesoft.connectivity.fixengine.appliers.AbstractTypeStrategyApplier;
import com.mulesoft.connectivity.fixengine.helper.AstHelper;
import com.mulesoft.connectivity.fixengine.reconstruction.SkipElementInstruction;
import com.mulesoft.connectivity.fixengine.reconstruction.TypeDirectiveRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.types.TypeIndexer;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective;
import org.mule.weave.v2.parser.ast.header.directives.ImportedElement;
import org.mule.weave.v2.parser.ast.header.directives.ImportedElements;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.ts.ObjectType;
import scala.Option;

public class FlowRemoveUnsupportedNonRequiredFieldsApplier
extends AbstractTypeStrategyApplier<RemoveUnsupportedNonRequiredFieldsStrategy.RemoveUnsupportedNonRequiredFieldsSettings> {
    public static final String FIXED_TYPES_MODULE_NAME_IDENTIFIER = "fixedTypes";
    private static final String NAME_IDENTIFIER_TEMPLATE = "T_%s%s";
    private static final Pattern ELEMENT_NAME_PATTERN = Pattern.compile(INPUT_OUTER_ELEMENT_NAME + ".*");
    private static final String METADATA_ANNOTATIONS_MODULE = "com::mulesoft::connectivity::decorator::Annotations";

    public FlowRemoveUnsupportedNonRequiredFieldsApplier() {
        super(RemoveUnsupportedNonRequiredFieldsStrategy.RemoveUnsupportedNonRequiredFieldsSettings.class, RemoveUnsupportedNonRequiredFieldsStrategy.class);
    }

    @Override
    public Map<String, ModuleNode> preProcess(Map<String, ModuleNode> modules, PlatformGapsContext context, RemoveUnsupportedNonRequiredFieldsStrategy.RemoveUnsupportedNonRequiredFieldsSettings settings) {
        TypeIndexer typeIndexer = context.typeIndexer();
        context.mitigationIssues().forEach(mitigationIssue -> this.reconstructTypes((MitigationIssue)mitigationIssue, context));
        List fixedDirectives = typeIndexer.getDomainReplacements().stream().filter(blueprint -> blueprint instanceof TypeDirectiveRebuildBlueprint).map(TypeDirectiveRebuildBlueprint.class::cast).map(TypeDirectiveRebuildBlueprint::rebuild).sorted(Comparator.comparing(directive -> directive.variable().name())).collect(Collectors.toList());
        if (fixedDirectives.isEmpty()) {
            return modules;
        }
        fixedDirectives.add(0, AstHelper.createVersionDirective());
        fixedDirectives.addAll(1, this.createImportDirective(typeIndexer.getUnmodifiedTypes()));
        typeIndexer.getImportsForModule("types::Types").ifPresent(importDirective -> {
            importDirective.setImportedModule(METADATA_ANNOTATIONS_MODULE);
            fixedDirectives.add(1, importDirective.rebuild());
        });
        ModuleNode typeModule = new ModuleNode(Helpers.nameNode((String)FIXED_TYPES_MODULE_NAME_IDENTIFIER), Helpers.asSeq(fixedDirectives));
        LinkedHashMap fixedModules = Maps.newLinkedHashMap();
        fixedModules.putAll(modules);
        fixedModules.put(FlowRemoveUnsupportedNonRequiredFieldsApplier.getFixedTypesModuleName(modules), typeModule);
        return fixedModules;
    }

    private void reconstructTypes(MitigationIssue issue, PlatformGapsContext context) {
        String processUntil;
        String typeSuffix;
        Validatable<?> validatableWithIssue = issue.validatable();
        if (!FlowRemoveUnsupportedNonRequiredFieldsApplier.isOptionalField(validatableWithIssue)) {
            return;
        }
        if (validatableWithIssue.hasAnyContext(new ValidatableType[]{ValidatableType.OUTPUT})) {
            typeSuffix = "Response";
            processUntil = OUTPUT_OUTER_ELEMENT_NAME;
        } else {
            processUntil = INPUT_OUTER_ELEMENT_NAME;
            Matcher matcher = ELEMENT_NAME_PATTERN.matcher(validatableWithIssue.pathDescription());
            typeSuffix = matcher.matches() ? matcher.group(2).substring(0, 1).toUpperCase() + matcher.group(2).substring(1) : "Unknown";
        }
        String outerTypeName = NAME_IDENTIFIER_TEMPLATE.formatted(issue.getRootValidatableNameOrEmpty().replaceAll("[^a-zA-Z0-9]", "_"), typeSuffix);
        this.reconstructTypes(context, issue, processUntil, outerTypeName, SkipElementInstruction::new);
    }

    private List<ImportDirective> createImportDirective(Collection<ReferenceType> unmodifiedTypes) {
        Function<ReferenceType, String> groupingKey = referenceType -> referenceType.getReferenceFQName().substring(0, referenceType.getReferenceFQName().lastIndexOf("::"));
        Collector groupingValues = Collectors.mapping(Function.identity(), Collectors.toSet());
        return unmodifiedTypes.stream().collect(Collectors.groupingBy(groupingKey, groupingValues)).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> {
            List<ImportedElement> subElementsList = ((Set)e.getValue()).stream().map(ReferenceType::getReferenceTypeName).sorted().map(typeName -> new ImportedElement(new NameIdentifier(typeName, Option.empty()), Option.empty())).toList();
            ImportedElements subElements = new ImportedElements(Helpers.asSeq(subElementsList));
            ImportedElement importedElement = new ImportedElement(new NameIdentifier((String)e.getKey(), Option.empty()), Option.empty());
            return new ImportDirective(importedElement, subElements, Helpers.seq());
        }).toList();
    }

    private static boolean isOptionalField(Validatable<?> validatableWithIssue) {
        ObjectType fields;
        Object object;
        return validatableWithIssue.getParent() != null && (object = validatableWithIssue.getParent().getElement()) instanceof ObjectType && Stream.of((fields = (ObjectType)object).getProperties()).anyMatch(t -> t.getValue().equals(validatableWithIssue.getElement()) && t.isOptionalKey());
    }
}

