/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.reconstruction;

import com.mulesoft.connectivity.codegen.internal.Helpers;
import com.mulesoft.connectivity.fixengine.reconstruction.ObjectTypeRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.RebuildBlueprint;
import com.mulesoft.connectivity.fixengine.types.TypeIndexer;
import com.mulesoft.connectivity.fixengine.types.TypeMetadataConverter;
import com.mulesoft.connectivity.fixengine.types.TypeNamingHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.BinaryType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode;
import org.mule.weave.v2.parser.ast.types.KeyValueTypeNode;
import org.mule.weave.v2.parser.ast.types.ObjectTypeNode;
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode;
import org.mule.weave.v2.parser.ast.types.UnionTypeNode;
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.ts.TypeSelectorType;
import scala.Option;
import scala.collection.Seq;

public abstract class AbstractTypeRebuildBlueprint<T extends AstNode>
implements RebuildBlueprint<T> {
    protected final TypeIndexer indexer;
    private final TypeMetadataConverter typeMetadataConverter;

    public AbstractTypeRebuildBlueprint(TypeIndexer indexer) {
        this.indexer = indexer;
        this.typeMetadataConverter = new TypeMetadataConverter();
    }

    protected KeyValueTypeNode convertKeyValuePairTypeToKeyValueTypeNode(KeyValuePairType keyValuePairType) {
        WeaveTypeNode valueTypeNode = this.convertDWTypeToWeaveTypeNode(keyValuePairType.getValue());
        return KeyValueTypeNode.apply((WeaveTypeNode)Helpers.keyType((String)keyValuePairType.getKeyName()), (WeaveTypeNode)valueTypeNode, (boolean)keyValuePairType.repeated(), (boolean)keyValuePairType.isOptionalKey());
    }

    private Optional<WeaveTypeNode> getBasicTypeReference(DWType dwType, Seq<AnnotationNode> annotations) {
        return Optional.of(dwType).filter(StringType.class::isInstance).flatMap(stringType -> ((StringType)stringType).getValue().map(value -> Helpers.nameNode((String)String.format("\"%s\"", value)))).or(() -> TypeNamingHelper.getBasicTypeName(dwType.getClass())).map(nameIdentifier -> TypeReferenceNode.apply((NameIdentifier)nameIdentifier, (Option)Option.empty(), (Option)Option.empty(), (Option)Option.empty(), (Seq)annotations));
    }

    protected WeaveTypeNode convertDWTypeToWeaveTypeNode(DWType dwType) {
        Seq<AnnotationNode> annotations = "anonymous".equals(dwType.getLocation().getResourceIdentifier().getFQNIdentifier()) ? Helpers.seq() : this.typeMetadataConverter.convertMetadataToAnnotations(dwType.getTypeMetadata());
        annotations.foreach(annotation -> {
            this.indexer.addTypeForImport("types::Types", annotation.name().name());
            return null;
        });
        return this.getBasicTypeReference(dwType, annotations).orElseGet(() -> {
            if (dwType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dwType;
                WeaveTypeNode elementType = this.convertDWTypeToWeaveTypeNode(arrayType.arrayOf());
                return new TypeReferenceNode(new NameIdentifier("Array", Option.empty()), Option.apply((Object)Helpers.seq((Object[])new WeaveTypeNode[]{elementType})), Option.empty(), Option.empty(), annotations);
            }
            if (dwType instanceof ObjectType) {
                ObjectType objectType = (ObjectType)dwType;
                return (WeaveTypeNode)this.indexer.getTypeReplacement((DWType)objectType).map(blueprint -> ((ObjectTypeRebuildBlueprint)blueprint).rebuild()).orElseGet(() -> {
                    List fieldNodes = Arrays.stream(objectType.getProperties()).map(this::convertKeyValuePairTypeToKeyValueTypeNode).collect(Collectors.toList());
                    Seq fieldsSeq = Helpers.asSeq(fieldNodes);
                    return ObjectTypeNode.apply((Seq)fieldsSeq, (Option)Option.empty(), (Option)Option.empty(), (boolean)objectType.isClosed(), (boolean)objectType.isOrdered(), (Seq)annotations);
                });
            }
            if (dwType instanceof TypeSelectorType) {
                TypeSelectorType typeSelectorType = (TypeSelectorType)dwType;
                this.indexer.addReferenceType((ReferenceType)typeSelectorType);
                return new TypeReferenceNode(Helpers.nameNode((String)typeSelectorType.toString()), Option.empty(), Option.empty(), Option.empty(), annotations);
            }
            if (dwType instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)dwType;
                this.indexer.addReferenceType(referenceType);
                return new TypeReferenceNode(Helpers.nameNode((String)referenceType.getReferenceTypeName()), Option.empty(), Option.empty(), Option.empty(), annotations);
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                List unionMembers = Arrays.stream(unionType.unionOf()).map(this::convertDWTypeToWeaveTypeNode).collect(Collectors.toList());
                Seq membersSeq = Helpers.asSeq(unionMembers);
                return new UnionTypeNode(membersSeq, Option.empty(), Option.empty(), annotations);
            }
            if (dwType instanceof BinaryType) {
                return new TypeReferenceNode(new NameIdentifier("Binary", Option.empty()), Option.empty(), Option.empty(), Option.empty(), annotations);
            }
            return Helpers.ANY_TYPE;
        });
    }
}

