/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.utils.fakefile;

import com.google.common.base.Preconditions;
import com.mulesoft.connectivity.fixengine.utils.fakefile.MemoryURLConnection;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class Handler
extends URLStreamHandler {
    private static final String JAVA_PROTOCOL_HANDLER_PACKAGES = "java.protocol.handler.pkgs";
    private final Map<String, String> resources;

    public static void register() {
        String pkg = Handler.class.getPackage().getName();
        int lastDot = pkg.lastIndexOf(46);
        Preconditions.checkArgument((lastDot > 0 ? 1 : 0) != 0, (String)"package for Handler (%s) must have a parent package", (Object)pkg);
        String parentPackage = pkg.substring(0, lastDot);
        Object packages = System.getProperty(JAVA_PROTOCOL_HANDLER_PACKAGES);
        packages = packages == null ? parentPackage : (String)packages + "|" + parentPackage;
        System.setProperty(JAVA_PROTOCOL_HANDLER_PACKAGES, (String)packages);
    }

    public Handler(Map<String, String> resources) {
        this.resources = resources;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        byte[] bytes = this.resources.get(url.getPath()).getBytes(StandardCharsets.UTF_8);
        return new MemoryURLConnection(url, bytes);
    }
}

