/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.utils;

import com.mulesoft.connectivity.fixengine.utils.OperationTuple;
import com.mulesoft.connectivity.linkweave.api.model.CodeSourceLocation;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective;
import org.mule.weave.v2.parser.ast.header.directives.ImportedElement;
import org.mule.weave.v2.parser.ast.header.directives.ImportedElements;
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.ts.TypeSelectorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.compat.java8.OptionConverters;

public class ConnectorTranslatorUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorTranslatorUtils.class);

    private ConnectorTranslatorUtils() {
    }

    private static List<ImportDirective> splitImports(ImportDirective originalImport, ImportedElement elementToSplit, String targetModuleName) {
        ImportDirective typeImport = new ImportDirective(new ImportedElement(new NameIdentifier(targetModuleName, Option.empty()), Option.empty()), new ImportedElements((Seq)JavaConverters.asScalaBuffer(Collections.singletonList(elementToSplit))), originalImport.codeAnnotations());
        ImportDirective otherElementsImport = new ImportDirective(originalImport.importedModule(), new ImportedElements(((Traversable)originalImport.subElements().elements().filterNot(arg_0 -> ((ImportedElement)elementToSplit).equals(arg_0))).toSeq()), originalImport.codeAnnotations());
        return List.of(typeImport, otherElementsImport);
    }

    public static ModuleNode fixModuleImports(ModuleNode moduleNode, OperationTuple tuple) {
        List directives = JavaConverters.seqAsJavaList((Seq)moduleNode.directives());
        LinkedList headerDirectives = new LinkedList();
        LinkedList bodyDirectives = new LinkedList();
        directives.forEach(directive -> {
            if (directive instanceof ImportDirective) {
                ImportDirective importDirective = (ImportDirective)directive;
                String operationModuleName = String.join((CharSequence)"::", ((CodeSourceLocation)tuple.operation().getSourceLocation().orElseThrow()).getModuleParts());
                String paginatedOperationModuleName = String.join((CharSequence)"::", ((CodeSourceLocation)tuple.paginatedOp().getSourceLocation().orElseThrow()).getModuleParts());
                String referenceTypeName = ((TypeSelectorType)tuple.operation().getInputType().getDataType()).referencedType().getReferenceTypeName();
                if (importDirective.importedModule().elementName().name().equals(paginatedOperationModuleName)) {
                    OptionConverters.toJava((Option)importDirective.subElements().elements().find(element -> element.elementName().name().equals(referenceTypeName))).ifPresentOrElse(element -> headerDirectives.addAll(ConnectorTranslatorUtils.splitImports(importDirective, element, operationModuleName)), () -> headerDirectives.add(importDirective));
                } else {
                    headerDirectives.add(importDirective);
                }
            } else if (directive instanceof VersionDirective) {
                headerDirectives.add(directive);
            } else {
                bodyDirectives.add(directive);
            }
        });
        return new ModuleNode(moduleNode.name(), JavaConverters.asScalaBuffer(Stream.concat(headerDirectives.stream(), bodyDirectives.stream()).toList()).toSeq());
    }
}

