/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.appliers;

import com.google.common.collect.Sets;
import com.mulesoft.connectivity.codegen.internal.Helpers;
import com.mulesoft.connectivity.fixengine.MitigationIssue;
import com.mulesoft.connectivity.fixengine.PlatformGapsContext;
import com.mulesoft.connectivity.fixengine.api.FixStrategy;
import com.mulesoft.connectivity.fixengine.api.strategies.TypeStrategySettings;
import com.mulesoft.connectivity.fixengine.appliers.AbstractStrategyApplier;
import com.mulesoft.connectivity.fixengine.helper.AstHelper;
import com.mulesoft.connectivity.fixengine.reconstruction.CompositeTypeRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.ElementInstructionFactory;
import com.mulesoft.connectivity.fixengine.reconstruction.ImportDirectiveRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.ObjectTypeRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.OperationOutputRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.PassthroughBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.RebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.ReplaceValueInstruction;
import com.mulesoft.connectivity.fixengine.reconstruction.TypeDirectiveRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.types.TypeIndexer;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode;
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective;
import org.mule.weave.v2.parser.ast.header.directives.ImportedElements;
import org.mule.weave.v2.parser.ast.header.directives.TypeDirective;
import org.mule.weave.v2.parser.ast.header.directives.VarDirective;
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.KeyNode;
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode;
import org.mule.weave.v2.parser.ast.structure.ObjectNode;
import org.mule.weave.v2.parser.ast.structure.StringNode;
import org.mule.weave.v2.ts.ArrayType;
import org.mule.weave.v2.ts.IntersectionType;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.ReferenceType;
import org.mule.weave.v2.ts.SimpleReferenceType;
import org.mule.weave.v2.ts.UnionType;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public abstract class AbstractTypeStrategyApplier<Settings extends TypeStrategySettings>
extends AbstractStrategyApplier<Settings> {
    private static final String PROCESS_UNTIL_REGEX = ".*\\.%s%s";
    public static final String INPUT_OUTER_ELEMENT_NAME = ".*\\.%s%s".formatted(ValidatableType.INPUT.name(), "(\\.[^\\.]+){2}\\.([^\\.]+)");
    public static final String OUTPUT_OUTER_ELEMENT_NAME = ".*\\.%s%s".formatted(ValidatableType.OUTPUT.name(), "");
    public static final String FIXED_TYPES_MODULE_NAME = "types::Types";
    private Set<String> createdTypes = Sets.newHashSet();

    protected <T extends FixStrategy<Settings>> AbstractTypeStrategyApplier(Class<Settings> settingClass, Class<T> strategyId) {
        super(settingClass, strategyId);
    }

    protected Set<String> getCreatedTypes() {
        return this.createdTypes;
    }

    @Override
    public List<DirectiveNode> process(DirectiveNode directive, String moduleName, PlatformGapsContext context, Settings settings) {
        VarDirective varDirective;
        ImportDirective importDirective;
        if (directive instanceof ImportDirective && (importDirective = (ImportDirective)directive).importedModule().elementName().name().equals(((TypeStrategySettings)settings).getConnectorTypeModule())) {
            return List.of(new ImportDirective(importDirective.importedModule(), new ImportedElements(Helpers.asSeq(JavaConverters.asJavaCollection((Iterable)importDirective.subElements().elements()).stream().filter(element -> this.getCreatedTypes().stream().filter(element.elementName().name()::equals).peek(typeName -> context.typeIndexer().addTypeForImport(moduleName, (String)typeName)).findAny().isEmpty()).toList())), importDirective.codeAnnotations()));
        }
        if (directive instanceof VarDirective && AstHelper.hasAnnotation(varDirective = (VarDirective)directive, "OperationElement")) {
            directive = (DirectiveNode)context.typeIndexer().getOperationReplacementBlueprint(moduleName, OperationOutputRebuildBlueprint.class).map(blueprint -> {
                FunctionCallNode withTransformer = (FunctionCallNode)varDirective.value();
                AstNode operationArg = (AstNode)JavaConverters.seqAsJavaList((Seq)withTransformer.args().args()).get(0);
                ObjectNode transformation = (ObjectNode)JavaConverters.seqAsJavaList((Seq)withTransformer.args().args()).get(1);
                KeyValuePairNode in = (KeyValuePairNode)transformation.elements().find(kv -> "in".equals(((StringNode)((KeyNode)((KeyValuePairNode)kv).key()).keyName()).value())).get();
                KeyNode outKey = new KeyNode((AstNode)new StringNode("out", Helpers.seq()), Option.empty(), Option.empty(), Helpers.seq());
                KeyValuePairNode out = new KeyValuePairNode((AstNode)outKey, (AstNode)blueprint.rebuild(), Option.empty());
                ObjectNode newTransformation = new ObjectNode(Helpers.seq((Object[])new AstNode[]{in, out}), transformation.codeAnnotations());
                FunctionCallParametersNode withTransformerParams = new FunctionCallParametersNode(Helpers.seq((Object[])new AstNode[]{operationArg, newTransformation}));
                FunctionCallNode newWithTransformer = new FunctionCallNode(withTransformer.function(), withTransformerParams, withTransformer.typeParameters(), withTransformer.codeAnnotations());
                return new VarDirective(varDirective.variable(), (AstNode)newWithTransformer, varDirective.wtype(), varDirective.codeAnnotations());
            }).orElse(varDirective);
        }
        return List.of(directive);
    }

    @Override
    public Map<String, ModuleNode> postProcess(PlatformGapsContext context, Settings strategySettings, Map<String, ModuleNode> modules) {
        return modules.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.patchModule(context, AbstractTypeStrategyApplier.getFixedTypesModuleName(modules), (String)entry.getKey(), (ModuleNode)entry.getValue())));
    }

    private ModuleNode patchModule(PlatformGapsContext context, String typesModule, String moduleName, ModuleNode module) {
        if (moduleName.endsWith(FIXED_TYPES_MODULE_NAME)) {
            return module;
        }
        Map<Boolean, List<DirectiveNode>> splitDirectives = JavaConverters.asJavaCollection((Iterable)module.directives()).stream().collect(Collectors.partitioningBy(dir -> dir instanceof ImportDirective || dir instanceof VersionDirective));
        List<DirectiveNode> patchedDirectives = Stream.concat(this.patchImports(context.typeIndexer(), moduleName, typesModule, splitDirectives.get(true)), this.patchDirectives(context.typeIndexer(), moduleName, splitDirectives.get(false))).toList();
        return new ModuleNode(module.name(), Helpers.asSeq(patchedDirectives));
    }

    private Stream<DirectiveNode> patchImports(TypeIndexer typeIndexer, String moduleName, String typesModule, List<DirectiveNode> headerDirectives) {
        return Stream.concat(headerDirectives.stream(), typeIndexer.getImportsForModule(moduleName).map(blueprint -> blueprint.setImportedModule(typesModule)).map(ImportDirectiveRebuildBlueprint::rebuild).stream());
    }

    private Stream<DirectiveNode> patchDirectives(TypeIndexer typeIndexer, String moduleName, List<DirectiveNode> bodyDirectives) {
        return bodyDirectives.stream().map(directive -> Optional.of(directive).filter(TypeDirective.class::isInstance).map(TypeDirective.class::cast).flatMap(typeDirective -> typeIndexer.getOperationReplacementBlueprint(typeDirective.variable().name(), TypeDirectiveRebuildBlueprint.class)).map(RebuildBlueprint::rebuild).map(DirectiveNode.class::cast).orElse((DirectiveNode)directive));
    }

    protected static String getFixedTypesModuleName(Map<String, ModuleNode> modules) {
        return AbstractTypeStrategyApplier.findCommonPrefix(modules.keySet().stream().toList()) + FIXED_TYPES_MODULE_NAME;
    }

    protected void reconstructTypes(PlatformGapsContext context, MitigationIssue issue, String processUntil, String outerTypeName, ElementInstructionFactory instructionFactory) {
        String flowOperationModuleName;
        Validatable parent;
        TypeIndexer typeIndexer = context.typeIndexer();
        Object rootElement = issue.validatable().getElement();
        Validatable v = issue.validatable();
        WeaveType element = null;
        while (v != null && !v.pathDescription().matches(processUntil)) {
            element = (WeaveType)v.getElement();
            Validatable parent2 = v.getParent();
            if (parent2 != null) {
                Object object = parent2.getElement();
                if (object instanceof ObjectType) {
                    ObjectType objectParent = (ObjectType)object;
                    if (element.equals(rootElement)) {
                        typeIndexer.addObjectTypeReplacement(objectParent, instructionFactory.build((DWType)rootElement));
                    } else {
                        typeIndexer.addObjectTypeReplacement(objectParent);
                    }
                } else {
                    object = parent2.getElement();
                    if (object instanceof SimpleReferenceType) {
                        SimpleReferenceType referenceParent = (SimpleReferenceType)object;
                        this.addTypeDirective(context, issue, (DWType)referenceParent, element, referenceParent.referenceName());
                        this.createdTypes.add(referenceParent.referenceName());
                    } else {
                        object = parent2.getElement();
                        if (object instanceof IntersectionType) {
                            IntersectionType intersectionParent = (IntersectionType)object;
                            typeIndexer.computeTypeReplacement((DWType)intersectionParent, () -> CompositeTypeRebuildBlueprint.intersection(this.getRebuildBlueprints((Seq<WeaveType>)intersectionParent.of(), typeIndexer), typeIndexer));
                        } else {
                            object = parent2.getElement();
                            if (object instanceof UnionType) {
                                UnionType unionParent = (UnionType)object;
                                typeIndexer.computeTypeReplacement((DWType)unionParent, () -> CompositeTypeRebuildBlueprint.union(this.getRebuildBlueprints((Seq<WeaveType>)unionParent.of(), typeIndexer), typeIndexer));
                            } else {
                                object = parent2.getElement();
                                if (object instanceof ArrayType) {
                                    ArrayType arrayParent = (ArrayType)object;
                                    typeIndexer.addArrayTypeReplacement(arrayParent);
                                }
                            }
                        }
                    }
                }
            }
            v = parent2;
        }
        ReferenceType elementReference = this.getElementReference(element, outerTypeName);
        if (element != null) {
            typeIndexer.addTypeForImport(element.getLocation().getResourceIdentifier().getFQNIdentifier(), elementReference.referenceName());
        }
        Validatable validatable = parent = v != null ? v.getParent() : null;
        if (parent != null && parent.hasAnyContext(new ValidatableType[]{ValidatableType.INPUT})) {
            if (element != null) {
                typeIndexer.addTypeForImport(element.getLocation().getResourceIdentifier().getFQNIdentifier(), elementReference.referenceName());
            }
            flowOperationModuleName = String.join((CharSequence)"::", context.getOperationLocations().get(issue.getRootValidatableNameOrEmpty()).getModuleParts());
            typeIndexer.addTypeForImport(flowOperationModuleName, elementReference.referenceName());
            ObjectTypeRebuildBlueprint blueprint = new ObjectTypeRebuildBlueprint((ObjectType)parent.getElement(), typeIndexer);
            ReplaceValueInstruction instruction = new ReplaceValueInstruction((String)v.getName().orElseThrow(), (DWType)elementReference);
            blueprint.addInstruction(instruction);
            Optional.ofNullable(parent.getParent()).map(Validatable::getElement).map(Object::toString).ifPresent(grandParentElementString -> typeIndexer.addOperationReplacement((String)grandParentElementString, new TypeDirectiveRebuildBlueprint((String)grandParentElementString, blueprint, typeIndexer)));
        }
        if (issue.validatable().hasAnyContext(new ValidatableType[]{ValidatableType.OUTPUT})) {
            flowOperationModuleName = String.join((CharSequence)"::", context.getOperationLocations().get(issue.getRootValidatableNameOrEmpty()).getModuleParts());
            typeIndexer.addTypeForImport(flowOperationModuleName, elementReference.referenceName());
            typeIndexer.addOperationReplacement(flowOperationModuleName, new OperationOutputRebuildBlueprint(elementReference, typeIndexer));
        }
        if (element != null && !(element instanceof ReferenceType) && v != null && v.getParent() != null) {
            this.addTypeDirective(context, issue, (DWType)v.getParent().getElement(), element, elementReference.referenceName());
        }
    }

    private List<RebuildBlueprint<?>> getRebuildBlueprints(Seq<WeaveType> types, TypeIndexer typeIndexer) {
        return JavaConverters.asJavaCollection(types).stream().map(type -> this.getTypeRebuildBlueprint((WeaveType)type, typeIndexer)).collect(Collectors.toUnmodifiableList());
    }

    private RebuildBlueprint<?> getTypeRebuildBlueprint(WeaveType type, TypeIndexer typeIndexer) {
        if (!(type instanceof SimpleReferenceType)) {
            return typeIndexer.getTypeReplacement((DWType)type).orElseGet(() -> new PassthroughBlueprint((DWType)type, typeIndexer));
        }
        return new PassthroughBlueprint((DWType)type, typeIndexer);
    }

    private void addTypeDirective(PlatformGapsContext context, MitigationIssue issue, DWType referenceParent, WeaveType element, String newTypeName) {
        context.addMitigationRewrittenTypeMessage(issue, newTypeName, this.getStrategyId());
        context.typeIndexer().addTypeDirectiveReplacement(referenceParent, (DWType)element, newTypeName);
    }

    private ReferenceType getElementReference(@Nullable WeaveType element, String defaultElementName) {
        if (element instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)element;
            return referenceType;
        }
        return new SimpleReferenceType(Helpers.nameNode((String)defaultElementName), Option.empty(), null);
    }

    public static String findCommonPrefix(List<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return "";
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        String reference = strings.get(0);
        if (reference == null) {
            return "";
        }
        for (int i = 0; i < reference.length(); ++i) {
            char currentChar = reference.charAt(i);
            for (int j = 1; j < strings.size(); ++j) {
                String currentString = strings.get(j);
                if (currentString != null && i < currentString.length() && currentString.charAt(i) == currentChar) continue;
                return reference.substring(0, i);
            }
        }
        return reference;
    }
}

