/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.appliers;

import com.mulesoft.connectivity.fixengine.PlatformGapsContext;
import com.mulesoft.connectivity.fixengine.api.FixStrategy;
import com.mulesoft.connectivity.fixengine.api.StrategySettings;
import com.mulesoft.connectivity.fixengine.appliers.StrategyApplier;
import java.util.List;
import java.util.Map;
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode;
import org.mule.weave.v2.parser.ast.module.ModuleNode;

public abstract class AbstractStrategyApplier<Settings extends StrategySettings>
implements StrategyApplier<Settings> {
    private final Class<Settings> settingsClass;
    private final Class<? extends FixStrategy<Settings>> strategyId;

    protected <T extends FixStrategy<Settings>> AbstractStrategyApplier(Class<Settings> settingsClass, Class<T> strategiId) {
        this.settingsClass = settingsClass;
        this.strategyId = strategiId;
    }

    @Override
    public <T extends StrategySettings> Settings accept(T maybeSettings) {
        if (!this.settingsClass.isInstance(maybeSettings)) {
            throw new IllegalArgumentException("Unsupported strategy settings " + String.valueOf(maybeSettings));
        }
        return (Settings)((StrategySettings)this.settingsClass.cast(maybeSettings));
    }

    @Override
    public List<DirectiveNode> process(DirectiveNode directive, String moduleName, PlatformGapsContext context, Settings settings) {
        return List.of(directive);
    }

    @Override
    public Map<String, ModuleNode> preProcess(Map<String, ModuleNode> modules, PlatformGapsContext context, Settings settings) {
        return modules;
    }

    @Override
    public Map<String, ModuleNode> postProcess(PlatformGapsContext context, Settings strategySettings, Map<String, ModuleNode> modules) {
        return modules;
    }

    @Override
    public String getStrategyId() {
        return this.strategyId.getName();
    }
}

