/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.appliers;

import com.mulesoft.connectivity.fixengine.PlatformGapsContext;
import com.mulesoft.connectivity.fixengine.api.FixStrategy;
import com.mulesoft.connectivity.fixengine.api.StrategySettings;
import com.mulesoft.connectivity.fixengine.appliers.AbstractStrategyApplier;
import com.mulesoft.connectivity.fixengine.helper.AstHelper;
import java.util.Collection;
import java.util.List;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.VarDirective;
import org.mule.weave.v2.parser.ast.structure.KeyNode;
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode;
import org.mule.weave.v2.parser.ast.structure.ObjectNode;
import org.mule.weave.v2.parser.ast.structure.StringNode;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

public abstract class AbstractVarDirectiveStrategyApplier<T extends StrategySettings>
extends AbstractStrategyApplier<T> {
    protected <S extends FixStrategy<T>> AbstractVarDirectiveStrategyApplier(Class<T> settingsClass, Class<S> strategiId) {
        super(settingsClass, strategiId);
    }

    @Override
    public List<DirectiveNode> process(DirectiveNode directive, String moduleName, PlatformGapsContext context, T settings) {
        VarDirective varDirective;
        if (directive instanceof VarDirective && AstHelper.hasAnnotation(varDirective = (VarDirective)directive, this.getConnectorAnnotation(settings)) && !this.shouldSkipProcessing(context)) {
            return this.processConnectorDirective(varDirective, context, settings);
        }
        return List.of(directive);
    }

    protected abstract boolean shouldSkipProcessing(PlatformGapsContext var1);

    protected abstract List<DirectiveNode> processConnectorDirective(VarDirective var1, PlatformGapsContext var2, T var3);

    protected abstract String getConnectorAnnotation(T var1);

    protected Collection<AstNode> getNodes(VarDirective varDirective, String keyName) {
        AstNode astNode = varDirective.value();
        if (!(astNode instanceof ObjectNode)) {
            throw new IllegalArgumentException("Could not find object node in varDirective");
        }
        ObjectNode nodeElements = (ObjectNode)astNode;
        KeyValuePairNode keyValue = (KeyValuePairNode)nodeElements.children().find(node -> this.isRequiredKeyValueNode((AstNode)node, keyName)).getOrElse(() -> {
            throw new IllegalArgumentException("Could not find operation list in varDirective");
        });
        return JavaConverters.asJavaCollection((Iterable)keyValue.value().children());
    }

    protected boolean isRequiredKeyValueNode(AstNode node, String keyName) {
        StringNode stringNode;
        KeyNode key;
        KeyValuePairNode keyValuePair;
        AstNode astNode;
        return node instanceof KeyValuePairNode && (astNode = (keyValuePair = (KeyValuePairNode)node).key()) instanceof KeyNode && (astNode = (key = (KeyNode)astNode).keyName()) instanceof StringNode && keyName.equals((stringNode = (StringNode)astNode).value());
    }
}

