/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.utils;

import com.mulesoft.connectivity.fixengine.utils.fakefile.Handler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import java.util.stream.Collectors;

public class VirtualFSClassLoader
extends URLClassLoader {
    public static final String PATH_SEPARATOR = "/";
    private final Map<String, String> resources;
    private final Handler handler;

    public static VirtualFSClassLoader create(Map<String, String> resourceMap, ClassLoader parent) {
        Handler.register();
        Map<String, String> normalizedResourceMap = resourceMap.entrySet().stream().collect(Collectors.toMap(e -> VirtualFSClassLoader.normalizePath((String)e.getKey()), Map.Entry::getValue));
        return new VirtualFSClassLoader(normalizedResourceMap, parent, new Handler(normalizedResourceMap));
    }

    private VirtualFSClassLoader(Map<String, String> resourceMap, ClassLoader parent, Handler handler) {
        super(VirtualFSClassLoader.generateResources(resourceMap, handler), parent);
        this.resources = resourceMap;
        this.handler = handler;
    }

    @Override
    public Enumeration<URL> findResources(final String name) throws IOException {
        if (this.resources.keySet().stream().noneMatch(resource -> resource.equals(PATH_SEPARATOR + name) || resource.equals(name))) {
            return super.findResources(name);
        }
        return new Enumeration<URL>(){
            private final URL url;
            private boolean hasNext;
            {
                this.url = VirtualFSClassLoader.writeFakeFile(name, VirtualFSClassLoader.this.handler);
                this.hasNext = true;
            }

            private boolean next() {
                return this.hasNext;
            }

            @Override
            public URL nextElement() {
                this.hasNext = false;
                return this.url;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }
        };
    }

    private static URL[] generateResources(Map<String, String> resourceMap, Handler handler) {
        return (URL[])resourceMap.keySet().stream().map(path -> VirtualFSClassLoader.writeFakeFile(path, handler)).distinct().toArray(URL[]::new);
    }

    private static URL writeFakeFile(String reference, Handler handler) {
        try {
            URI uri = new URI("fakefile://" + VirtualFSClassLoader.normalizePath(reference));
            return new URL(null, uri.toString(), handler);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String normalizePath(String path) {
        return path.startsWith(PATH_SEPARATOR) ? path : PATH_SEPARATOR + path;
    }
}

