/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.flow.api.model.FlowConnectionProviderModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorDescriptorModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.IconMetadata;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NullType;

class FlowConnectorDescriptorModelTest {
    FlowConnectorDescriptorModelTest() {
    }

    @Test
    void serializationTest() throws Exception {
        String CONNECTOR_MODEL = "FlowStaticConnectorModelTest001.json";
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("FlowStaticConnectorModelTest001.json");
        if (is == null) {
            throw new Exception("Failed to load FlowStaticConnectorModelTest001.json");
        }
        String originalJson = new String(is.readAllBytes(), StandardCharsets.UTF_8);
        IconMetadata iconMetadata = new IconMetadata.Builder().withName("Twilio").withAlternateText("Twilio Connector").withResource("icon/twilio.svg").build();
        TypeModel nullType = (TypeModel)new TypeModel.Builder().withDataType((DWType)Mockito.mock(NullType.class)).build();
        FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)new FlowConnectionProviderModel.Builder().inputType(nullType)).name("connection")).build();
        OperationModel operationModel = (OperationModel)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)new OperationModel.Builder().withName("operation")).withDisplayName("an operation")).withInputType(nullType)).withOutputType(nullType)).withErrorOutputType(nullType)).build();
        FlowConnectorModel flowConnectorModel = ((FlowConnectorModel.Builder)((FlowConnectorModel.Builder)((FlowConnectorModel.Builder)((FlowConnectorModel.Builder)((FlowConnectorModel.Builder)new FlowConnectorModel.Builder().withName("TWILIO")).withModelReference("com::mulesoft::connectivity::twilio::Connector")).withVersion("1.0.0").withDisplayName("Twilio")).withReleaseStatus(ReleaseStatus.GA).withDescription("Twilio Connector").withIcons(Collections.singletonList(iconMetadata)).withVendor("Salesforce").withSince("R256").withConnections(Collections.singletonList(connectionModel))).withOperations(Collections.singletonList(operationModel))).withTestConnection((TestConnectionModel)new TestConnectionModel.Builder().build()).build();
        FlowConnectorDescriptorModel.Builder flowConnectorDescriptorModelBuilder = new FlowConnectorDescriptorModel.Builder();
        String string = "January 2, 2010";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z");
        ZonedDateTime createdDate = ZonedDateTime.parse("2024-05-15 12:30:30 Europe/Paris", formatter);
        ZonedDateTime lastModifiedDate = ZonedDateTime.parse("2024-05-16 12:30:30 Europe/Paris", formatter);
        Date currentDate = new Date();
        FlowConnectorDescriptorModel flowStaticModel = flowConnectorDescriptorModelBuilder.fromConnectorModel(flowConnectorModel).withVersion("1.0.0").withCreatedDate(createdDate).withLastModifiedDate(lastModifiedDate).build();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonModel = gson.toJson((Object)flowStaticModel);
        MatcherAssert.assertThat((Object)jsonModel, (Matcher)Matchers.equalTo((Object)originalJson.trim()));
    }
}

