/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.model.servicemodel.r256;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.flow.api.loader.FlowModelLoaderFactory;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.persistence.FlowModelSerializer;
import com.mulesoft.connectivity.flow.api.servicemodel.ReleaseServiceModelSerializer;
import com.mulesoft.connectivity.flow.api.servicemodel.ReleaseServiceModelSerializerFactory;
import com.mulesoft.connectivity.flow.api.servicemodel.SalesforceRelease;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public class GoldFileTest {
    private static final String MODEL_FILE_PATTERN = "servicemodel/r256/serialized-models/%s";
    private static final String GOLDFILE_PATTERN = "servicemodel/r256/service-goldfiles/%s";
    private final Map<String, String> CONNECTORS = new HashMap<String, String>();
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
    private final LanguageModelLoader<FlowConnectorModel, FlowConnectorModel.Builder> linkWeaveLoader = new LanguageModelLoader(this.dataWeaveScriptingEngine, (ModelLoader)new FlowModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"Metadata::TestConnector"));

    public GoldFileTest() {
        this.CONNECTORS.put("abstractcompanyenrichment-0.1.14.ic", "abstractcompanyenrichment-0.1.14-service.json");
        this.CONNECTORS.put("abstractemailvalidator-0.1.19.ic", "abstractemailvalidator-0.1.19-service.json");
        this.CONNECTORS.put("abstractphonevalidator-0.1.16.ic", "abstractphonevalidator-0.1.16-service.json");
        this.CONNECTORS.put("anthropic-0.1.30.ic", "anthropic-0.1.30-service.json");
        this.CONNECTORS.put("asana-0.1.42.ic", "asana-0.1.42-service.json");
        this.CONNECTORS.put("bloomfire-0.1.21.ic", "bloomfire-0.1.21-service.json");
        this.CONNECTORS.put("calendly-0.1.15.ic", "calendly-0.1.15-service.json");
        this.CONNECTORS.put("chargify-0.1.24.ic", "chargify-0.1.24-service.json");
        this.CONNECTORS.put("clockify-0.1.39.ic", "clockify-0.1.39-service.json");
        this.CONNECTORS.put("courier-0.1.9.ic", "courier-0.1.9-service.json");
        this.CONNECTORS.put("dhltracking-0.1.33.ic", "dhltracking-0.1.33-service.json");
        this.CONNECTORS.put("discord-0.1.21.ic", "discord-0.1.21-service.json");
        this.CONNECTORS.put("eventbrite-0.1.40.ic", "eventbrite-0.1.40-service.json");
        this.CONNECTORS.put("freshdesk-0.1.67.ic", "freshdesk-0.1.67-service.json");
        this.CONNECTORS.put("gemini-0.1.36.ic", "gemini-0.1.36-service.json");
        this.CONNECTORS.put("guru-0.1.116.ic", "guru-0.1.116-service.json");
        this.CONNECTORS.put("hubspot-0.1.46.ic", "hubspot-0.1.46-service.json");
        this.CONNECTORS.put("intercom-0.1.27.ic", "intercom-0.1.27-service.json");
        this.CONNECTORS.put("moosend-0.1.38.ic", "moosend-0.1.38-service.json");
        this.CONNECTORS.put("ms-entra-id-0.1.42.ic", "ms-entra-id-0.1.42-service.json");
        this.CONNECTORS.put("ms-excel365-0.1.9.ic", "ms-excel365-0.1.9-service.json");
        this.CONNECTORS.put("openai-0.1.49.ic", "openai-0.1.49-service.json");
        this.CONNECTORS.put("openweathermap-0.1.27.ic", "openweathermap-0.1.27-service.json");
        this.CONNECTORS.put("outlook-0.1.28.ic", "outlook-0.1.28-service.json");
        this.CONNECTORS.put("pagerduty-0.1.16.ic", "pagerduty-0.1.16-service.json");
        this.CONNECTORS.put("paypal-0.1.42.ic", "paypal-0.1.42-service.json");
        this.CONNECTORS.put("powerbi-0.1.9.ic", "powerbi-0.1.9-service.json");
        this.CONNECTORS.put("qualtrics-0.1.16.ic", "qualtrics-0.1.16-service.json");
        this.CONNECTORS.put("quickbooks-0.1.39.ic", "quickbooks-0.1.39-service.json");
        this.CONNECTORS.put("salesforcemarketingcloud-0.1.20.ic", "salesforcemarketingcloud-0.1.20-service.json");
        this.CONNECTORS.put("signupgenius-0.1.18.ic", "signupgenius-0.1.18-service.json");
        this.CONNECTORS.put("square-0.1.25.ic", "square-0.1.25-service.json");
        this.CONNECTORS.put("surveymonkey-0.1.24.ic", "surveymonkey-0.1.24-service.json");
        this.CONNECTORS.put("twilio-0.1.12.ic", "twilio-0.1.12-service.json");
        this.CONNECTORS.put("wordpress-0.1.27.ic", "wordpress-0.1.27-service.json");
        this.CONNECTORS.put("zendesk-0.1.53.ic", "zendesk-0.1.53-service.json");
        this.CONNECTORS.put("zuora-0.1.13.ic", "zuora-0.1.13-service.json");
        this.CONNECTORS.put("jira-1.1.0-139.develop.ic", "jira-1.1.0-139.develop-service.json");
        this.CONNECTORS.put("netsuite-1.1.0-37.develop.ic", "netsuite-1.1.0-37.develop-service.json");
        this.CONNECTORS.put("salesforce-1.1.0-81.develop.ic", "salesforce-1.1.0-81.develop-service.json");
    }

    private static Stream<Arguments> provideConnectorTestCases() {
        GoldFileTest test = new GoldFileTest();
        return test.CONNECTORS.entrySet().stream().map(entry -> Arguments.of((Object[])new Object[]{entry.getKey(), entry.getValue()}));
    }

    @ParameterizedTest(name="Test connector: {0}")
    @MethodSource(value={"provideConnectorTestCases"})
    public void testConnector(String modelFile, String serviceFile) throws Exception {
        this.compare(String.format(MODEL_FILE_PATTERN, modelFile), String.format(GOLDFILE_PATTERN, serviceFile));
    }

    private void compare(String serializedModelFile, String serializedServiceFile) throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FlowModelSerializer fms = new FlowModelSerializer();
        InputStream serializedModel = this.getClass().getClassLoader().getResourceAsStream(serializedModelFile);
        assert (serializedModel != null) : "Could not load serialized model: " + serializedModelFile;
        InputStreamReader serializedModelReader = new InputStreamReader(serializedModel);
        FlowConnectorModel connectorModel = fms.deserialize((Map)gson.fromJson((Reader)serializedModelReader, Object.class));
        StringWriter writer = new StringWriter();
        ReleaseServiceModelSerializer r256 = new ReleaseServiceModelSerializerFactory().getGreatestSerializerFor(SalesforceRelease.R256);
        r256.serialize(connectorModel, (Writer)writer);
        InputStream expectedIs = this.getClass().getClassLoader().getResourceAsStream(serializedServiceFile);
        assert (expectedIs != null) : "Failed to load serialized service: " + serializedServiceFile;
        String expectedRaw = new String(expectedIs.readAllBytes(), Charset.defaultCharset());
        String expectedJson = gson.toJson(gson.fromJson(expectedRaw, Object.class));
        Assertions.assertEquals((Object)expectedJson, (Object)writer.toString(), (String)("Serialized JSON does not match for " + serializedModelFile));
    }
}

