/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.servicemodel;

import com.mulesoft.connectivity.flow.api.servicemodel.ReleaseServiceModelSerializer;
import com.mulesoft.connectivity.flow.api.servicemodel.ReleaseServiceModelSerializerFactory;
import com.mulesoft.connectivity.flow.api.servicemodel.SalesforceRelease;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@DisplayName(value="Release Service Model Serializer Factory Tests")
class ReleaseServiceModelSerializerFactoryTest {
    private ReleaseServiceModelSerializerFactory factory;

    ReleaseServiceModelSerializerFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.factory = new ReleaseServiceModelSerializerFactory();
    }

    @Test
    @DisplayName(value="Should return serializers correctly for minimum release without duplicates")
    void shouldHandleMinimumReleaseCorrectly() {
        List serializers = this.factory.getSerializersFor(SalesforceRelease.R256);
        Assertions.assertNotNull((Object)serializers, (String)"Should handle minimum release correctly");
        Assertions.assertEquals((int)1, (int)serializers.size(), (String)"Should return only one serializer without duplicates");
        Assertions.assertEquals((Object)SalesforceRelease.R256, (Object)((ReleaseServiceModelSerializer)serializers.get(0)).getSalesforceRelease(), (String)"Should return R256 as the only compatible serializer");
    }

    @Nested
    @DisplayName(value="Multiple Serializers Creation")
    class MultipleSerializersCreation {
        MultipleSerializersCreation() {
        }

        @Test
        @DisplayName(value="Should create serializer list for R256 target with highest compatible first")
        void shouldCreateSerializersForR256Target() {
            List serializers = ReleaseServiceModelSerializerFactoryTest.this.factory.getSerializersFor(SalesforceRelease.R256);
            Assertions.assertEquals((int)1, (int)serializers.size(), (String)"Should return only R256 serializeer as it's the only compatible one");
            Assertions.assertEquals((Object)SalesforceRelease.R256, (Object)((ReleaseServiceModelSerializer)serializers.get(0)).getSalesforceRelease(), (String)"Should return R256 as the highest compatible serializer");
        }

        @Test
        @DisplayName(value="Should create serializers list for R258 target including all compatible versions")
        void shouldCreateSerializersForR258Target() {
            List serializers = ReleaseServiceModelSerializerFactoryTest.this.factory.getSerializersFor(SalesforceRelease.R258);
            Assertions.assertEquals((int)1, (int)serializers.size(), (String)"Should return compatible serializers without duplicates");
            Assertions.assertEquals((Object)SalesforceRelease.R256, (Object)((ReleaseServiceModelSerializer)serializers.get(0)).getSalesforceRelease(), (String)"Serializer should be R256 as the other compatible serializer");
        }
    }

    @Nested
    @DisplayName(value="Single Serializer Retrieval")
    class SingleSerializerRetrieval {
        SingleSerializerRetrieval() {
        }

        @Test
        @DisplayName(value="Should return correct serializer for R256 release")
        void shouldReturnCorrectSerializerForR256() {
            ReleaseServiceModelSerializer serializer = ReleaseServiceModelSerializerFactoryTest.this.factory.getGreatestSerializerFor(SalesforceRelease.R256);
            Assertions.assertNotNull((Object)serializer, (String)"Serializer should not be null");
            Assertions.assertEquals((Object)SalesforceRelease.R256, (Object)serializer.getSalesforceRelease(), (String)"Serializer should correspond to R256 release");
        }

        @Test
        @DisplayName(value="Should return correct serializer for R258 release")
        void shouldReturnCorrectSerializerForR258() {
            ReleaseServiceModelSerializer serializer = ReleaseServiceModelSerializerFactoryTest.this.factory.getGreatestSerializerFor(SalesforceRelease.R258);
            Assertions.assertNotNull((Object)serializer, (String)"Serializer should not be null");
            Assertions.assertEquals((Object)SalesforceRelease.R256, (Object)serializer.getSalesforceRelease(), (String)"Serializer should correspond to R256 release");
        }

        @Test
        @DisplayName(value="Should return correct serializer for R260 release")
        void shouldReturnCorrectSerializerForR260() {
            ReleaseServiceModelSerializer serializer = ReleaseServiceModelSerializerFactoryTest.this.factory.getGreatestSerializerFor(SalesforceRelease.R260);
            Assertions.assertNotNull((Object)serializer, (String)"Serializer should not be null");
            Assertions.assertEquals((Object)SalesforceRelease.R256, (Object)serializer.getSalesforceRelease(), (String)"Serializer should correspond to R256 release");
        }
    }
}

