/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowConnectionsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.NoDynamicNamesRule;
import com.mulesoft.connectivity.flow.api.validator.rules.UnionRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.rules.ArrayRule;
import com.mulesoft.connectivity.validation.rules.ExecutorRule;
import com.mulesoft.connectivity.validation.rules.MessageRule;
import com.mulesoft.connectivity.validation.rules.ObjectRule;
import com.mulesoft.connectivity.validation.rules.ProviderReferenceRule;
import com.mulesoft.connectivity.validation.rules.ReferenceRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ConnectionValidatorTest
extends AbstractValidatorTest {
    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowConnectionsRule.class, ExecutorRule.class, MessageRule.class, ReferenceRule.class, ObjectRule.class, UnionRule.class, NoDynamicNamesRule.class, ArrayRule.class, ProviderReferenceRule.class});
    }

    @Test
    void acceptsNoConnectionsConnector() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    operations: {testOperation: {}},\n    triggers: {testTrigger: {}},\n    valueProviders: {testValueProvider: {}},\n}");
    }

    @Test
    void acceptsEmptyConnections() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: {},\n}");
    }

    @Test
    void acceptsOneConnection() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: {connectionDef: {}},\n}");
    }

    @Test
    void failsMoreThanOneConnection() {
        CollectedMessages messages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: {connection1: {}, connection2: {}},\n}");
        MatcherAssert.assertThat(messages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        ConnectionValidatorTest.assertValidationMessage(messages.getErrors().get(0), "Property 'connections' contains more than one connection", "connector", "\n8|     connections: {connection1: {}, connection2: {}},\n       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void failsIfPropertyConnectionIsNotObject() {
        CollectedMessages messages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: []\n}");
        MatcherAssert.assertThat(messages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        ConnectionValidatorTest.assertValidationMessage(messages.getErrors().get(0), "Invalid type for property 'connections'. Expected: Object; Actual: Array<Nothing>", "connector", "\n8|     connections: []\n       ^^^^^^^^^^^^^^^");
    }
}

