/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowMetadataProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowOperationsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowValueProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.NoDynamicNamesRule;
import com.mulesoft.connectivity.flow.api.validator.rules.UnionRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.rules.ArrayRule;
import com.mulesoft.connectivity.validation.rules.ExecutorRule;
import com.mulesoft.connectivity.validation.rules.MessageRule;
import com.mulesoft.connectivity.validation.rules.MetadataProviderRule;
import com.mulesoft.connectivity.validation.rules.ObjectRule;
import com.mulesoft.connectivity.validation.rules.OperationRule;
import com.mulesoft.connectivity.validation.rules.ProviderReferenceRule;
import com.mulesoft.connectivity.validation.rules.ReferenceRule;
import com.mulesoft.connectivity.validation.rules.ValueProviderRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class MetadataProviderValidatorTest
extends AbstractValidatorTest {
    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowValueProvidersRule.class, FlowMetadataProvidersRule.class, FlowOperationsRule.class, ValueProviderRule.class, MetadataProviderRule.class, OperationRule.class, ExecutorRule.class, MessageRule.class, ReferenceRule.class, ObjectRule.class, UnionRule.class, NoDynamicNamesRule.class, ArrayRule.class, ProviderReferenceRule.class});
    }

    @Test
    void acceptsConnectorWithValidMetaDataPropertyType() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    },\n}\n");
    }

    @Test
    void acceptsConnectorWithValidMetaDataPropertyRefType() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\ntype ParameterInputTypeRef = {  id : String }\nvar metadataProvider: MetadataProviderExecutor<ParameterInputTypeRef, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    },\n}\n");
    }

    @Test
    void rejectsConnectorWithInValidMetaDataPropertyType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<Number, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    },\n}\n");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        MetadataProviderValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for metadata provider input type. Expected: Object; Actual: Number", "connector", "\n47|       metadataProvider: metadataProvider\n                            ^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInValidMetaDataPropertyRefType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\ntype ParameterInputTypeRef = {  id : String } & { item : String}\nvar metadataProvider: MetadataProviderExecutor<ParameterInputTypeRef, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    },\n}\n");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        MetadataProviderValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for metadata provider input type. Expected: Object; Actual: { id: String } & { item: String }", "connector", "\n48|       metadataProvider: metadataProvider\n                            ^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInValidMetaDataPropertyNullType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<Null, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    },\n}\n");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        MetadataProviderValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for metadata provider input type. Expected: Object; Actual: Null", "connector", "\n47|       metadataProvider: metadataProvider\n                            ^^^^^^^^^^^^^^^^");
    }

    @Test
    void acceptsConnectorWithValidMetaDataPropertyEmptyObjectType() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    },\n}\n");
    }

    @Test
    void acceptsConnectorWithNoMetaDataProperty() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<Null, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\n}\n");
    }

    @Test
    void rejectsConnectorWithNonObjectMetaDataProperty() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar metadataProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\n    metadataProviders: String\n}\n");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        MetadataProviderValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for property 'metadataProviders'. Expected: Object; Actual: Type<String>", "connector", "\n46|     metadataProviders: String\n        ^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInvalidDynamicMetadataReferenceValueTest() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProviderWithArray: MetadataProviderExecutor<{objectType: Array<String>}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    success(accountType)\ntype InputType = {\n  objectType: Array<String>,\n  field: @MetadataProvider(value = { name: \"metadataProviderWithArray\", arguments: {\"objectType\": \"/objectType\"} }) Object\n}\nvar createRecordOperation: Operation<InputType, {}, ResultFailure<{}, Error>, HttpConnection> = { \nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({ }) \n} \n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProviderWithArray: metadataProviderWithArray\n    }\n}\n");
        MetadataProviderValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Array type arguments are not allowed for dynamic metadata providers", "connector", "\n81| type Executor<InputType <: Object, ResultType, ResultErrorType <: ResultFailure, ConnectionType <: Connection> = (InputType, ConnectionType) -> Result<ResultType, ResultErrorType>\n                                                                                                                      ^^^^^^^^^");
    }
}

