/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mulesoft.connectivity.flow.fixtures.QueryBuilderTestUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.BindingSupport;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OperationKind;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.provider.TypeReferenceExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

@DisplayName(value="BindingSupport - Complete JSON Binding Validation")
class BindingSupportTest {
    private BindingSupport bindingSupport;
    private final JsonParser JSON_PARSER = new JsonParser();

    BindingSupportTest() {
    }

    @BeforeEach
    void setUp() {
        this.bindingSupport = new BindingSupport();
    }

    private OperationModel createMockOperationModelWithQueryBuilder() {
        return this.createOperationModel(true, Map.of(), null);
    }

    private OperationModel createOperationModel(boolean isQueryBuilder, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvedProviders, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> outputResolvedProviders) {
        TypeModel inputType = (TypeModel)Mockito.mock(TypeModel.class);
        DWType dwType = isQueryBuilder ? QueryBuilderTestUtils.compileScript("%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.limit\")\nannotation FieldLimit(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"ValuesFrom\")\nannotation ValuesFrom(value: {name: String, arguments?: Object} = {name: \"\"})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: { key: String, defaultSelection?: String })\n\ntype QueryFieldNoOrder = {|\n    kind: \"NOT_SORTED\"\n|}\n\ntype QueryOrder = \"ASC\" | \"DESC\"\n\ntype QueryFieldOrder = {|\n    kind: \"SORTED\"\n|}\n\ntype QueryFieldOrderPair<F <: String> = {|\n   field: F,\n   order: QueryOrder\n|}\n\ntype QueryManyFieldsManySortingOrder<F <: String> = QueryFieldOrder & {|\n    fields: Array<QueryFieldOrderPair<F>>\n|}\n\ntype OperationWithFullQB = @QueryBuilder() {\n    objectType: @ValuesFrom(value = {name: \"queryBuilderObjectsValueProvider\"}) String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String,\n    orderBy: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() QueryFieldNoOrder | QueryManyFieldsManySortingOrder<String>,\n    limit: @FieldLimit() Number\n}\n---\nOperationWithFullQB\n") : this.createBasicDWType();
        Mockito.when((Object)inputType.getDataType()).thenReturn((Object)dwType);
        return (OperationModel)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)OperationModel.builder().withName("operationName")).withDisplayName("display name")).withOutputType((TypeModel)Mockito.mock(TypeModel.class))).withInputType(inputType)).withErrorOutputType((TypeModel)Mockito.mock(TypeModel.class))).resolvedInputProviders(inputResolvedProviders)).resolvedOutputProviders(outputResolvedProviders)).build();
    }

    private DWType createBasicDWType() {
        String basicScript = "%dw 2.8\n\ntype BasicType = {\n    field: String\n}\n---\nBasicType\n";
        return QueryBuilderTestUtils.compileScript(basicScript);
    }

    private OperationModel createOperationModelWithInputResolvedProviders(String providersJson) {
        return this.createOperationModel(false, this.parseResolvedProviders(providersJson), null);
    }

    private OperationModel createOperationModelWithQueryBuilderInputResolvedProviders(String providersJson) {
        return this.createOperationModel(true, this.parseResolvedProviders(providersJson), null);
    }

    private OperationModel createOperationModelWithOutputResolvedProviders(String providersJson) {
        return this.createOperationModel(false, null, this.parseResolvedProviders(providersJson));
    }

    private Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> parseResolvedProviders(String json) {
        if (json == null || json.trim().isEmpty()) {
            return Map.of();
        }
        HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> result = new HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences>();
        JsonElement jsonElement = this.JSON_PARSER.parse(json);
        JsonObject rootObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : rootObject.entrySet()) {
            String fieldName = (String)entry.getKey();
            JsonObject fieldConfig = ((JsonElement)entry.getValue()).getAsJsonObject();
            String valueProvider = null;
            String typeProvider = null;
            ArrayList<ProviderArgument> dependencies = new ArrayList<ProviderArgument>();
            if (fieldConfig.has("valueProvider")) {
                valueProvider = fieldConfig.get("valueProvider").getAsString();
            }
            if (fieldConfig.has("typeProvider")) {
                typeProvider = fieldConfig.get("typeProvider").getAsString();
            }
            if (fieldConfig.has("dependencies")) {
                JsonObject deps = fieldConfig.get("dependencies").getAsJsonObject();
                for (Map.Entry depEntry : deps.entrySet()) {
                    String paramPath = (String)depEntry.getKey();
                    String inputPath = ((JsonElement)depEntry.getValue()).getAsString();
                    dependencies.add(new ProviderArgument(new ObjectFieldSelector(true, List.of(paramPath)), (TypeReferenceExpression)new ObjectFieldSelector(false, List.of(inputPath))));
                }
            }
            this.addProviderToMap(result, fieldName, valueProvider, typeProvider, dependencies);
        }
        return result;
    }

    private void addProviderToMap(Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> map, String fieldName, String valueProvider, String typeProvider, List<ProviderArgument> dependencies) {
        ProviderReference vpRef = valueProvider != null ? new ProviderReference(valueProvider, dependencies) : null;
        ProviderReference tpRef = typeProvider != null ? new ProviderReference(typeProvider, dependencies) : null;
        ObjectFieldSelector selector = fieldName.isEmpty() ? new ObjectFieldSelector(false, List.of()) : new ObjectFieldSelector(false, new String[]{fieldName});
        map.put(selector, new ExecutableComponentModel.ProviderReferences(vpRef, tpRef));
    }

    @Nested
    @DisplayName(value="Type Provider Bindings")
    class TypeProviderBindings {
        TypeProviderBindings() {
        }

        @Test
        @DisplayName(value="Input Record Metadata Provider with Dependencies")
        public void testInputRecordMetadataProviderWithDependencies() {
            OperationModel operationModel = BindingSupportTest.this.createOperationModelWithInputResolvedProviders("{\n  \"body\": {\n    \"typeProvider\": \"inputRecordMetadataProvider\",\n    \"dependencies\": {\n      \"recordType\": \"recordType\"\n    }\n  }\n}\n");
            Optional recordType = BindingSupportTest.this.bindingSupport.getInParameterBinding((ExecutableComponentModel)operationModel, null, "body");
            Assertions.assertTrue((boolean)recordType.isPresent());
            String expected = "        {\n          \"provider\":{\n            \"operation\": \"inputRecordMetadataProvider\",\n            \"operationKind\": \"TypeProvider\",\n            \"dependsOn\":[\n              {\n                \"parameterPath\":[\"recordType\"],\n                \"inputPath\":[\"recordType\"]\n              }\n            ]\n          },\n          \"annotations\":{}\n        }\n";
            JsonElement actualJson = JsonParser.parseString((String)((String)recordType.get()));
            JsonElement expectedJson = JsonParser.parseString((String)expected);
            Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
        }
    }

    @Nested
    @DisplayName(value="Value Provider Bindings")
    class ValueProviderBindings {
        ValueProviderBindings() {
        }

        @Test
        @DisplayName(value="Record Type Value Provider Binding")
        public void testRecordTypeValueProviderBinding() {
            OperationModel operationModel = BindingSupportTest.this.createOperationModelWithInputResolvedProviders("{\n  \"recordType\": {\n    \"valueProvider\": \"recordTypeValueProvider\"\n  }\n}\n");
            Optional recordType = BindingSupportTest.this.bindingSupport.getInParameterBinding((ExecutableComponentModel)operationModel, null, "recordType");
            Assertions.assertTrue((boolean)recordType.isPresent());
            String expected = "  {\n    \"provider\":{\n      \"operation\": \"recordTypeValueProvider\",\n      \"operationKind\": \"ValueProvider\",\n      \"dependsOn\":[]\n    },\n    \"annotations\":{}\n}";
            JsonElement actualJson = JsonParser.parseString((String)((String)recordType.get()));
            JsonElement expectedJson = JsonParser.parseString((String)expected);
            Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
        }
    }

    @Nested
    @DisplayName(value="QueryBuilder Bindings")
    class QueryBuilderBindings {
        QueryBuilderBindings() {
        }

        @Test
        @DisplayName(value="Field Order Annotation")
        void testFieldOrderAnnotation() {
            String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\ntype FieldOrderType = {\n    orderBy: @FieldOrder() Array<String>\n}\n---\nFieldOrderType\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            ObjectType objectType = (ObjectType)compiledType;
            KeyValuePairType fieldType = Arrays.stream(objectType.getProperties()).filter(prop -> "orderBy".equals(prop.getKeyName())).findFirst().orElseThrow();
            OperationModel operationModel = BindingSupportTest.this.createMockOperationModelWithQueryBuilder();
            Optional result = BindingSupportTest.this.bindingSupport.getInParameterBinding((ExecutableComponentModel)operationModel, fieldType, "orderBy");
            Assertions.assertTrue((boolean)result.isPresent());
            String expected = "{\n  \"provider\": {\n    \"queryBuilderParameterBinding\": {\n      \"isFilter\": false,\n      \"isFieldSelector\": false,\n      \"isOrderBy\": true,\n      \"discriminators\": []\n    }\n  },\n  \"annotations\":{\"flow.fieldOrder\":{}}\n}\n";
            JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
            JsonElement expectedJson = JsonParser.parseString((String)expected);
            Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
        }

        @Nested
        @DisplayName(value="Property Bindings")
        class PropertyBindings {
            PropertyBindings() {
            }

            @Test
            @DisplayName(value="Value Provider without Dependencies")
            void testValueProviderWithoutDependencies() {
                String script = "%dw 2.8\n\ntype SimpleQueryBuilderProperty = {\n    operator: String\n}\n---\nSimpleQueryBuilderProperty\n";
                DWType compiledType = QueryBuilderTestUtils.compileScript(script);
                ObjectType objectType = (ObjectType)compiledType;
                KeyValuePairType fieldType = Arrays.stream(objectType.getProperties()).filter(prop -> "operator".equals(prop.getKeyName())).findFirst().orElseThrow();
                OperationModel operationModel = BindingSupportTest.this.createOperationModelWithQueryBuilderInputResolvedProviders("{\n  \"operator\": {\n    \"valueProvider\": \"operatorsValueProvider\"\n  }\n}\n");
                Optional result = BindingSupportTest.this.bindingSupport.getPropertyBinding((ExecutableComponentModel)operationModel, fieldType, List.of("operator"));
                Assertions.assertTrue((boolean)result.isPresent());
                String expected = "{\n  \"provider\": {\n    \"operation\": \"operatorsValueProvider\",\n    \"operationKind\": \"ValueProvider\",\n    \"dependsOn\": [],\n    \"queryBuilderParameterBinding\": {\n      \"isFilter\": false,\n      \"isFieldSelector\": false,\n      \"isOrderBy\": false,\n      \"discriminators\": []\n    }\n  },\n  \"annotations\": {}\n}\n";
                JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
                JsonElement expectedJson = JsonParser.parseString((String)expected);
                Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
            }

            @Test
            @DisplayName(value="Fields Value Provider with Dependencies and Field Selector")
            void testFieldsValueProviderWithDependenciesAndFieldSelector() {
                String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\ntype QueryBuilderFieldsType = {\n    projectedFields: @FieldSelector() Array<String>\n}\n---\nQueryBuilderFieldsType\n";
                DWType compiledType = QueryBuilderTestUtils.compileScript(script);
                ObjectType objectType = (ObjectType)compiledType;
                KeyValuePairType fieldType = Arrays.stream(objectType.getProperties()).filter(prop -> "projectedFields".equals(prop.getKeyName())).findFirst().orElseThrow();
                OperationModel operationModel = BindingSupportTest.this.createOperationModelWithQueryBuilderInputResolvedProviders("{\n  \"projectedFields\": {\n    \"valueProvider\": \"queryBuilderFieldsValueProvider\",\n    \"dependencies\": {\n      \"objectType\": \"objectType\"\n    }\n  }\n}\n");
                Optional result = BindingSupportTest.this.bindingSupport.getPropertyBinding((ExecutableComponentModel)operationModel, fieldType, List.of("projectedFields"));
                Assertions.assertTrue((boolean)result.isPresent());
                String expected = "{\n  \"provider\": {\n    \"operation\": \"queryBuilderFieldsValueProvider\",\n    \"operationKind\": \"ValueProvider\",\n    \"dependsOn\": [\n      {\n        \"parameterPath\": [\n          \"objectType\"\n        ],\n        \"inputPath\": [\n          \"objectType\"\n        ]\n      }\n    ],\n    \"queryBuilderParameterBinding\": {\n      \"isFilter\": false,\n      \"isFieldSelector\": true,\n      \"isOrderBy\": false,\n      \"discriminators\": []\n    }\n  },\n  \"annotations\": {\"flow.fieldSelector\":{}}\n}\n";
                JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
                JsonElement expectedJson = JsonParser.parseString((String)expected);
                Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
            }

            @Test
            @DisplayName(value="Filter Discriminators Value Provider with Discriminator Values")
            void testFilterDiscriminatorsValueProviderWithDiscriminatorValues() {
                String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminators\")\nannotation Discriminators(value: Array<String> = [])\n\ntype FilterDiscriminatorType = {\n    filterType: @Discriminators(value = [\"NONE\", \"AND\", \"OR\"]) String\n}\n---\nFilterDiscriminatorType\n";
                DWType compiledType = QueryBuilderTestUtils.compileScript(script);
                ObjectType objectType = (ObjectType)compiledType;
                KeyValuePairType fieldType = Arrays.stream(objectType.getProperties()).filter(prop -> "filterType".equals(prop.getKeyName())).findFirst().orElseThrow();
                OperationModel operationModel = BindingSupportTest.this.createOperationModelWithQueryBuilderInputResolvedProviders("{\n  \"filterType\": {\n    \"valueProvider\": \"filterDiscriminatorsValueProvider\"\n  }\n}\n");
                Optional result = BindingSupportTest.this.bindingSupport.getPropertyBinding((ExecutableComponentModel)operationModel, fieldType, List.of("filterType"));
                Assertions.assertTrue((boolean)result.isPresent());
                String expected = "{\n  \"provider\": {\n    \"operation\": \"filterDiscriminatorsValueProvider\",\n    \"operationKind\": \"ValueProvider\",\n    \"dependsOn\": [],\n    \"queryBuilderParameterBinding\": {\n      \"isFilter\": false,\n      \"isFieldSelector\": false,\n      \"isOrderBy\": false,\n      \"discriminators\": [\n        \"NONE\",\n        \"AND\",\n        \"OR\"\n      ]\n    }\n  },\n  \"annotations\":{\"discriminators\":{\"discriminators\":[\"NONE\",\"AND\",\"OR\"]}}\n}\n";
                JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
                JsonElement expectedJson = JsonParser.parseString((String)expected);
                Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
            }

            @Test
            @DisplayName(value="Fields Value Provider without Field Selector")
            void testFieldsValueProviderWithoutFieldSelector() {
                String script = "%dw 2.8\n\ntype QueryBuilderFieldsType = {\n    availableFields: Array<String>\n}\n---\nQueryBuilderFieldsType\n";
                DWType compiledType = QueryBuilderTestUtils.compileScript(script);
                ObjectType objectType = (ObjectType)compiledType;
                KeyValuePairType fieldType = Arrays.stream(objectType.getProperties()).filter(prop -> "availableFields".equals(prop.getKeyName())).findFirst().orElseThrow();
                OperationModel operationModel = BindingSupportTest.this.createOperationModelWithQueryBuilderInputResolvedProviders("{\n  \"availableFields\": {\n    \"valueProvider\": \"queryBuilderFieldsValueProvider\",\n    \"dependencies\": {\n      \"objectType\": \"objectType\"\n    }\n  }\n}\n");
                Optional result = BindingSupportTest.this.bindingSupport.getPropertyBinding((ExecutableComponentModel)operationModel, fieldType, List.of("availableFields"));
                Assertions.assertTrue((boolean)result.isPresent());
                String expected = "{\n  \"provider\": {\n    \"operation\": \"queryBuilderFieldsValueProvider\",\n    \"operationKind\": \"ValueProvider\",\n    \"dependsOn\": [\n      {\n        \"parameterPath\": [\n          \"objectType\"\n        ],\n        \"inputPath\": [\n          \"objectType\"\n        ]\n      }\n    ],\n    \"queryBuilderParameterBinding\": {\n      \"isFilter\": false,\n      \"isFieldSelector\": false,\n      \"isOrderBy\": false,\n      \"discriminators\": []\n    }\n  },\n  \"annotations\": {}\n}\n";
                JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
                JsonElement expectedJson = JsonParser.parseString((String)expected);
                Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
            }
        }

        @Nested
        @DisplayName(value="Input Parameter Bindings")
        class InputParameterBindings {
            InputParameterBindings() {
            }

            @Test
            @DisplayName(value="Field Selector Annotation")
            void testFieldSelectorAnnotation() {
                String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\ntype FieldSelectorType = {\n    projectedFields: @FieldSelector() Array<String>\n}\n---\nFieldSelectorType\n";
                DWType compiledType = QueryBuilderTestUtils.compileScript(script);
                ObjectType objectType = (ObjectType)compiledType;
                KeyValuePairType fieldType = Arrays.stream(objectType.getProperties()).filter(prop -> "projectedFields".equals(prop.getKeyName())).findFirst().orElseThrow();
                OperationModel operationModel = BindingSupportTest.this.createMockOperationModelWithQueryBuilder();
                Optional result = BindingSupportTest.this.bindingSupport.getInParameterBinding((ExecutableComponentModel)operationModel, fieldType, "projectedFields");
                Assertions.assertTrue((boolean)result.isPresent());
                String expected = "{\n  \"provider\": {\n    \"queryBuilderParameterBinding\": {\n      \"isFilter\": false,\n      \"isFieldSelector\": true,\n      \"isOrderBy\": false,\n      \"discriminators\": []\n    }\n  },\n  \"annotations\":{\"flow.fieldSelector\":{}}\n}\n";
                JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
                JsonElement expectedJson = JsonParser.parseString((String)expected);
                Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
            }

            @Test
            @DisplayName(value="Result Set Filter Annotation")
            void testResultSetFilterAnnotation() {
                String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\ntype ResultSetFilterType = {\n    filter: @ResultSetFilter() String\n}\n---\nResultSetFilterType\n";
                DWType compiledType = QueryBuilderTestUtils.compileScript(script);
                ObjectType objectType = (ObjectType)compiledType;
                KeyValuePairType fieldType = Arrays.stream(objectType.getProperties()).filter(prop -> "filter".equals(prop.getKeyName())).findFirst().orElseThrow();
                OperationModel operationModel = BindingSupportTest.this.createMockOperationModelWithQueryBuilder();
                Optional result = BindingSupportTest.this.bindingSupport.getInParameterBinding((ExecutableComponentModel)operationModel, fieldType, "filter");
                Assertions.assertTrue((boolean)result.isPresent());
                String expected = "{\n  \"provider\": {\n    \"queryBuilderParameterBinding\": {\n      \"isFilter\": true,\n      \"isFieldSelector\": false,\n      \"isOrderBy\": false,\n      \"discriminators\": []\n    }\n  },\n  \"annotations\":{\"flow.resultSetFilter\":{}}\n}\n";
                JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
                JsonElement expectedJson = JsonParser.parseString((String)expected);
                Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
            }
        }
    }

    @Nested
    @DisplayName(value="Property Bindings")
    class PropertyBindings {
        PropertyBindings() {
        }

        @Test
        @DisplayName(value="Value Provider without Dependencies")
        void testValueProviderWithoutDependencies() {
            OperationModel operationModel = BindingSupportTest.this.createOperationModelWithInputResolvedProviders("{\n  \"staticValues\": {\n    \"valueProvider\": \"staticValuesProvider\"\n  }\n}\n");
            Optional result = BindingSupportTest.this.bindingSupport.getPropertyBinding((ExecutableComponentModel)operationModel, null, List.of("staticValues"));
            Assertions.assertTrue((boolean)result.isPresent());
            String expected = "{\n  \"provider\": {\n    \"operation\": \"staticValuesProvider\",\n    \"operationKind\": \"ValueProvider\",\n    \"dependsOn\": []\n  },\n  \"annotations\": {}\n}\n";
            JsonElement actualJson = BindingSupportTest.this.JSON_PARSER.parse((String)result.get());
            JsonElement expectedJson = BindingSupportTest.this.JSON_PARSER.parse(expected);
            Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
        }
    }

    @Nested
    @DisplayName(value="Output Parameter Bindings")
    class OutputParameterBindings {
        OutputParameterBindings() {
        }

        @Test
        @DisplayName(value="Output Type Provider with Parameter Dependency")
        void testOutputTypeProviderWithParameterDependency() {
            OperationModel operationModel = BindingSupportTest.this.createOperationModelWithOutputResolvedProviders("{\n  \"\": {\n    \"typeProvider\": \"outputMetadataProvider\",\n    \"dependencies\": {\n      \"recordType\": \"recordType\"\n    }\n  }\n}\n");
            Optional result = BindingSupportTest.this.bindingSupport.getOutParameterBinding((ExecutableComponentModel)operationModel);
            Assertions.assertTrue((boolean)result.isPresent());
            String expected = "{\n  \"provider\": {\n    \"operation\": \"outputMetadataProvider\",\n    \"operationKind\": \"TypeProvider\",\n    \"dependsOn\": [\n      {\n        \"parameterPath\": [\n          \"recordType\"\n        ],\n        \"inputPath\": [\n          \"recordType\"\n        ]\n      }\n    ]\n  },\n  \"annotations\":{}\n}\n";
            JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
            JsonElement expectedJson = JsonParser.parseString((String)expected);
            Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
        }
    }

    @Nested
    @DisplayName(value="Input Parameter Bindings")
    class InputParameterBindings {
        InputParameterBindings() {
        }

        @Test
        @DisplayName(value="Type Provider with Single Parameter Dependency")
        void testTypeProviderWithSingleParameterDependency() {
            OperationModel operationModel = BindingSupportTest.this.createOperationModelWithInputResolvedProviders("{\n  \"inputData\": {\n    \"typeProvider\": \"dynamicTypeProvider\",\n    \"dependencies\": {\n      \"sObjectType\": \"sObjectType\"\n    }\n  }\n}\n");
            Optional result = BindingSupportTest.this.bindingSupport.getInParameterBinding((ExecutableComponentModel)operationModel, null, "inputData");
            Assertions.assertTrue((boolean)result.isPresent());
            String expected = "{\n  \"provider\": {\n    \"operation\": \"dynamicTypeProvider\",\n    \"operationKind\": \"TypeProvider\",\n    \"dependsOn\": [\n      {\n        \"parameterPath\": [\n          \"sObjectType\"\n        ],\n        \"inputPath\": [\n          \"sObjectType\"\n        ]\n      }\n    ]\n  },\n  \"annotations\":{}\n}\n";
            JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
            JsonElement expectedJson = JsonParser.parseString((String)expected);
            Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
        }

        @Test
        @DisplayName(value="Type Provider with Multiple Parameter Dependencies")
        void testTypeProviderWithMultipleParameterDependencies() {
            OperationModel operationModel = BindingSupportTest.this.createOperationModelWithInputResolvedProviders("{\n  \"entityData\": {\n    \"typeProvider\": \"complexTypeProvider\",\n    \"dependencies\": {\n      \"entityType\": \"entityType\",\n      \"contextId\": \"contextPath\"\n    }\n  }\n}\n");
            Optional result = BindingSupportTest.this.bindingSupport.getInParameterBinding((ExecutableComponentModel)operationModel, null, "entityData");
            Assertions.assertTrue((boolean)result.isPresent());
            String expected = "{\n  \"provider\": {\n    \"operation\": \"complexTypeProvider\",\n    \"operationKind\": \"TypeProvider\",\n    \"dependsOn\": [\n      {\n        \"parameterPath\": [\n          \"entityType\"\n        ],\n        \"inputPath\": [\n          \"entityType\"\n        ]\n      },\n      {\n        \"parameterPath\": [\n          \"contextId\"\n        ],\n        \"inputPath\": [\n          \"contextPath\"\n        ]\n      }\n    ]\n  },\n\"annotations\":{}\n}\n";
            JsonElement actualJson = JsonParser.parseString((String)((String)result.get()));
            JsonElement expectedJson = JsonParser.parseString((String)expected);
            Assertions.assertEquals((Object)expectedJson.toString(), (Object)actualJson.toString());
        }

        @Test
        @DisplayName(value="Input Type Provider Reference with Kind Resolution")
        void testInputTypeProviderReferenceWithKind() {
            OperationModel operationModel = BindingSupportTest.this.createOperationModelWithInputResolvedProviders("{\n  \"inputData\": {\n    \"typeProvider\": \"dynamicTypeProvider\",\n    \"dependencies\": {\n      \"sObjectType\": \"sObjectType\"\n    }\n  }\n}\n");
            Optional result = BindingSupportTest.this.bindingSupport.getInputTypeProviderReferenceWithKind((ExecutableComponentModel)operationModel, List.of("inputData"));
            Assertions.assertTrue((boolean)result.isPresent());
            BindingSupport.ProviderReferenceWithKind providerRefWithKind = (BindingSupport.ProviderReferenceWithKind)result.get();
            Assertions.assertEquals((Object)OperationKind.TYPE_PROVIDER, (Object)providerRefWithKind.operationKind());
            ProviderReference providerRef = providerRefWithKind.providerReference();
            Assertions.assertEquals((Object)"dynamicTypeProvider", (Object)providerRef.getName());
            Assertions.assertEquals((int)1, (int)providerRef.getArguments().size());
            ProviderArgument argument = (ProviderArgument)providerRef.getArguments().get(0);
            Assertions.assertEquals(List.of("sObjectType"), List.of(argument.getParameterSelector().getPath()));
            Assertions.assertEquals(List.of("sObjectType"), List.of(((ObjectFieldSelector)argument.getInputSelector()).getPath()));
        }
    }
}

