/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader;

import com.mulesoft.connectivity.flow.fixtures.QueryBuilderTestUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.ExecutableComponentLoader;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.R256TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.InParameterComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OperationComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OutParameterComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceModel;
import com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder.QueryBuilderAdapter;
import com.mulesoft.connectivity.flow.internal.servicemodel.serializer.r256.serializer.R256Serializer;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@DisplayName(value="ExecutableComponentLoader")
class ExecutableComponentLoaderTest {
    private ComponentRegistry componentRegistry;
    private R256TypeFactory typeFactory;
    private ExecutableComponentLoader loader;
    private ServiceComponent serviceComponent;

    ExecutableComponentLoaderTest() {
    }

    @BeforeEach
    void setUp() {
        Patch patch = Patch.fromResource((String)"patch.json");
        this.componentRegistry = new ComponentRegistry();
        this.typeFactory = new R256TypeFactory(this.componentRegistry, patch);
        this.loader = new ExecutableComponentLoader(this.componentRegistry, (TypeFactory)this.typeFactory, patch);
        this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("TestService")).description("Test Service for ExecutableComponentLoader")).build();
        this.componentRegistry.registerComponent((Component)this.serviceComponent);
    }

    @Nested
    @DisplayName(value="Trigger Loading Tests")
    class TriggerLoadingTests {
        TriggerLoadingTests() {
        }

        @Test
        @DisplayName(value="Should load Trigger and create correct components")
        void shouldLoadTriggerAndCreateCorrectComponents() {
            TriggerModel originalTrigger = QueryBuilderTestUtils.createTriggerModel("%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: { key: String, defaultSelection?: String })\n\ntype QueryFieldNoOrder = {|\n    kind: \"NOT_SORTED\"\n|}\n\ntype QueryOrder = \"ASC\" | \"DESC\"\n\ntype QueryFieldOrder = {|\n    kind: \"SORTED\"\n|}\n\ntype QueryFieldOrderPair<F <: String> = {|\n   field: F,\n   order: QueryOrder\n|}\n\ntype QueryManyFieldsManySortingOrder<F <: String> = QueryFieldOrder & {|\n    fields: Array<QueryFieldOrderPair<F>>\n|}\n\ntype TriggerWithQBProperties = {\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String,\n    orderBy: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() QueryFieldNoOrder | QueryManyFieldsManySortingOrder<String>,\n    entityType: String\n}\n---\nTriggerWithQBProperties\n", "testTrigger");
            TriggerModel adaptedTrigger = QueryBuilderAdapter.adapt((TriggerModel)originalTrigger);
            ExecutableComponentLoaderTest.this.loader.load(adaptedTrigger, "1", (Component)ExecutableComponentLoaderTest.this.serviceComponent);
            Optional<OperationComponent> triggerComponent = ExecutableComponentLoaderTest.this.componentRegistry.getComponents().values().stream().filter(c -> c instanceof OperationComponent).map(c -> (OperationComponent)c).filter(op -> "testTrigger".equals(op.getName())).findFirst();
            Assertions.assertTrue((boolean)triggerComponent.isPresent(), (String)"Trigger component should be created");
            OperationComponent createdTrigger = triggerComponent.get();
            Assertions.assertEquals((Object)"testTrigger", (Object)createdTrigger.getName(), (String)"Trigger name should match");
            Assertions.assertEquals((Object)"EventSource", (Object)createdTrigger.getKind(), (String)"Trigger should have EventSource kind");
            Assertions.assertEquals((Object)"1", (Object)createdTrigger.getOuter(), (String)"Trigger should reference service component");
            Assertions.assertEquals((Object)"1", (Object)createdTrigger.getVersion(), (String)"Trigger should have version number");
        }

        @Test
        @DisplayName(value="Should create correct InParameterComponents for trigger input fields")
        void shouldCreateCorrectInParameterComponentsForTriggerInputFields() {
            TriggerModel originalTrigger = QueryBuilderTestUtils.createTriggerModel("%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: { key: String, defaultSelection?: String })\n\ntype QueryFieldNoOrder = {|\n    kind: \"NOT_SORTED\"\n|}\n\ntype QueryOrder = \"ASC\" | \"DESC\"\n\ntype QueryFieldOrder = {|\n    kind: \"SORTED\"\n|}\n\ntype QueryFieldOrderPair<F <: String> = {|\n   field: F,\n   order: QueryOrder\n|}\n\ntype QueryManyFieldsManySortingOrder<F <: String> = QueryFieldOrder & {|\n    fields: Array<QueryFieldOrderPair<F>>\n|}\n\ntype TriggerWithQBProperties = {\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String,\n    orderBy: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() QueryFieldNoOrder | QueryManyFieldsManySortingOrder<String>,\n    entityType: String\n}\n---\nTriggerWithQBProperties\n", "fieldTestTrigger");
            TriggerModel adaptedTrigger = QueryBuilderAdapter.adapt((TriggerModel)originalTrigger);
            ExecutableComponentLoaderTest.this.loader.load(adaptedTrigger, "1", (Component)ExecutableComponentLoaderTest.this.serviceComponent);
            List<InParameterComponent> inParameters = ExecutableComponentLoaderTest.this.componentRegistry.getComponents().values().stream().filter(c -> c instanceof InParameterComponent).map(c -> (InParameterComponent)c).toList();
            Assertions.assertEquals((int)4, (int)inParameters.size(), (String)"Should create exactly 4 input parameters");
            List<String> paramNames = inParameters.stream().map(p -> p.getName()).toList();
            Assertions.assertTrue((boolean)paramNames.contains("entityType"), (String)"entityType parameter should be created");
            Assertions.assertTrue((boolean)paramNames.contains("projectedFields"), (String)"projectedFields parameter should be created");
            Assertions.assertTrue((boolean)paramNames.contains("filter"), (String)"filter parameter should be created");
            Assertions.assertTrue((boolean)paramNames.contains("orderBy"), (String)"orderBy parameter should be created");
        }
    }

    @Nested
    @DisplayName(value="Operation Loading Tests")
    class OperationLoadingTests {
        OperationLoadingTests() {
        }

        @Test
        void simpleOperation() {
            OperationModel originalOperation = QueryBuilderTestUtils.createOperationModel("testOperation", "%dw 2.8\n\ntype InputType = {\n    field1: String,\n    field2: Number\n}\n---\nInputType\n", "%dw 2.8\n\ntype OutputType = {\n    outField1: String\n}\n---\nOutputType\n");
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            ExecutableComponentLoaderTest.this.loader.load(adaptedOperation, "1.0", (Component)ExecutableComponentLoaderTest.this.serviceComponent);
            R256Serializer serializer = new R256Serializer();
            String expected = "{\n  \"components\": [\n    {\n      \"name\": \"TestService\",\n      \"componentType\": \"Service\",\n      \"id\": \"1\",\n      \"description\": \"Test Service for ExecutableComponentLoader\"\n    },\n    {\n      \"name\": \"testOperation\",\n      \"componentType\": \"Operation\",\n      \"id\": \"2\",\n      \"description\": \"testOperation Display Name\",\n      \"outer\": \"1\",\n      \"version\": \"1.0\",\n      \"kind\": \"Synchronous\",\n      \"binding\": \"{\\\"isPaginated\\\":false,\\\"isQueryBuilder\\\":false}\"\n    },\n    {\n      \"name\": \"field1\",\n      \"componentType\": \"InParameter\",\n      \"id\": \"3\",\n      \"outer\": \"2\",\n      \"required\": true,\n      \"nullable\": false,\n      \"parameterType\": \"4\"\n    },\n    {\n      \"name\": \"String\",\n      \"componentType\": \"PrimitiveDataType\",\n      \"id\": \"4\",\n      \"outer\": \"1\"\n    },\n    {\n      \"name\": \"field2\",\n      \"componentType\": \"InParameter\",\n      \"id\": \"5\",\n      \"outer\": \"2\",\n      \"required\": true,\n      \"nullable\": false,\n      \"parameterType\": \"6\"\n    },\n    {\n      \"name\": \"Double\",\n      \"componentType\": \"PrimitiveDataType\",\n      \"id\": \"6\",\n      \"outer\": \"1\"\n    },\n    {\n      \"name\": \"ObjectType\",\n      \"componentType\": \"OutParameter\",\n      \"id\": \"7\",\n      \"outer\": \"2\",\n      \"required\": false,\n      \"nullable\": false,\n      \"parameterType\": \"8\"\n    },\n    {\n      \"componentType\": \"ObjectDataType\",\n      \"id\": \"8\",\n      \"outer\": \"7\"\n    },\n    {\n      \"name\": \"outField1\",\n      \"componentType\": \"Property\",\n      \"id\": \"9\",\n      \"outer\": \"8\",\n      \"required\": true,\n      \"nullable\": false,\n      \"propertyType\": \"4\"\n    }\n  ]\n}";
            StringWriter stringWriter = new StringWriter();
            List<Component> sortedComponents = ExecutableComponentLoaderTest.this.componentRegistry.getComponents().entrySet().stream().sorted(Comparator.comparing(x -> Long.valueOf(((Component)x.getValue()).getId()))).map(Map.Entry::getValue).toList();
            serializer.serialize(ServiceModel.builder().components(sortedComponents).build(), (Writer)stringWriter);
            Assertions.assertEquals((Object)expected, (Object)stringWriter.toString());
        }

        @Test
        @DisplayName(value="Should load Operation with QueryBuilder and create correct components")
        void shouldLoadOperationWithQueryBuilderAndCreateCorrectComponents() {
            OperationModel originalOperation = QueryBuilderTestUtils.createOperationModel("%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.limit\")\nannotation FieldLimit(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"ValuesFrom\")\nannotation ValuesFrom(value: {name: String, arguments?: Object} = {name: \"\"})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: { key: String, defaultSelection?: String })\n\ntype QueryFieldNoOrder = {|\n    kind: \"NOT_SORTED\"\n|}\n\ntype QueryOrder = \"ASC\" | \"DESC\"\n\ntype QueryFieldOrder = {|\n    kind: \"SORTED\"\n|}\n\ntype QueryFieldOrderPair<F <: String> = {|\n   field: F,\n   order: QueryOrder\n|}\n\ntype QueryManyFieldsManySortingOrder<F <: String> = QueryFieldOrder & {|\n    fields: Array<QueryFieldOrderPair<F>>\n|}\n\ntype OperationWithFullQB = @QueryBuilder() {\n    objectType: @ValuesFrom(value = {name: \"queryBuilderObjectsValueProvider\"}) String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String,\n    orderBy: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() QueryFieldNoOrder | QueryManyFieldsManySortingOrder<String>,\n    limit: @FieldLimit() Number\n}\n---\nOperationWithFullQB\n", "testOperation");
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            ExecutableComponentLoaderTest.this.loader.load(adaptedOperation, "1.0", (Component)ExecutableComponentLoaderTest.this.serviceComponent);
            Map components = ExecutableComponentLoaderTest.this.componentRegistry.getComponents();
            Optional<OperationComponent> operationComponent = components.values().stream().filter(c -> c instanceof OperationComponent).map(c -> (OperationComponent)c).filter(op -> "testOperation".equals(op.getName())).findFirst();
            Assertions.assertTrue((boolean)operationComponent.isPresent(), (String)"Operation component should be created");
            OperationComponent createdOp = operationComponent.get();
            Assertions.assertEquals((Object)"testOperation", (Object)createdOp.getName(), (String)"Operation name should match");
            Assertions.assertEquals((Object)"1", (Object)createdOp.getOuter(), (String)"Operation should reference service component");
            Assertions.assertEquals((Object)"1.0", (Object)createdOp.getVersion(), (String)"Version should be set");
            Assertions.assertEquals((Object)"Synchronous", (Object)createdOp.getKind(), (String)"Operation should have Synchronous kind");
            String binding = createdOp.getBinding();
            Assertions.assertNotNull((Object)binding, (String)"Binding should be set");
            Assertions.assertTrue((boolean)binding.contains("\"isQueryBuilder\":true"), (String)"Binding should indicate QB is enabled");
            Assertions.assertTrue((boolean)binding.contains("\"isPaginated\":false"), (String)"Binding should include pagination info");
        }

        @Test
        @DisplayName(value="Should load Operation without QueryBuilder and create correct components")
        void shouldLoadOperationWithoutQueryBuilderAndCreateCorrectComponents() {
            OperationModel originalOperation = QueryBuilderTestUtils.createOperationModel("%dw 2.8\n\ntype OperationInput = {\n    entityType: String,\n    data: Object\n}\n---\nOperationInput\n", "nonQBOperation");
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            ExecutableComponentLoaderTest.this.loader.load(adaptedOperation, "1.0", (Component)ExecutableComponentLoaderTest.this.serviceComponent);
            Optional<OperationComponent> operationComponent = ExecutableComponentLoaderTest.this.componentRegistry.getComponents().values().stream().filter(c -> c instanceof OperationComponent).map(c -> (OperationComponent)c).filter(op -> "nonQBOperation".equals(op.getName())).findFirst();
            Assertions.assertTrue((boolean)operationComponent.isPresent(), (String)"Operation component should be created");
            OperationComponent createdOp = operationComponent.get();
            Assertions.assertEquals((Object)"nonQBOperation", (Object)createdOp.getName(), (String)"Operation name should match");
            String binding = createdOp.getBinding();
            Assertions.assertNotNull((Object)binding, (String)"Binding should be set");
            Assertions.assertTrue((boolean)binding.contains("\"isQueryBuilder\":false"), (String)"Binding should indicate QB is disabled");
        }

        @Test
        @DisplayName(value="Should create correct InParameterComponents for input fields")
        void shouldCreateCorrectInParameterComponentsForInputFields() {
            OperationModel originalOperation = QueryBuilderTestUtils.createOperationModel("%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.limit\")\nannotation FieldLimit(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"ValuesFrom\")\nannotation ValuesFrom(value: {name: String, arguments?: Object} = {name: \"\"})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: { key: String, defaultSelection?: String })\n\ntype QueryFieldNoOrder = {|\n    kind: \"NOT_SORTED\"\n|}\n\ntype QueryOrder = \"ASC\" | \"DESC\"\n\ntype QueryFieldOrder = {|\n    kind: \"SORTED\"\n|}\n\ntype QueryFieldOrderPair<F <: String> = {|\n   field: F,\n   order: QueryOrder\n|}\n\ntype QueryManyFieldsManySortingOrder<F <: String> = QueryFieldOrder & {|\n    fields: Array<QueryFieldOrderPair<F>>\n|}\n\ntype OperationWithFullQB = @QueryBuilder() {\n    objectType: @ValuesFrom(value = {name: \"queryBuilderObjectsValueProvider\"}) String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String,\n    orderBy: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() QueryFieldNoOrder | QueryManyFieldsManySortingOrder<String>,\n    limit: @FieldLimit() Number\n}\n---\nOperationWithFullQB\n", "fieldTestOperation");
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            ExecutableComponentLoaderTest.this.loader.load(adaptedOperation, "1.0", (Component)ExecutableComponentLoaderTest.this.serviceComponent);
            List<InParameterComponent> inParameters = ExecutableComponentLoaderTest.this.componentRegistry.getComponents().values().stream().filter(c -> c instanceof InParameterComponent).map(c -> (InParameterComponent)c).toList();
            Assertions.assertEquals((int)5, (int)inParameters.size(), (String)"Should create exactly 5 input parameters");
            List<String> paramNames = inParameters.stream().map(p -> p.getName()).toList();
            Assertions.assertTrue((boolean)paramNames.contains("objectType"), (String)"objectType parameter should be created");
            Assertions.assertTrue((boolean)paramNames.contains("projectedFields"), (String)"projectedFields parameter should be created");
            Assertions.assertTrue((boolean)paramNames.contains("filter"), (String)"filter parameter should be created");
            Assertions.assertTrue((boolean)paramNames.contains("orderBy"), (String)"orderBy parameter should be created");
            Assertions.assertTrue((boolean)paramNames.contains("limit"), (String)"limit parameter should be created");
            String operationId = ExecutableComponentLoaderTest.this.componentRegistry.getComponents().values().stream().filter(c -> c instanceof OperationComponent).map(c -> (OperationComponent)c).filter(op -> "fieldTestOperation".equals(op.getName())).findFirst().map(Component::getId).orElse(null);
            Assertions.assertNotNull((Object)operationId, (String)"Operation should exist");
            inParameters.forEach(param -> Assertions.assertEquals((Object)operationId, (Object)param.getOuter(), (String)("Parameter " + param.getName() + " should reference the operation")));
        }

        @Test
        @DisplayName(value="Should create OutParameterComponent for output")
        void shouldCreateOutParameterComponentForOutput() {
            OperationModel originalOperation = QueryBuilderTestUtils.createOperationModel("%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.limit\")\nannotation FieldLimit(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"ValuesFrom\")\nannotation ValuesFrom(value: {name: String, arguments?: Object} = {name: \"\"})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: { key: String, defaultSelection?: String })\n\ntype QueryFieldNoOrder = {|\n    kind: \"NOT_SORTED\"\n|}\n\ntype QueryOrder = \"ASC\" | \"DESC\"\n\ntype QueryFieldOrder = {|\n    kind: \"SORTED\"\n|}\n\ntype QueryFieldOrderPair<F <: String> = {|\n   field: F,\n   order: QueryOrder\n|}\n\ntype QueryManyFieldsManySortingOrder<F <: String> = QueryFieldOrder & {|\n    fields: Array<QueryFieldOrderPair<F>>\n|}\n\ntype OperationWithFullQB = @QueryBuilder() {\n    objectType: @ValuesFrom(value = {name: \"queryBuilderObjectsValueProvider\"}) String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String,\n    orderBy: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() QueryFieldNoOrder | QueryManyFieldsManySortingOrder<String>,\n    limit: @FieldLimit() Number\n}\n---\nOperationWithFullQB\n", "outputTestOperation");
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            ExecutableComponentLoaderTest.this.loader.load(adaptedOperation, "1.0", (Component)ExecutableComponentLoaderTest.this.serviceComponent);
            List<Component> outParameters = ExecutableComponentLoaderTest.this.componentRegistry.getComponents().values().stream().filter(c -> c instanceof OutParameterComponent).toList();
            Assertions.assertEquals((int)1, (int)outParameters.size(), (String)"Should create exactly one output parameter");
            OutParameterComponent outParam = (OutParameterComponent)outParameters.get(0);
            Assertions.assertNotNull((Object)outParam.getName(), (String)"Output parameter should have a name");
            Assertions.assertNotNull((Object)outParam.getParameterType(), (String)"Output parameter should have a parameter type");
        }
    }
}

