/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ArrayTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.IntersectionTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ObjectTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ReferenceTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.UnionTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PropertyComponent;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.TypeType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.WeaveType;

public class TypeHandlerTestUtils {
    public static final DataWeaveScriptingEngine ENGINE = new DataWeaveScriptingEngine();

    public static PropertyComponent findProperty(String propertyName, ComponentRegistry componentRegistry) {
        return componentRegistry.getComponents().values().stream().filter(c -> c.getName().equals(propertyName) && c instanceof PropertyComponent).map(PropertyComponent.class::cast).findFirst().orElseThrow(() -> new AssertionError((Object)("Property '" + propertyName + "' not found")));
    }

    public static Component findComponent(String componentName, ComponentRegistry componentRegistry) {
        return componentRegistry.getComponents().values().stream().filter(c -> c.getName().equals(componentName)).findFirst().orElseThrow(() -> new AssertionError((Object)("Component '" + componentName + "' not found")));
    }

    public static String createDataWeaveScript(String fieldName, String fieldType) {
        return String.format("%%dw 2.8\ntype Root = {\n  %s: %s\n}\n---\nRoot\n", fieldName, fieldType);
    }

    public static Component findById(String id, Map<Object, Component> components) {
        return components.values().stream().filter(component -> component.getId().equals(id)).findFirst().orElse(null);
    }

    public static Component processDataWeaveScript(String script, Object handler, Component serviceComponent, TypeFactory typeFactory) {
        WeaveType weaveType = (WeaveType)ENGINE.inferTypeOf(script).get();
        DWType dwType = ((TypeType)weaveType).getType();
        if (handler instanceof ObjectTypeHandler) {
            return ((ObjectTypeHandler)handler).make(dwType, "Root", serviceComponent, typeFactory);
        }
        if (handler instanceof UnionTypeHandler) {
            return ((UnionTypeHandler)handler).make(dwType, "Root", serviceComponent, typeFactory);
        }
        if (handler instanceof IntersectionTypeHandler) {
            return ((IntersectionTypeHandler)handler).make(dwType, "Root", serviceComponent, typeFactory);
        }
        if (handler instanceof ReferenceTypeHandler) {
            return ((ReferenceTypeHandler)handler).make(dwType, "Root", serviceComponent, typeFactory);
        }
        if (handler instanceof ArrayTypeHandler) {
            return ((ArrayTypeHandler)handler).make(dwType, "Root", serviceComponent, typeFactory);
        }
        throw new IllegalArgumentException("Unsupported handler type: " + handler.getClass().getSimpleName());
    }

    public static void assertBasicProperty(PropertyComponent property, String expectedName, String expectedTypeName, ComponentRegistry componentRegistry) {
        Assertions.assertEquals((Object)expectedName, (Object)property.getName(), (String)"Property name should match expected value");
        Assertions.assertTrue((boolean)property.isRequired(), (String)(expectedName + " field should be required by default"));
        Component propertyType = TypeHandlerTestUtils.findById(property.getPropertyType(), componentRegistry.getComponents());
        Assertions.assertNotNull((Object)propertyType, (String)("Property type should not be null for property: " + expectedName));
        Assertions.assertTrue((boolean)(propertyType instanceof PrimitiveTypeComponent), (String)("Property type should be primitive for property '" + expectedName + "', but got: " + propertyType.getClass().getSimpleName()));
        Assertions.assertEquals((Object)expectedTypeName, (Object)propertyType.getName(), (String)("Property type name should be '" + expectedTypeName + "' for property '" + expectedName + "'"));
    }

    public static void assertPropertyType(PropertyComponent property, String expectedTypeName, ComponentRegistry componentRegistry) {
        Component propertyType = TypeHandlerTestUtils.findById(property.getPropertyType(), componentRegistry.getComponents());
        Assertions.assertNotNull((Object)propertyType, (String)("Property type should not be null for property: " + property.getName()));
        Assertions.assertTrue((boolean)(propertyType instanceof PrimitiveTypeComponent), (String)("Property type should be primitive for property '" + property.getName() + "', but got: " + propertyType.getClass().getSimpleName()));
        Assertions.assertEquals((Object)expectedTypeName, (Object)propertyType.getName(), (String)("Property type name should be '" + expectedTypeName + "' for property '" + property.getName() + "', but was: " + propertyType.getName()));
    }
}

