/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.ComponentPath;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ComponentType;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ObjectTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OperationComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OutParameterComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class ComponentPathTest {
    @Test
    public void testFromTopDownWithSingleComponent() {
        ComponentPath path = ComponentPath.fromTopDown((String)"Intercom#SERVICE");
        Assertions.assertNotNull((Object)path);
        Assertions.assertEquals((Object)"Intercom", (Object)path.getName());
        Assertions.assertEquals((Object)ComponentType.SERVICE, (Object)path.getComponentType());
        Assertions.assertNull((Object)path.getNext());
    }

    @Test
    public void incorrectComponentType() {
        try {
            ComponentPath componentPath = ComponentPath.fromTopDown((String)"Intercom#Service");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"No enum constant com.mulesoft.connectivity.flow.internal.servicemodel.model.ComponentType.Service", (Object)e.getMessage());
        }
    }

    @Test
    public void testFromTopDownWithMultipleComponents() {
        ComponentPath path = ComponentPath.fromTopDown((String)"Intercom#SERVICE/CreateContact#OPERATION/OUT_PARAMETER/OBJECT/tags#PROPERTY_TYPE");
        Assertions.assertNotNull((Object)path);
        Assertions.assertEquals((Object)"Intercom", (Object)path.getName());
        Assertions.assertEquals((Object)ComponentType.SERVICE, (Object)path.getComponentType());
        Assertions.assertNotNull((Object)path.getNext());
        ComponentPath second = path.getNext();
        Assertions.assertEquals((Object)"CreateContact", (Object)second.getName());
        Assertions.assertEquals((Object)ComponentType.OPERATION, (Object)second.getComponentType());
        Assertions.assertNotNull((Object)second.getNext());
        ComponentPath third = second.getNext();
        Assertions.assertEquals((Object)ComponentType.OUT_PARAMETER, (Object)third.getComponentType());
        Assertions.assertNotNull((Object)third.getNext());
        ComponentPath fourth = third.getNext();
        Assertions.assertEquals((Object)ComponentType.OBJECT, (Object)fourth.getComponentType());
        Assertions.assertNotNull((Object)fourth.getNext());
        ComponentPath fifth = fourth.getNext();
        Assertions.assertEquals((Object)"tags", (Object)fifth.getName());
        Assertions.assertEquals((Object)ComponentType.PROPERTY_TYPE, (Object)fifth.getComponentType());
        Assertions.assertNull((Object)fifth.getNext());
    }

    @Test
    public void testComplexPathFromConnectorServiceProvider() {
        ComponentPath path = ComponentPath.fromTopDown((String)"Intercom#SERVICE/CreateNote#OPERATION/OUT_PARAMETER/OBJECT/author#PROPERTY_TYPE/OBJECT/team_priority_level#PROPERTY_TYPE");
        Assertions.assertNotNull((Object)path);
        Assertions.assertEquals((Object)"Intercom", (Object)path.getName());
        Assertions.assertEquals((Object)ComponentType.SERVICE, (Object)path.getComponentType());
        ComponentPath current = path;
        String[] expectedNames = new String[]{"Intercom", "CreateNote", null, null, "author", null, "team_priority_level"};
        ComponentType[] expectedTypes = new ComponentType[]{ComponentType.SERVICE, ComponentType.OPERATION, ComponentType.OUT_PARAMETER, ComponentType.OBJECT, ComponentType.PROPERTY_TYPE, ComponentType.OBJECT, ComponentType.PROPERTY_TYPE};
        for (int i = 0; i < expectedNames.length; ++i) {
            Assertions.assertNotNull((Object)current);
            Assertions.assertEquals((Object)expectedNames[i], (Object)current.getName());
            Assertions.assertEquals((Object)expectedTypes[i], (Object)current.getComponentType());
            current = current.getNext();
        }
        Assertions.assertNull((Object)current);
    }

    @Test
    public void testComplexPathFromBackwardCheck() {
        ComponentPath path = ComponentPath.fromTopDown((String)"Qualtrics#SERVICE/T_SingleDirectory#OBJECT/deduplicationCriteria#PROPERTY_TYPE");
        Assertions.assertNotNull((Object)path);
        Assertions.assertEquals((Object)"Qualtrics", (Object)path.getName());
        Assertions.assertEquals((Object)ComponentType.SERVICE, (Object)path.getComponentType());
        ComponentPath current = path;
        String[] expectedNames = new String[]{"Qualtrics", "T_SingleDirectory", "deduplicationCriteria"};
        ComponentType[] expectedTypes = new ComponentType[]{ComponentType.SERVICE, ComponentType.OBJECT, ComponentType.PROPERTY_TYPE};
        for (int i = 0; i < expectedNames.length; ++i) {
            Assertions.assertNotNull((Object)current);
            Assertions.assertEquals((Object)expectedNames[i], (Object)current.getName());
            Assertions.assertEquals((Object)expectedTypes[i], (Object)current.getComponentType());
            current = current.getNext();
        }
        Assertions.assertNull((Object)current);
    }

    @Test
    public void testOutParameterEndingInArray() {
        ComponentPath componentPath = ComponentPath.fromTopDown((String)"ServiceName#SERVICE/OperationB#OPERATION/OUT_PARAMETER/ARRAY");
        Assertions.assertNotNull((Object)componentPath);
        Assertions.assertEquals((Object)"ServiceName", (Object)componentPath.getName());
        Assertions.assertEquals((Object)ComponentType.SERVICE, (Object)componentPath.getComponentType());
        Assertions.assertEquals((Object)"OperationB", (Object)componentPath.getNext().getName());
        Assertions.assertEquals((Object)ComponentType.OPERATION, (Object)componentPath.getNext().getComponentType());
        Assertions.assertEquals((Object)ComponentType.OUT_PARAMETER, (Object)componentPath.getNext().getNext().getComponentType());
        Assertions.assertEquals((Object)ComponentType.ARRAY, (Object)componentPath.getNext().getNext().getNext().getComponentType());
    }

    @Test
    @DisplayName(value="Given a list of three components, When calling fromComponents, Then the path is created correctly")
    public void testFromComponentsWithThreeComponents() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("OUT_PARAMETER")).build()));
        Assertions.assertNotNull((Object)path);
        Assertions.assertEquals((Object)"Intercom", (Object)path.getName());
        Assertions.assertEquals((Object)ComponentType.SERVICE, (Object)path.getComponentType());
        Assertions.assertEquals((Object)"OperationB", (Object)path.getNext().getName());
        Assertions.assertEquals((Object)ComponentType.OPERATION, (Object)path.getNext().getComponentType());
        Assertions.assertEquals((Object)ComponentType.OUT_PARAMETER, (Object)path.getNext().getNext().getComponentType());
        Assertions.assertNull((Object)path.getNext().getNext().getNext());
    }

    @Test
    @DisplayName(value="Given a ComponentPath, when calling getTail, then the tail is returned")
    public void testGetTail() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("OUT_PARAMETER")).build()));
        ComponentPath tail = path.getTail();
        Assertions.assertEquals((Object)"OUT_PARAMETER", (Object)tail.getName());
        Assertions.assertEquals((Object)ComponentType.OUT_PARAMETER, (Object)tail.getComponentType());
        Assertions.assertNull((Object)tail.getNext());
    }

    @Test
    @DisplayName(value="Given a ComponentPath, when calling removeTail, then the tail is removed")
    public void testRemoveTail() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("OUT_PARAMETER")).build()));
        ComponentPath tail = path.getTail();
        ComponentPath newPath = path.removeTail();
        Assertions.assertNotEquals((Object)path.getTail(), (Object)newPath.getTail());
        Assertions.assertEquals((Object)path.to(path.getNext()), (Object)newPath);
        Assertions.assertEquals((Object)tail, (Object)path.getTail());
    }

    @Test
    @DisplayName(value="Given a ComponentPath, when calling to(another ComponentPath), then the path is created correctly")
    public void testTo() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("outName")).build(), ObjectTypeComponent.builder().build()));
        ComponentPath expectedPath = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("outName")).build()));
        Assertions.assertEquals((Object)expectedPath, (Object)path.to(path.getNext().getNext()));
    }

    @Test
    @DisplayName(value="Given a ComponentPath with just one component, when calling to(another ComponentPath), then the head is returned")
    public void testToWithOneComponent() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build()));
        ComponentPath expectedPath = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build()));
        Assertions.assertEquals((Object)path, (Object)path.to(path.getNext()));
    }

    @Test
    @DisplayName(value="Given a ComponentPath with just one component, when calling removeTail, then the path is unchanged")
    public void testRemoveTailWithOneComponent() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build()));
        ComponentPath newPath = path.removeTail();
        Assertions.assertEquals((Object)path, (Object)newPath);
    }

    @Test
    @DisplayName(value="Given a ComponentPath, when calling toString, then the String representation is returned")
    public void testToString() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("outName")).build(), ObjectTypeComponent.builder().build()));
        Assertions.assertEquals((Object)"Intercom#SERVICE/OperationB#OPERATION/outName#OUT_PARAMETER/#OBJECT", (Object)path.toString());
    }

    @Test
    @DisplayName(value="Given a ComponentPath, when calling iterator, then returns a correct iterator")
    public void testIterator() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("outName")).build(), ObjectTypeComponent.builder().build()));
        Iterator iterator = path.iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"Intercom", (Object)((ComponentPath)iterator.next()).getName());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"OperationB", (Object)((ComponentPath)iterator.next()).getName());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"outName", (Object)((ComponentPath)iterator.next()).getName());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)ComponentType.OBJECT, (Object)((ComponentPath)iterator.next()).getComponentType());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    @DisplayName(value="Given a ComponentPath, when calling iterator#next with the empty iterator, then throws NoSuchElementException")
    public void testIteratorThrowsExceptionWhenNextOnEmpty() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("outName")).build(), ObjectTypeComponent.builder().build()));
        Iterator iterator = path.iterator();
        Assertions.assertEquals((Object)"Intercom", (Object)((ComponentPath)iterator.next()).getName());
        Assertions.assertEquals((Object)"OperationB", (Object)((ComponentPath)iterator.next()).getName());
        Assertions.assertEquals((Object)"outName", (Object)((ComponentPath)iterator.next()).getName());
        Assertions.assertEquals((Object)ComponentType.OBJECT, (Object)((ComponentPath)iterator.next()).getComponentType());
        Assertions.assertThrows(NoSuchElementException.class, () -> iterator.next());
    }

    @Test
    @DisplayName(value="Given a set of ComponentPath, when trying to get them, the equals and hashCode are correct")
    public void testEqualsAndHashCode() {
        Supplier<ComponentPath> path1 = () -> ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("outName")).build(), ObjectTypeComponent.builder().build()));
        Supplier<ComponentPath> path2 = () -> ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Netsuite")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationNetsuite")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("outNetsuite")).build(), ObjectTypeComponent.builder().build()));
        Supplier<ComponentPath> path3 = () -> ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Salesforce")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationSalesforce")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("outSalesforce")).build(), ObjectTypeComponent.builder().build()));
        Set<ComponentPath> paths = Set.of(path1.get(), path2.get(), path3.get());
        Assertions.assertTrue((boolean)paths.contains(path1.get()));
        Assertions.assertTrue((boolean)paths.contains(path2.get()));
        Assertions.assertTrue((boolean)paths.contains(path3.get()));
    }

    @Test
    @DisplayName(value="Given a ComponentPath, When serializing with ComponentPathTypeAdapter, then it is serialized correctly")
    public void testSerialize() {
        ComponentPath path = ComponentPath.fromComponents(List.of(((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("Intercom")).build(), ((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("OperationB")).build(), ((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name("outName")).build(), ObjectTypeComponent.builder().build()));
        ComponentPath.ComponentPathTypeAdapter componentPathTypeAdapter = new ComponentPath.ComponentPathTypeAdapter();
        Assertions.assertEquals((Object)"\"Intercom#SERVICE/OperationB#OPERATION/outName#OUT_PARAMETER/#OBJECT\"", (Object)componentPathTypeAdapter.toJson((Object)path));
    }
}

