%dw 2.7
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::flow::Metadata
import * from com::mulesoft::connectivity::transport::Http
import mapInputOperation from com::mulesoft::connectivity::decorator::Operation
import * from test001::Module

// Just a custom operation at the connector level
var getMessages : Operation<Null, HttpResponse<{messages: Array<String>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getMessages",
    displayName: "Get Messages",
        executor: (parameter, connection) -> success({
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {},
                body: {messages: ["Hello", "Good bye"]} <~ {mimeType: "application/json; charset=utf-8", raw: "" as Binary {base: "64"}}
        })
}

var getMessagesBase = {
    name: "getMessages",
    displayName: "Get Messages",
    executor: getMessages.executor,
    versions: {
        "2": getMessages mapInputOperation (p: {requiredParam: String}) -> null
    }
}

@FlowConnectorElement()
var connector = {
                    name: "TWILIO",
                    displayName: "Twilio",
                    description: "Twilio Connector",
                    vendor: "Salesforce",
                    since: "R256",
                    icons: [
                    	{
                    		name: "Twilio",
                    		alternateText: "Twilio Connector",
                    		resource: "icon/twilio.svg",
                    		size: 65440,
                    		dimensions: "32x32"
                    	}
                    ],
                    connections: {  basicAuth: connectionProvider,
                                    apikey: apiKeyHeaderConnectionProvider,
                                    oauth: oauth2AuthCodeConnectionProvider,
                                    oAuthAuthorizationCodeExtensions: oAuthAuthorizationCodeExtensions},
                    testConnection: testConnection,
                    operations: {
                            updateAccountById: updateAccountById,
                            getMessages: getMessagesBase,
                            getAccounts: getAccountsPaginated,
                            getUserById: getUserById
                      },
                      valueProviders: {
                          accountsValueProvider: accountsValueProvider,
                          usersValueProvider: usersValueProvider
                      },
                      metadataProviders: {
                          metadataProvider: metadataProvider
                      },
                      triggers:  {getUsersTrigger: getUsersTrigger}
                }
