/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataKey;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Arrays;
import java.util.List;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class UnionRule
extends Rule<UnionType> {
    public UnionRule() {
        super(UnionType.class);
    }

    protected void validate(Validatable<UnionType> validatable, ValidationContext ctx) {
        this.validateUnionType(validatable.getLocation(), ctx, (UnionType)validatable.getElement(), validatable.stringPath());
    }

    private void validateUnionType(Location location, ValidationContext ctx, UnionType type, String path) {
        List<DWType> types = List.of(type.unionOf());
        if (types.size() == 2) {
            DWType type1 = types.get(0);
            DWType type2 = types.get(1);
            if (type1 instanceof NullType || type2 instanceof NullType) {
                ctx.queue(ctx.validatable((Object)(type1 instanceof NullType ? type2 : type1)).build());
                return;
            }
        }
        if (!(this.isResultSetFilter(type) || this.isFieldSelector(type) || this.isEnumType(type) || this.isFieldOrder(type))) {
            ctx.addError(location, "Unsupported type" + (String)(path.isEmpty() ? "" : " at " + path) + ": " + String.valueOf(type), "InvalidFlowType");
        }
    }

    private boolean isResultSetFilter(UnionType type) {
        return UnionRule.hasKey(type, FlowMetadataKey.RESULT_SET_FILTER);
    }

    private static boolean hasKey(UnionType type, FlowMetadataKey key) {
        return Arrays.stream(type.getTypeMetadata()).anyMatch(m -> key.getKey().equals(m.getName()));
    }

    private boolean isFieldSelector(UnionType type) {
        return UnionRule.hasKey(type, FlowMetadataKey.FIELD_SELECTOR);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEnumType(UnionType type) {
        DWType[] types = type.unionOf();
        if (!Arrays.stream(types).allMatch(t -> {
            StringType st;
            return t instanceof StringType && (st = (StringType)t).getValue().isPresent() || t instanceof NullType;
        }) && !Arrays.stream(types).allMatch(t -> {
            NumberType nt;
            return t instanceof NumberType && (nt = (NumberType)t).getValue().isPresent() || t instanceof NullType;
        })) {
            if (!Arrays.stream(types).allMatch(t -> {
                BooleanType bt;
                return t instanceof BooleanType && (bt = (BooleanType)t).getValue().isPresent() || t instanceof NullType;
            })) return false;
        }
        if (Arrays.stream(types).allMatch(NullType.class::isInstance)) return false;
        return true;
    }

    private boolean isFieldOrder(UnionType type) {
        return UnionRule.hasKey(type, FlowMetadataKey.FIELD_ORDER);
    }
}

