/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.ComponentPath;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ComponentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public class ComponentRegistry {
    private final Map<Object, Component> components = new HashMap<Object, Component>();
    private final AtomicLong sequence = new AtomicLong();

    public Component getServiceComponent() {
        Component serviceComponent = this.components.get((Object)ComponentType.SERVICE);
        Objects.requireNonNull(serviceComponent, "Service Component not initialized");
        return serviceComponent;
    }

    public <T extends Component> T registerComponent(T component) {
        Objects.requireNonNull(component);
        if (!component.isUnique() || !this.components.containsKey(component.getKey())) {
            if (component.getId() == null) {
                component.setId(String.valueOf(this.sequence.incrementAndGet()));
            }
            this.components.put(component.getKey(), component);
        }
        return (T)this.components.get(component.getKey());
    }

    public void updateComponent(Component component) {
        Objects.requireNonNull(component);
        if (!this.isRegistered(component)) {
            throw new IllegalStateException("Component " + String.valueOf(component) + " is not registered");
        }
        this.components.put(component.getKey(), component);
    }

    public boolean isRegistered(Component component) {
        Objects.requireNonNull(component);
        return this.components.containsKey(component.getKey());
    }

    public Component getComponent(Object key) {
        return this.components.get(key);
    }

    public Optional<Component> getComponentById(String id) {
        return this.components.values().stream().filter(c -> c.getId().equals(id)).findFirst();
    }

    public ComponentPath getPath(Component component) {
        ArrayList<Component> components = new ArrayList<Component>();
        while (component != null) {
            components.add(component);
            component = this.getComponentById(component.getOuter()).orElse(null);
        }
        Collections.reverse(components);
        return ComponentPath.fromComponents(components);
    }

    @Generated
    public Map<Object, Component> getComponents() {
        return this.components;
    }
}

