/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataKey;
import com.mulesoft.connectivity.flow.api.validator.rules.QueryBuilderUnionRule;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class FieldOrderRule
extends Rule<UnionType> {
    private static final Set<String> SUPPORTED_ORDERS = Set.of("NOT_SORTED", "SORTED");

    public FieldOrderRule() {
        super(UnionType.class);
    }

    public boolean appliesTo(Validatable<UnionType> validatable) {
        return super.appliesTo(validatable) && Arrays.stream(((UnionType)validatable.getElement()).getTypeMetadata()).anyMatch(m -> FlowMetadataKey.FIELD_ORDER.getKey().equals(m.getName()));
    }

    protected void validate(Validatable<UnionType> validatable, ValidationContext ctx) {
        Optional labelOpt;
        UnionType type = (UnionType)validatable.getElement();
        Optional<DWMetadata> discriminatorMetadata = QueryBuilderUnionRule.getDiscriminatorMetadata(type);
        if (discriminatorMetadata.isPresent()) {
            List data = MetadataValueUtils.asProperties((DWMetadataValue)discriminatorMetadata.get().getValue());
            String discriminator = MetadataValueUtils.requireStringProperty((List)data, (String)"key");
            boolean hasOrder = Arrays.stream(type.unionOf()).allMatch(t -> QueryBuilderUnionRule.hasDiscriminator(t, discriminator, SUPPORTED_ORDERS));
            if (!hasOrder) {
                ctx.addError(type.getLocation(), "Field Order must have 'NOT_SORTED' and 'SORTED' kinds, at input: " + String.valueOf(type), "InvalidFlowType");
            }
        }
        if ((labelOpt = type.unionOf()[0].getLabel()).isEmpty() || !((String)labelOpt.get()).equals("QueryFieldNoOrder")) {
            ctx.addError(type.getLocation(), "QueryFieldNoOrder must be the first option of orderBy field, at input: " + String.valueOf(type), "InvalidFlowType");
        }
    }
}

