/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.mule.weave.v2.api.tooling.ts.DWType;

public class UniqueNameRule
extends Rule<DWType> {
    private static final EnumSet<ValidatableType> TYPE_TO_CHECK = EnumSet.of(ValidatableType.OPERATION, ValidatableType.VALUE_PROVIDER, ValidatableType.METADATA_PROVIDER, ValidatableType.TRIGGER);
    private final Map<String, Set<ValidatableType>> names = new HashMap<String, Set<ValidatableType>>();
    private final Map<String, Map<ValidatableType, Integer>> components = new HashMap<String, Map<ValidatableType, Integer>>();

    public UniqueNameRule() {
        super(DWType.class, TYPE_TO_CHECK);
    }

    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        ValidatableType constructType = UniqueNameRule.singleType(validatable);
        String name = (String)validatable.getName().orElseThrow(() -> new NullPointerException("This validatable element doesn't have a name"));
        Set items = this.names.computeIfAbsent(name, k -> new LinkedHashSet());
        items.add(constructType);
        Map componentNameItems = this.components.computeIfAbsent(name, k -> new LinkedHashMap());
        componentNameItems.put(constructType, 1);
        this.components.put(name, componentNameItems);
    }

    private static ValidatableType singleType(Validatable<DWType> validatable) {
        Object allTypes = TYPE_TO_CHECK.clone();
        ((AbstractCollection)allTypes).retainAll(validatable.getTypes());
        return (ValidatableType)((AbstractCollection)allTypes).iterator().next();
    }

    public void runAfter(DWType connector, ValidationContext ctx) {
        for (Map.Entry<String, Map<ValidatableType, Integer>> entries : this.components.entrySet()) {
            if (!UniqueNameRule.isDuplicatedConstruct(entries.getValue())) continue;
            ctx.addError(connector.getLocation(), "Duplicated construct name '" + entries.getKey() + "' found in: " + String.valueOf(entries.getValue().keySet()), "connector");
        }
    }

    private static boolean isDuplicatedConstruct(Map<ValidatableType, Integer> entries) {
        return entries.values().stream().mapToInt(n -> n).limit(2L).sum() > 1;
    }
}

