/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataKey;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProvidedValue;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class QueryBuilderUnionRule
extends Rule<UnionType> {
    public QueryBuilderUnionRule() {
        super(UnionType.class);
    }

    protected void validate(Validatable<UnionType> validatable, ValidationContext ctx) {
        this.validateDiscriminator((UnionType)validatable.getElement(), ctx, validatable.stringPath());
    }

    public boolean appliesTo(Validatable<UnionType> validatable) {
        return super.appliesTo(validatable) && Arrays.stream(((UnionType)validatable.getElement()).getTypeMetadata()).anyMatch(m -> FlowMetadataKey.RESULT_SET_FILTER.getKey().equals(m.getName()) || FlowMetadataKey.FIELD_SELECTOR.getKey().equals(m.getName()) || FlowMetadataKey.FIELD_ORDER.getKey().equals(m.getName()));
    }

    private void validateDiscriminator(UnionType type, ValidationContext ctx, String path) {
        Optional<DWMetadata> discriminatorMetadata = QueryBuilderUnionRule.getDiscriminatorMetadata(type);
        if (discriminatorMetadata.isPresent()) {
            List data = MetadataValueUtils.asProperties((DWMetadataValue)discriminatorMetadata.get().getValue());
            String discriminator = MetadataValueUtils.requireStringProperty((List)data, (String)"key");
            List<DWType> elementsWithoutDiscriminatorField = Arrays.stream(type.unionOf()).filter(t -> !QueryBuilderUnionRule.hasDiscriminator(t, discriminator, Collections.emptySet())).toList();
            elementsWithoutDiscriminatorField.forEach(t -> ctx.addError(t.getLocation(), "Union member " + String.valueOf(t) + " doesn't contain the field '" + discriminator + "' which was declared with a Discriminator annotation" + (String)(path.isEmpty() ? "" : " at " + path) + ": " + String.valueOf(type), "InvalidFlowType"));
            if (elementsWithoutDiscriminatorField.isEmpty()) {
                this.validateDiscriminatorValues(type, ctx);
            }
        } else {
            ctx.addError(type.getLocation(), "Union types should have a Discriminator annotation" + (String)(path.isEmpty() ? "" : " at " + path) + ": " + String.valueOf(type), "InvalidFlowType");
        }
    }

    private void validateDiscriminatorValues(UnionType type, ValidationContext ctx) {
        MetadataUtils.getDiscriminator((DWType)type).ifPresent(d -> this.validateDiscriminatorDuplicatedValues(type, d.getValues(), ctx));
    }

    private void validateDiscriminatorDuplicatedValues(UnionType type, List<ProvidedValue> values, ValidationContext ctx) {
        HashSet<String> seenValues = new HashSet<String>();
        for (ProvidedValue providedValue : values) {
            String value = (String)providedValue.getValue();
            if (seenValues.add(value)) continue;
            ctx.addError(type.getLocation(), "Discriminator has duplicate value: '" + value + "'", "InvalidFlowType");
        }
    }

    static Optional<DWMetadata> getDiscriminatorMetadata(UnionType type) {
        return type.getTypeMetadata(MetadataKey.DISCRIMINATOR.getKey());
    }

    static boolean hasDiscriminator(DWType type, String discriminator, Set<String> supportedValues) {
        if (type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)type;
            return QueryBuilderUnionRule.hasDiscriminator(referenceType.resolveType(), discriminator, supportedValues);
        }
        if (type instanceof IntersectionType) {
            IntersectionType intersectionType = (IntersectionType)type;
            return Arrays.stream(intersectionType.intersectionOf()).anyMatch(t -> QueryBuilderUnionRule.hasDiscriminator(t, discriminator, supportedValues));
        }
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            return Arrays.stream(objectType.getProperties()).anyMatch(p -> DWTypeUtils.getKey((KeyValuePairType)p).equals(discriminator) && p.getValue() instanceof StringType && ((StringType)p.getValue()).getValue().isPresent() && (supportedValues.isEmpty() || supportedValues.contains(((StringType)p.getValue()).getValue().get())));
        }
        return false;
    }
}

