/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.fixtures;

import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.Map;
import java.util.TreeMap;
import org.junit.jupiter.api.Assertions;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.TypeType;
import org.mule.weave.v2.ts.WeaveType;

public class QueryBuilderTestUtils {
    public static final DataWeaveScriptingEngine ENGINE = new DataWeaveScriptingEngine();

    public static DWType compileScript(String script) {
        try {
            WeaveType weaveType = (WeaveType)ENGINE.inferTypeOf(script).get();
            WeaveType dwType = ((TypeType)weaveType).getType();
            Assertions.assertNotNull((Object)dwType, (String)"Compiled DWType should not be null");
            return dwType;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compile DataWeave script: " + e.getMessage(), e);
        }
    }

    public static OperationModel createOperationModel(String script, String operationName) {
        DWType inputType = QueryBuilderTestUtils.compileScript(script);
        String outputScript = "%dw 2.8\ntype OutputType = Array<{\n  id: String,\n  name: String,\n  value: Any\n}>\n---\nOutputType\n";
        DWType outputType = QueryBuilderTestUtils.compileScript(outputScript);
        TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
        Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
        TypeModel outputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
        Mockito.when((Object)outputTypeModel.getDataType()).thenReturn((Object)outputType);
        TreeMap versions = new TreeMap();
        OperationModel operation = (OperationModel)Mockito.mock(OperationModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)operation.getName()).thenReturn((Object)operationName);
        Mockito.when((Object)operation.getDisplayName()).thenReturn((Object)(operationName + " Display Name"));
        Mockito.when((Object)operation.getInputType()).thenReturn((Object)inputTypeModel);
        Mockito.when((Object)operation.getOutputType()).thenReturn((Object)outputTypeModel);
        Mockito.when((Object)operation.getErrorOutputType()).thenReturn((Object)outputTypeModel);
        Mockito.when((Object)operation.isPaginated()).thenReturn((Object)false);
        Mockito.when((Object)operation.getVersions()).thenReturn(versions);
        Mockito.when((Object)operation.isBase()).thenReturn((Object)true);
        Mockito.when((Object)operation.getInputResolvedProviders()).thenReturn(Map.of());
        Mockito.when((Object)operation.getOutputResolvedProviders()).thenReturn(Map.of());
        return operation;
    }

    public static OperationModel createOperationModel(String operationName, String inputScript, String outputScript) {
        DWType inputType = QueryBuilderTestUtils.compileScript(inputScript);
        DWType outputType = QueryBuilderTestUtils.compileScript(outputScript);
        TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
        Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
        TypeModel outputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
        Mockito.when((Object)outputTypeModel.getDataType()).thenReturn((Object)outputType);
        TreeMap versions = new TreeMap();
        OperationModel operation = (OperationModel)Mockito.mock(OperationModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)operation.getName()).thenReturn((Object)operationName);
        Mockito.when((Object)operation.getDisplayName()).thenReturn((Object)(operationName + " Display Name"));
        Mockito.when((Object)operation.getInputType()).thenReturn((Object)inputTypeModel);
        Mockito.when((Object)operation.getOutputType()).thenReturn((Object)outputTypeModel);
        Mockito.when((Object)operation.isPaginated()).thenReturn((Object)false);
        Mockito.when((Object)operation.getVersions()).thenReturn(versions);
        Mockito.when((Object)operation.isBase()).thenReturn((Object)true);
        Mockito.when((Object)operation.getInputResolvedProviders()).thenReturn(Map.of());
        Mockito.when((Object)operation.getOutputResolvedProviders()).thenReturn(Map.of());
        return operation;
    }

    public static TriggerModel createTriggerModel(String script, String triggerName) {
        DWType inputType = QueryBuilderTestUtils.compileScript(script);
        String outputScript = "%dw 2.8\ntype TriggerOutputType = {\n  eventId: String,\n  timestamp: DateTime,\n  data: Any\n}\n---\nTriggerOutputType\n";
        DWType outputType = QueryBuilderTestUtils.compileScript(outputScript);
        TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
        Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
        TypeModel outputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
        Mockito.when((Object)outputTypeModel.getDataType()).thenReturn((Object)outputType);
        TreeMap versions = new TreeMap();
        TriggerModel trigger = (TriggerModel)Mockito.mock(TriggerModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)trigger.getName()).thenReturn((Object)triggerName);
        Mockito.when((Object)trigger.getDisplayName()).thenReturn((Object)(triggerName + " Display Name"));
        Mockito.when((Object)trigger.getInputType()).thenReturn((Object)inputTypeModel);
        Mockito.when((Object)trigger.getOutputType()).thenReturn((Object)outputTypeModel);
        Mockito.when((Object)trigger.getErrorOutputType()).thenReturn((Object)outputTypeModel);
        Mockito.when((Object)trigger.getVersions()).thenReturn(versions);
        Mockito.when((Object)trigger.isBase()).thenReturn((Object)true);
        Mockito.when((Object)trigger.getInputResolvedProviders()).thenReturn(Map.of());
        Mockito.when((Object)trigger.getOutputResolvedProviders()).thenReturn(Map.of());
        Mockito.when((Object)trigger.order()).thenReturn((Object)"ASC");
        return trigger;
    }

    private QueryBuilderTestUtils() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }
}

