/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataUtils;
import com.mulesoft.connectivity.flow.fixtures.QueryBuilderTestUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder.ObjectMetadataAssertion;
import com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder.QueryBuilderAdapter;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.NavigableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.impl.ts.catalog.DefaultDWTypeCatalog;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class QueryBuilderAdapterTest {
    @Test
    @DisplayName(value="Ensures QueryBuilderAdapter class can not be instantiated")
    void testQueryBuilderAdapterInstantiationFails() throws NoSuchMethodException {
        Constructor constructor = QueryBuilderAdapter.class.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        try {
            constructor.newInstance(new Object[0]);
            Assertions.fail((String)"Expected UnsupportedOperationException");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Assertions.assertInstanceOf(UnsupportedOperationException.class, (Object)cause);
            Assertions.assertEquals((Object)"This is a utility class and cannot be instantiated", (Object)cause.getMessage());
        }
    }

    @Nested
    @DisplayName(value="Output Structure Validation")
    public class OutputStructureValidation {
        @Test
        @DisplayName(value="GIVEN QueryBuilder operation with standard fields WHEN adapted THEN generates expected structure")
        public void testStandardQueryBuilderTransformation() {
            String inputScript = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\ntype StandardQueryBuilder = @QueryBuilder() {\n    objectType: String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String\n}\n---\nStandardQueryBuilder\n";
            DWType inputType = QueryBuilderTestUtils.compileScript(inputScript);
            OperationModel originalOperation = this.createMockOperationModel(inputType);
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            DWType actualTransformedType = adaptedOperation.getInputType().getDataType();
            Assertions.assertNotNull((Object)adaptedOperation, (String)"Adapted operation should not be null");
            Assertions.assertTrue((boolean)FlowMetadataUtils.isQueryBuilder((DWType)actualTransformedType), (String)"Transformed type should maintain QueryBuilder annotation");
            String actualTypeString = this.serializeDWType(actualTransformedType);
            Assertions.assertTrue((boolean)actualTypeString.contains("objectType"), (String)"Transformed structure should contain objectType field");
            Assertions.assertTrue((boolean)actualTypeString.contains("projectedFields"), (String)"Transformed structure should contain projectedFields field");
            Assertions.assertTrue((boolean)actualTypeString.contains("filter"), (String)"Transformed structure should contain filter field");
            Assertions.assertTrue((boolean)actualTypeString.contains("ProjectedFieldsType"), (String)"Should contain ProjectedFieldsType reference");
            Assertions.assertTrue((boolean)actualTypeString.contains("QueryResultSetFilter"), (String)"Should contain QueryResultSetFilter reference");
            String expectedMetadata = "{\n  \"projectedFields\": {\n    \"metadata\": [\n      \"flow.fieldSelector\",\n      \"valueProvider\"\n    ],\n    \"valueProvider\": {\n      \"name\": \"fieldsValueProvider\",\n      \"arguments\": { \"objectType\": \"/objectType\" }\n    },\n    \"type\": \"ProjectedFieldsType\"\n  },\n  \"filter\": {\n    \"metadata\": [\n      \"flow.resultSetFilter\"\n    ],\n    \"type\": \"QueryResultSetFilter\"\n  }\n}";
            ObjectMetadataAssertion.assertMetadata(expectedMetadata, actualTransformedType);
        }

        @Test
        @DisplayName(value="GIVEN QueryBuilder operation with custom field names WHEN adapted THEN preserves field names")
        public void testCustomFieldNamesTransformation() {
            String inputScript = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\ntype CustomQueryBuilder = @QueryBuilder() {\n    entityType: String,\n    recordFields: @FieldSelector() Array<String>,\n    recordFilter: @ResultSetFilter() String\n}\n---\nCustomQueryBuilder\n";
            DWType inputType = QueryBuilderTestUtils.compileScript(inputScript);
            OperationModel originalOperation = this.createMockOperationModel(inputType);
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            DWType actualTransformedType = adaptedOperation.getInputType().getDataType();
            String actualTypeString = this.serializeDWType(actualTransformedType);
            Assertions.assertTrue((boolean)actualTypeString.contains("entityType"), (String)"Custom field name entityType should be preserved");
            Assertions.assertTrue((boolean)actualTypeString.contains("recordFields"), (String)"Custom field name recordFields should be preserved");
            Assertions.assertTrue((boolean)actualTypeString.contains("recordFilter"), (String)"Custom field name recordFilter should be preserved");
            String expectedMetadata = "{\n  \"recordFields\": {\n    \"metadata\": [\n      \"flow.fieldSelector\",\n      \"valueProvider\"\n    ],\n    \"valueProvider\": {\n      \"name\": \"fieldsValueProvider\",\n      \"arguments\": { \"objectType\": \"/objectType\" }\n    },\n    \"type\": \"ProjectedFieldsType\"\n  },\n  \"recordFilter\": {\n    \"metadata\": [\n      \"flow.resultSetFilter\"\n    ],\n    \"type\": \"QueryResultSetFilter\"\n  }\n}";
            ObjectMetadataAssertion.assertMetadata(expectedMetadata, actualTransformedType);
        }

        @Test
        @DisplayName(value="GIVEN minimal QueryBuilder operation WHEN adapted THEN creates complete structure")
        public void testMinimalQueryBuilderTransformation() {
            String inputScript = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\ntype MinimalQueryBuilder = @QueryBuilder() {\n    objectType: String,\n    projectedFields: @FieldSelector() Array<String>\n}\n---\nMinimalQueryBuilder\n";
            DWType inputType = QueryBuilderTestUtils.compileScript(inputScript);
            OperationModel originalOperation = this.createMockOperationModel(inputType);
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            DWType actualTransformedType = adaptedOperation.getInputType().getDataType();
            String actualTypeString = this.serializeDWType(actualTransformedType);
            Assertions.assertTrue((boolean)actualTypeString.contains("objectType"), (String)"Should contain objectType field");
            Assertions.assertTrue((boolean)actualTypeString.contains("projectedFields"), (String)"Should contain projectedFields field");
            Assertions.assertTrue((boolean)actualTypeString.contains("filter"), (String)"Should contain default filter field");
            String expectedMetadata = "{\n  \"projectedFields\": {\n    \"metadata\": [\n      \"flow.fieldSelector\",\n      \"valueProvider\"\n    ],\n    \"valueProvider\": {\n      \"name\": \"fieldsValueProvider\",\n      \"arguments\": { \"objectType\": \"/objectType\" }\n    },\n    \"type\": \"ProjectedFieldsType\"\n  },\n  \"filter\": {\n    \"metadata\": [\n      \"flow.resultSetFilter\"\n    ],\n    \"type\": \"QueryResultSetFilter\"\n  }\n}";
            ObjectMetadataAssertion.assertMetadata(expectedMetadata, actualTransformedType);
        }

        private String serializeDWType(DWType dwType) {
            try {
                return DefaultDWTypeCatalog.loader().withErrorHandler(errorMessages -> {
                    throw new RuntimeException(String.join((CharSequence)"\n", errorMessages));
                }).withTypes(Map.of("TestType", dwType)).build().write();
            }
            catch (Exception e) {
                return dwType.toString();
            }
        }

        private OperationModel createMockOperationModel(DWType inputType) {
            OperationModel operation = (OperationModel)Mockito.mock(OperationModel.class);
            TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            TypeModel outputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            ObjectType outputType = (ObjectType)Mockito.mock(ObjectType.class);
            NavigableMap versions = (NavigableMap)Mockito.mock(NavigableMap.class);
            Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
            Mockito.when((Object)outputTypeModel.getDataType()).thenReturn((Object)outputType);
            Mockito.when((Object)operation.getInputType()).thenReturn((Object)inputTypeModel);
            Mockito.when((Object)operation.getOutputType()).thenReturn((Object)outputTypeModel);
            Mockito.when((Object)operation.getErrorOutputType()).thenReturn((Object)((TypeModel)Mockito.mock(TypeModel.class)));
            Mockito.when((Object)operation.getName()).thenReturn((Object)"query");
            Mockito.when((Object)operation.getDisplayName()).thenReturn((Object)"Query Builder");
            Mockito.when((Object)operation.getVersions()).thenReturn((Object)versions);
            Mockito.when((Object)operation.isBase()).thenReturn((Object)true);
            Mockito.when((Object)operation.getInputResolvedProviders()).thenReturn(Map.of());
            Mockito.when((Object)operation.getOutputResolvedProviders()).thenReturn(Map.of());
            return operation;
        }
    }

    @Nested
    @DisplayName(value="Edge Cases and Error Handling")
    public class EdgeCasesAndErrorHandling {
        @Test
        @DisplayName(value="GIVEN null OperationModel WHEN adapting THEN handles gracefully")
        public void testAdaptNullOperation() {
            Assertions.assertThrows(NullPointerException.class, () -> QueryBuilderAdapter.adapt((OperationModel)null), (String)"Should throw NPE for null operation");
        }

        @Test
        @DisplayName(value="GIVEN type without metadata WHEN processing THEN handles empty metadata gracefully")
        public void testProcessTypeWithoutMetadata() {
            String script = "%dw 2.8\n\ntype SimpleType = {\n    name: String,\n    value: Number\n}\n---\nSimpleType\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            Assertions.assertDoesNotThrow(() -> {
                OperationModel mockOperation = this.createMockOperationModel(compiledType);
                OperationModel result = QueryBuilderAdapter.adapt((OperationModel)mockOperation);
                Assertions.assertNotNull((Object)result, (String)"Should handle types without metadata");
            });
        }

        private OperationModel createMockOperationModel(DWType inputType) {
            OperationModel operation = (OperationModel)Mockito.mock(OperationModel.class);
            TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
            Mockito.when((Object)operation.getInputType()).thenReturn((Object)inputTypeModel);
            Mockito.when((Object)operation.getName()).thenReturn((Object)"testOperation");
            Mockito.when((Object)operation.getDisplayName()).thenReturn((Object)"Test Operation");
            return operation;
        }
    }

    @Nested
    @DisplayName(value="Input Resolver Generation")
    public class InputResolverGeneration {
        @Test
        @DisplayName(value="GIVEN QueryBuilder operation with discriminator fields WHEN adapted THEN processes resolvers correctly")
        public void testAdaptOperationWithDiscriminatorFields() {
            String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: {key: String, defaultSelection?: String} = {key: \"\"})\n\ntype AllFieldsSelection = {\n    kind: \"ALL\"\n}\n\ntype CustomFieldsSelection = {\n    kind: \"CUSTOM\",\n    fields: Array<String>\n}\n\ntype QueryBuilderWithDiscriminators = @QueryBuilder() {\n    objectType: String,\n    projectedFields: @FieldSelector() @Discriminator(value = {key: \"kind\", defaultSelection: \"ALL\"}) (AllFieldsSelection | CustomFieldsSelection)\n}\n---\nQueryBuilderWithDiscriminators\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            OperationModel originalOperation = this.createMockOperationModel(compiledType);
            Assertions.assertDoesNotThrow(() -> {
                OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
                Assertions.assertNotNull((Object)adaptedOperation, (String)"Operation with discriminator fields should be adapted successfully");
                Assertions.assertTrue((boolean)FlowMetadataUtils.isQueryBuilder((DWType)adaptedOperation.getInputType().getDataType()), (String)"Should maintain QueryBuilder annotation");
            });
        }

        private OperationModel createMockOperationModel(DWType inputType) {
            return this.createMockOperationModelWithResolvers(inputType, Map.of());
        }

        private OperationModel createMockOperationModelWithResolvers(DWType inputType, Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> inputResolvers) {
            OperationModel operation = (OperationModel)Mockito.mock(OperationModel.class);
            TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            TypeModel outputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            ObjectType outputType = (ObjectType)Mockito.mock(ObjectType.class);
            NavigableMap versions = (NavigableMap)Mockito.mock(NavigableMap.class);
            Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
            Mockito.when((Object)outputTypeModel.getDataType()).thenReturn((Object)outputType);
            Mockito.when((Object)operation.getInputType()).thenReturn((Object)inputTypeModel);
            Mockito.when((Object)operation.getOutputType()).thenReturn((Object)outputTypeModel);
            Mockito.when((Object)operation.getErrorOutputType()).thenReturn((Object)((TypeModel)Mockito.mock(TypeModel.class)));
            Mockito.when((Object)operation.getName()).thenReturn((Object)"query");
            Mockito.when((Object)operation.getDisplayName()).thenReturn((Object)"Query Builder");
            Mockito.when((Object)operation.getVersions()).thenReturn((Object)versions);
            Mockito.when((Object)operation.isBase()).thenReturn((Object)true);
            Mockito.when((Object)operation.getInputResolvedProviders()).thenReturn(inputResolvers);
            Mockito.when((Object)operation.getOutputResolvedProviders()).thenReturn(Map.of());
            return operation;
        }
    }

    @Nested
    @DisplayName(value="Value Provider Integration")
    public class ValueProviderIntegration {
        @Test
        @DisplayName(value="GIVEN QueryBuilder with ValueProvider annotations WHEN adapted THEN processes successfully")
        public void testAdaptOperationWithValueProviders() {
            String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"ValuesFrom\")\nannotation ValuesFrom(value: {name: String} = {name: \"\"})\n\ntype QueryBuilderWithValueProvider = @QueryBuilder() {\n    objectType: @ValuesFrom(value = {name: \"objectTypeProvider\"}) String,\n    projectedFields: @FieldSelector() @ValuesFrom(value = {name: \"fieldsProvider\"}) Array<String>\n}\n---\nQueryBuilderWithValueProvider\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            OperationModel originalOperation = this.createMockOperationModel(compiledType);
            Assertions.assertDoesNotThrow(() -> {
                OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
                Assertions.assertNotNull((Object)adaptedOperation, (String)"Operation with value providers should be adapted successfully");
                Assertions.assertTrue((boolean)FlowMetadataUtils.isQueryBuilder((DWType)adaptedOperation.getInputType().getDataType()), (String)"Should maintain QueryBuilder annotation");
            });
        }

        private OperationModel createMockOperationModel(DWType inputType) {
            OperationModel operation = (OperationModel)Mockito.mock(OperationModel.class);
            TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            TypeModel outputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            ObjectType outputType = (ObjectType)Mockito.mock(ObjectType.class);
            NavigableMap versions = (NavigableMap)Mockito.mock(NavigableMap.class);
            Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
            Mockito.when((Object)outputTypeModel.getDataType()).thenReturn((Object)outputType);
            Mockito.when((Object)operation.getInputType()).thenReturn((Object)inputTypeModel);
            Mockito.when((Object)operation.getOutputType()).thenReturn((Object)outputTypeModel);
            Mockito.when((Object)operation.getErrorOutputType()).thenReturn((Object)((TypeModel)Mockito.mock(TypeModel.class)));
            Mockito.when((Object)operation.getName()).thenReturn((Object)"query");
            Mockito.when((Object)operation.getDisplayName()).thenReturn((Object)"Query Builder");
            Mockito.when((Object)operation.getVersions()).thenReturn((Object)versions);
            Mockito.when((Object)operation.isBase()).thenReturn((Object)true);
            Mockito.when((Object)operation.getInputResolvedProviders()).thenReturn(Map.of());
            Mockito.when((Object)operation.getOutputResolvedProviders()).thenReturn(Map.of());
            return operation;
        }
    }

    @Nested
    @DisplayName(value="Input Type Creation")
    public class InputTypeCreation {
        @Test
        @DisplayName(value="GIVEN QueryBuilder operation with standard fields WHEN adapted THEN creates proper input structure")
        public void testAdaptOperationWithStandardFields() {
            String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\ntype StandardQueryBuilder = @QueryBuilder() {\n    objectType: String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String\n}\n---\nStandardQueryBuilder\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            OperationModel originalOperation = this.createMockOperationModel(compiledType);
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            Assertions.assertNotNull((Object)adaptedOperation, (String)"Adapted operation should not be null");
            Assertions.assertNotNull((Object)adaptedOperation.getInputType(), (String)"Input type should be preserved");
            Assertions.assertTrue((boolean)FlowMetadataUtils.isQueryBuilder((DWType)adaptedOperation.getInputType().getDataType()), (String)"Adapted operation should maintain QueryBuilder annotation");
            DWType adaptedInputType = adaptedOperation.getInputType().getDataType();
            String expectedMetadataStructure = "{\n  \"projectedFields\": {\n    \"metadata\": [\n      \"flow.fieldSelector\",\n      \"valueProvider\"\n    ],\n    \"valueProvider\": {\n      \"name\": \"fieldsValueProvider\",\n      \"arguments\": { \"objectType\": \"/objectType\" }\n    },\n    \"type\": \"ProjectedFieldsType\"\n  },\n  \"filter\": {\n    \"metadata\": [\n      \"flow.resultSetFilter\"\n    ],\n    \"type\": \"QueryResultSetFilter\"\n  }\n}";
            ObjectMetadataAssertion.assertMetadata(expectedMetadataStructure, adaptedInputType);
            Assertions.assertEquals((Object)"query", (Object)adaptedOperation.getName(), (String)"Operation name should be preserved");
            Assertions.assertEquals((Object)"Query Builder", (Object)adaptedOperation.getDisplayName(), (String)"Display name should be preserved");
            Assertions.assertTrue((boolean)adaptedOperation.isBase(), (String)"Base operation flag should be preserved");
        }

        @Test
        @DisplayName(value="GIVEN QueryBuilder operation with custom field names WHEN adapted THEN preserves field names")
        public void testCustomFieldNamesTransformation() {
            String inputScript = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\ntype CustomQueryBuilder = @QueryBuilder() {\n    entityType: String,\n    recordFields: @FieldSelector() Array<String>,\n    recordFilter: @ResultSetFilter() String\n}\n---\nCustomQueryBuilder\n";
            DWType inputType = QueryBuilderTestUtils.compileScript(inputScript);
            OperationModel originalOperation = this.createMockOperationModel(inputType);
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            DWType actualTransformedType = adaptedOperation.getInputType().getDataType();
            String actualTypeString = this.serializeDWType(actualTransformedType);
            Assertions.assertTrue((boolean)actualTypeString.contains("entityType"), (String)"Custom field name entityType should be preserved");
            Assertions.assertTrue((boolean)actualTypeString.contains("recordFields"), (String)"Custom field name recordFields should be preserved");
            Assertions.assertTrue((boolean)actualTypeString.contains("recordFilter"), (String)"Custom field name recordFilter should be preserved");
            String expectedMetadata = "{\n  \"recordFields\": {\n    \"metadata\": [\n      \"flow.fieldSelector\",\n      \"valueProvider\"\n    ],\n    \"valueProvider\": {\n      \"name\": \"fieldsValueProvider\",\n      \"arguments\": { \"objectType\": \"/objectType\" }\n    },\n    \"type\": \"ProjectedFieldsType\"\n  },\n  \"recordFilter\": {\n    \"metadata\": [\n      \"flow.resultSetFilter\"\n    ],\n    \"type\": \"QueryResultSetFilter\"\n  }\n}";
            ObjectMetadataAssertion.assertMetadata(expectedMetadata, actualTransformedType);
        }

        private OperationModel createMockOperationModel(DWType inputType) {
            OperationModel operation = (OperationModel)Mockito.mock(OperationModel.class);
            TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            TypeModel outputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            ObjectType outputType = (ObjectType)Mockito.mock(ObjectType.class);
            NavigableMap versions = (NavigableMap)Mockito.mock(NavigableMap.class);
            Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
            Mockito.when((Object)outputTypeModel.getDataType()).thenReturn((Object)outputType);
            Mockito.when((Object)operation.getInputType()).thenReturn((Object)inputTypeModel);
            Mockito.when((Object)operation.getOutputType()).thenReturn((Object)outputTypeModel);
            Mockito.when((Object)operation.getErrorOutputType()).thenReturn((Object)((TypeModel)Mockito.mock(TypeModel.class)));
            Mockito.when((Object)operation.getName()).thenReturn((Object)"query");
            Mockito.when((Object)operation.getDisplayName()).thenReturn((Object)"Query Builder");
            Mockito.when((Object)operation.getVersions()).thenReturn((Object)versions);
            Mockito.when((Object)operation.isBase()).thenReturn((Object)true);
            Mockito.when((Object)operation.getInputResolvedProviders()).thenReturn(Map.of());
            Mockito.when((Object)operation.getOutputResolvedProviders()).thenReturn(Map.of());
            return operation;
        }

        private String serializeDWType(DWType dwType) {
            try {
                return DefaultDWTypeCatalog.loader().withErrorHandler(errorMessages -> {
                    throw new RuntimeException(String.join((CharSequence)"\n", errorMessages));
                }).withTypes(Map.of("TestType", dwType)).build().write();
            }
            catch (Exception e) {
                return dwType.toString();
            }
        }
    }

    @Nested
    @DisplayName(value="Trigger Model Adaptation")
    public class TriggerModelAdaptation {
        @Test
        @DisplayName(value="GIVEN TriggerModel with @QueryBuilder annotation WHEN adapted THEN preserves QueryBuilder metadata")
        public void testAdaptTriggerWithQueryBuilder() {
            String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: { key: String, defaultSelection?: String })\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\ntype QueryFieldNoOrder = {|\n    kind: \"NOT_SORTED\"\n|}\n\ntype QueryOrder = \"ASC\" | \"DESC\"\n\ntype QueryFieldOrder = {|\n    kind: \"SORTED\"\n|}\n\ntype QueryFieldOrderPair<F <: String> = {|\n   field: F,\n   order: QueryOrder\n|}\n\ntype QueryManyFieldsManySortingOrder<F <: String> = QueryFieldOrder & {|\n    fields: Array<QueryFieldOrderPair<F>>\n|}\n\ntype QueryBuilderTrigger = @QueryBuilder() {\n    objectType: String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String,\n    orderBy: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() QueryFieldNoOrder | QueryManyFieldsManySortingOrder<String>\n}\n---\nQueryBuilderTrigger\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            TriggerModel originalTrigger = this.createMockTriggerModel(compiledType);
            TriggerModel result = QueryBuilderAdapter.adapt((TriggerModel)originalTrigger);
            Assertions.assertNotNull((Object)result, (String)"Adapted trigger should not be null");
            Assertions.assertTrue((boolean)FlowMetadataUtils.isQueryBuilder((DWType)result.getInputType().getDataType()), (String)"Adapted trigger should maintain QueryBuilder annotation");
            String expectedMetadata = "{\n  \"projectedFields\": {\n    \"metadata\": [\n      \"flow.fieldSelector\",\n      \"valueProvider\"\n    ],\n    \"valueProvider\": {\n      \"name\": \"fieldsValueProvider\",\n      \"arguments\": { \"objectType\": \"/objectType\" }\n    },\n    \"type\": \"ProjectedFieldsType\"\n  },\n  \"filter\": {\n    \"metadata\": [\n      \"flow.resultSetFilter\"\n    ],\n    \"type\": \"QueryResultSetFilter\"\n  },\n  \"orderBy\": {\n    \"type\": \"QueryManyFieldsManySortingOrder\",\n    \"metadata\": [\n      \"flow.fieldOrder\"\n    ]\n  }\n}";
            ObjectMetadataAssertion.assertMetadata(expectedMetadata, result.getInputType().getDataType());
        }

        @Test
        @DisplayName(value="GIVEN TriggerModel with property-level QB annotations WHEN adapted THEN processes individual properties")
        public void testAdaptTriggerWithPropertyLevelAnnotations() {
            String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\ntype TriggerWithPropertyAnnotations = {\n    entityType: String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String\n}\n---\nTriggerWithPropertyAnnotations\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            TriggerModel originalTrigger = this.createMockTriggerModel(compiledType);
            TriggerModel result = QueryBuilderAdapter.adapt((TriggerModel)originalTrigger);
            Assertions.assertNotNull((Object)result, (String)"Result should not be null");
            Assertions.assertTrue((boolean)FlowMetadataUtils.isQueryBuilder((DWType)result.getInputType().getDataType()), (String)"Should be detected as QueryBuilder because adapter adds the annotation when both FieldSelector and ResultSetFilter are present");
            String expectedMetadata = "{\n  \"projectedFields\": {\n    \"metadata\": [\n      \"flow.fieldSelector\",\n      \"valueProvider\"\n    ],\n    \"valueProvider\": {\n      \"name\": \"fieldsValueProvider\",\n      \"arguments\": { \"objectType\": \"/objectType\" }\n    },\n    \"type\": \"ProjectedFieldsType\"\n  },\n  \"filter\": {\n    \"metadata\": [\n      \"flow.resultSetFilter\"\n    ],\n    \"type\": \"QueryResultSetFilter\"\n  }\n}";
            ObjectMetadataAssertion.assertMetadata(expectedMetadata, result.getInputType().getDataType());
        }

        @Test
        @DisplayName(value="GIVEN trigger with FieldSelector and ResultSetFilter WHEN adapted THEN adds QueryBuilder annotation")
        public void testTriggerTransformationWithAddedQueryBuilder() {
            String inputScript = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\ntype TriggerWithAnnotations = {\n    entityType: String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String\n}\n---\nTriggerWithAnnotations\n";
            DWType inputType = QueryBuilderTestUtils.compileScript(inputScript);
            TriggerModel originalTrigger = this.createMockTriggerModel(inputType);
            TriggerModel adaptedTrigger = QueryBuilderAdapter.adapt((TriggerModel)originalTrigger);
            DWType actualTransformedType = adaptedTrigger.getInputType().getDataType();
            Assertions.assertTrue((boolean)FlowMetadataUtils.isQueryBuilder((DWType)actualTransformedType), (String)"Trigger should have QueryBuilder annotation added automatically");
            String expectedMetadata = "{\n  \"projectedFields\": {\n    \"metadata\": [\n      \"flow.fieldSelector\",\n      \"valueProvider\"\n    ],\n    \"valueProvider\": {\n      \"name\": \"fieldsValueProvider\",\n      \"arguments\": { \"objectType\": \"/objectType\" }\n    },\n    \"type\": \"ProjectedFieldsType\"\n  },\n  \"filter\": {\n    \"metadata\": [\n      \"flow.resultSetFilter\"\n    ],\n    \"type\": \"QueryResultSetFilter\"\n  }\n}";
            ObjectMetadataAssertion.assertMetadata(expectedMetadata, actualTransformedType);
        }

        private TriggerModel createMockTriggerModel(DWType inputType) {
            TriggerModel trigger = (TriggerModel)Mockito.mock(TriggerModel.class);
            TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            TypeModel outputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            ObjectType outputType = (ObjectType)Mockito.mock(ObjectType.class);
            NavigableMap versions = (NavigableMap)Mockito.mock(NavigableMap.class);
            Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
            Mockito.when((Object)outputTypeModel.getDataType()).thenReturn((Object)outputType);
            Mockito.when((Object)trigger.getInputType()).thenReturn((Object)inputTypeModel);
            Mockito.when((Object)trigger.getOutputType()).thenReturn((Object)outputTypeModel);
            Mockito.when((Object)trigger.getErrorOutputType()).thenReturn((Object)((TypeModel)Mockito.mock(TypeModel.class)));
            Mockito.when((Object)trigger.getName()).thenReturn((Object)"query");
            Mockito.when((Object)trigger.getDisplayName()).thenReturn((Object)"Query Builder");
            Mockito.when((Object)trigger.getVersions()).thenReturn((Object)versions);
            Mockito.when((Object)trigger.isBase()).thenReturn((Object)true);
            Mockito.when((Object)trigger.getInputResolvedProviders()).thenReturn(Map.of());
            Mockito.when((Object)trigger.getOutputResolvedProviders()).thenReturn(Map.of());
            Mockito.when((Object)trigger.order()).thenReturn((Object)"ASC");
            return trigger;
        }
    }

    @Nested
    @DisplayName(value="Operation Model Adaptation")
    public class OperationModelAdaptation {
        @Test
        @DisplayName(value="GIVEN OperationModel with @QueryBuilder annotation WHEN adapted THEN preserves QueryBuilder metadata")
        public void testAdaptOperationWithFullQueryBuilder() {
            String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: { key: String, defaultSelection?: String })\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\ntype QueryFieldNoOrder = {|\n    kind: \"NOT_SORTED\"\n|}\n\ntype QueryOrder = \"ASC\" | \"DESC\"\n\ntype QueryFieldOrder = {|\n    kind: \"SORTED\"\n|}\n\ntype QueryFieldOrderPair<F <: String> = {|\n   field: F,\n   order: QueryOrder\n|}\n\ntype QueryManyFieldsManySortingOrder<F <: String> = QueryFieldOrder & {|\n    fields: Array<QueryFieldOrderPair<F>>\n|}\n\ntype QueryBuilderOperation = @QueryBuilder() {\n    objectType: String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String,\n    orderBy: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() QueryFieldNoOrder | QueryManyFieldsManySortingOrder<String>\n}\n---\nQueryBuilderOperation\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            OperationModel originalOperation = this.createMockOperationModel(compiledType);
            OperationModel adaptedOperation = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            Assertions.assertNotNull((Object)adaptedOperation, (String)"Adapted operation should not be null");
            Assertions.assertTrue((boolean)FlowMetadataUtils.isQueryBuilder((DWType)adaptedOperation.getInputType().getDataType()), (String)"Adapted operation should maintain QueryBuilder annotation");
            Assertions.assertEquals((Object)"Query Builder", (Object)adaptedOperation.getDisplayName(), (String)"Display name should be preserved");
            String expectedMetadata = "{\n  \"projectedFields\": {\n    \"metadata\": [\n      \"flow.fieldSelector\",\n      \"valueProvider\"\n    ],\n    \"valueProvider\": {\n      \"name\": \"fieldsValueProvider\",\n      \"arguments\": { \"objectType\": \"/objectType\" }\n    },\n    \"type\": \"ProjectedFieldsType\"\n  },\n  \"filter\": {\n    \"metadata\": [\n      \"flow.resultSetFilter\"\n    ],\n    \"type\": \"QueryResultSetFilter\"\n  },\n  \"orderBy\": {\n    \"type\": \"QueryManyFieldsManySortingOrder\",\n    \"metadata\": [\n      \"flow.fieldOrder\"\n    ]\n  }\n}";
            ObjectMetadataAssertion.assertMetadata(expectedMetadata, adaptedOperation.getInputType().getDataType());
        }

        @Test
        @DisplayName(value="GIVEN OperationModel with minimal @QueryBuilder WHEN adapted THEN creates valid component structure")
        public void testAdaptOperationWithMinimalQueryBuilder() {
            String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\ntype MinimalQueryBuilder = @QueryBuilder() {\n    objectType: String,\n    projectedFields: @FieldSelector() Array<String>\n}\n---\nMinimalQueryBuilder\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            OperationModel originalOperation = this.createMockOperationModel(compiledType);
            OperationModel result = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            Assertions.assertNotNull((Object)result, (String)"Adapted operation should not be null");
            Assertions.assertTrue((boolean)FlowMetadataUtils.isQueryBuilder((DWType)result.getInputType().getDataType()), (String)"Should be detected as QueryBuilder");
        }

        @Test
        @DisplayName(value="GIVEN regular OperationModel without @QueryBuilder WHEN adapted THEN passes through unchanged")
        public void testAdaptRegularOperation() {
            String script = "%dw 2.8\n\ntype RegularOperation = {\n    entityType: String,\n    data: Object\n}\n---\nRegularOperation\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            OperationModel originalOperation = this.createMockOperationModel(compiledType);
            OperationModel result = QueryBuilderAdapter.adapt((OperationModel)originalOperation);
            Assertions.assertNotNull((Object)result, (String)"Result should not be null");
            Assertions.assertFalse((boolean)FlowMetadataUtils.isQueryBuilder((DWType)result.getInputType().getDataType()), (String)"Should not be detected as QueryBuilder");
            Assertions.assertEquals((Object)"Query Builder", (Object)result.getDisplayName(), (String)"Display name should be preserved even for non-QB operations");
        }

        @Test
        @DisplayName(value="GIVEN regular OperationModel with @QueryBuilder and three options for orderBy field WHEN adapted THEN throws error")
        public void testAdaptOperationWithOrderByUsingMoreThanTwoOptions() {
            String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"flow.queryBuilder\")\nannotation QueryBuilder(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"discriminator\")\nannotation Discriminator(value: { key: String, defaultSelection?: String })\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldOrder\")\nannotation FieldOrder(value: {} = {})\n\ntype QueryFieldNoOrder = {|\n    kind: \"NOT_SORTED\"\n|}\n\ntype QueryOrder = \"ASC\" | \"DESC\"\n\ntype QueryFieldOrder = {|\n    kind: \"SORTED\"\n|}\n\ntype QueryFieldOrderPair<F <: String> = {|\n   field: F,\n   order: QueryOrder\n|}\n\ntype QueryManyFieldsManySortingOrder<F <: String> = QueryFieldOrder & {|\n    fields: Array<QueryFieldOrderPair<F>>\n|}\n\ntype QueryBuilderOperation = @QueryBuilder() {\n    objectType: String,\n    projectedFields: @FieldSelector() Array<String>,\n    filter: @ResultSetFilter() String,\n    orderBy: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() QueryFieldNoOrder | QueryManyFieldsManySortingOrder<String> | QueryFieldOrder\n}\n---\nQueryBuilderOperation\n";
            DWType compiledType = QueryBuilderTestUtils.compileScript(script);
            OperationModel originalOperation = this.createMockOperationModel(compiledType);
            try {
                QueryBuilderAdapter.adapt((OperationModel)originalOperation);
                Assertions.fail((String)"Expected IllegalArgumentException");
            }
            catch (Exception e) {
                Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
                Assertions.assertEquals((Object)"Invalid orderBy field structure: expected UnionType with only 2 elements", (Object)e.getMessage());
            }
        }

        private OperationModel createMockOperationModel(DWType inputType) {
            OperationModel operation = (OperationModel)Mockito.mock(OperationModel.class);
            TypeModel inputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            TypeModel outputTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
            ObjectType outputType = (ObjectType)Mockito.mock(ObjectType.class);
            NavigableMap versions = (NavigableMap)Mockito.mock(NavigableMap.class);
            Mockito.when((Object)inputTypeModel.getDataType()).thenReturn((Object)inputType);
            Mockito.when((Object)outputTypeModel.getDataType()).thenReturn((Object)outputType);
            Mockito.when((Object)operation.getErrorOutputType()).thenReturn((Object)((TypeModel)Mockito.mock(TypeModel.class)));
            Mockito.when((Object)operation.getInputType()).thenReturn((Object)inputTypeModel);
            Mockito.when((Object)operation.getOutputType()).thenReturn((Object)outputTypeModel);
            Mockito.when((Object)operation.getName()).thenReturn((Object)"query");
            Mockito.when((Object)operation.getDisplayName()).thenReturn((Object)"Query Builder");
            Mockito.when((Object)operation.getVersions()).thenReturn((Object)versions);
            Mockito.when((Object)operation.isBase()).thenReturn((Object)true);
            return operation;
        }
    }
}

