/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ComponentType;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public class ComponentPath
implements Iterable<ComponentPath> {
    private final String name;
    private final ComponentType componentType;
    private @Nullable ComponentPath next;

    public ComponentPath(@Nullable String name, ComponentType componentType) {
        this.name = name;
        this.componentType = componentType;
    }

    public static ComponentPath fromComponents(List<Component> components) {
        ComponentPath root = null;
        ComponentPath current = null;
        for (Component component : components) {
            ComponentPath componentPath = new ComponentPath(component.getName(), component.getComponentType());
            if (root == null) {
                current = root = componentPath;
                continue;
            }
            current.next = componentPath;
            current = componentPath;
        }
        return root;
    }

    public ComponentPath getTail() {
        ComponentPath tail = this;
        while (tail.next != null) {
            tail = tail.next;
        }
        return tail;
    }

    public ComponentPath add(ComponentPath path) {
        ComponentPath head = this.copy();
        head.getTail().next = path;
        return head;
    }

    public ComponentPath removeTail() {
        ComponentPath head;
        ComponentPath current = head = this.copy();
        while (current.next != null) {
            if (current.next.next == null) {
                current.next = null;
                return head;
            }
            current = current.next;
        }
        return head;
    }

    public static ComponentPath fromTopDown(String path) {
        String[] parts = path.split("/");
        ComponentPath root = null;
        ComponentPath current = null;
        for (String part : parts) {
            String[] nameType = part.split("#");
            String name = nameType.length > 1 ? nameType[0] : null;
            String type = nameType.length > 1 ? nameType[1] : nameType[0];
            ComponentPath component = new ComponentPath(name, ComponentType.valueOf(type));
            if (root == null) {
                current = root = component;
                continue;
            }
            current.setNext(component);
            current = component;
        }
        if (root == null) {
            throw new IllegalStateException("Unable to parse component path: " + path);
        }
        return root;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ComponentPath current = this;
        while (current != null) {
            sb.append(current.getName() != null ? current.getName() : "").append("#").append((Object)current.getComponentType());
            current = current.next;
            if (current == null) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    @Override
    public Iterator<ComponentPath> iterator() {
        return new Iterator<ComponentPath>(){
            private @Nullable ComponentPath next;
            {
                this.next = ComponentPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ComponentPath next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                ComponentPath prev = this.next;
                this.next = this.next.next;
                return prev;
            }
        };
    }

    public ComponentPath to(ComponentPath to) {
        ComponentPath head;
        ComponentPath current = head = this.copy();
        while (current.next != null) {
            current = current.next;
            if (!current.equals(to)) continue;
            current.next = null;
            return head;
        }
        return head;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentPath that = (ComponentPath)o;
        return (Objects.equals(this.name, that.name) || StringUtils.isBlank((CharSequence)this.name) && StringUtils.isBlank((CharSequence)that.name)) && this.componentType == that.componentType && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.componentType, this.next});
    }

    private ComponentPath copy() {
        ComponentPath head = new ComponentPath(this.name, this.componentType);
        if (this.next != null) {
            head.next = this.next.copy();
        }
        return head;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ComponentType getComponentType() {
        return this.componentType;
    }

    @Generated
    public @Nullable ComponentPath getNext() {
        return this.next;
    }

    @Generated
    public void setNext(@Nullable ComponentPath next) {
        this.next = next;
    }

    public static class ComponentPathTypeAdapter
    extends TypeAdapter<ComponentPath> {
        public void write(JsonWriter out, ComponentPath value) throws IOException {
            out.value(value.toString());
        }

        public ComponentPath read(JsonReader in) throws IOException {
            return ComponentPath.fromTopDown(in.nextString());
        }
    }
}

