/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.model;

import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.ConnectorModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class FlowBaseConnectorModel<C extends BaseConnectionProviderModel, O extends BaseExecutableComponentModel<?>, T extends BaseExecutableComponentModel<?>>
extends ConnectorModel
implements Serializable {
    protected final List<C> connections;
    protected final List<O> operations;
    protected final List<T> triggers;
    protected final @Nullable TestConnectionModel testConnection;

    public FlowBaseConnectorModel(String name, String displayName, List<C> connections, List<O> operations, List<T> triggers, @Nullable TestConnectionModel testConnection, @Nullable String modelReference) {
        super(modelReference, name, displayName);
        this.connections = connections;
        this.operations = operations;
        this.triggers = triggers;
        this.testConnection = testConnection;
    }

    public @Nullable String getDwRef() {
        return this.modelReference;
    }

    public List<C> getConnections() {
        return this.connections;
    }

    public List<O> getOperations() {
        return this.operations;
    }

    public List<T> getTriggers() {
        return this.triggers;
    }

    public O getOperation(String operationName) {
        return (O)this.getOperations().stream().filter(operation -> operation.getName().equals(operationName)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find operation '" + operationName + "'"));
    }

    public T getTrigger(String triggerName) {
        return (T)this.getTriggers().stream().filter(trigger -> trigger.getName().equals(triggerName)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find trigger '" + triggerName + "'"));
    }

    public @Nullable TestConnectionModel getTestConnection() {
        return this.testConnection;
    }

    public static class Builder
    extends AbstractBuilder<BaseConnectionProviderModel, BaseExecutableComponentModel<?>, BaseExecutableComponentModel<?>, Builder, FlowBaseConnectorModel<BaseConnectionProviderModel, BaseExecutableComponentModel<?>, BaseExecutableComponentModel<?>>> {
        protected FlowBaseConnectorModel<BaseConnectionProviderModel, BaseExecutableComponentModel<?>, BaseExecutableComponentModel<?>> createInstance() {
            return new FlowBaseConnectorModel(Objects.requireNonNull(this.name, "name"), Objects.requireNonNull(this.displayName, "displayName"), Objects.requireNonNull(this.connections, "connections"), Objects.requireNonNullElse(this.operations, List.of()), Objects.requireNonNullElse(this.triggers, List.of()), this.testConnection, Objects.requireNonNull(this.modelReference, "modelReference"));
        }

        protected Builder getThis() {
            return this;
        }
    }

    public static abstract class AbstractBuilder<C extends BaseConnectionProviderModel, O extends BaseExecutableComponentModel<?>, T extends BaseExecutableComponentModel<?>, B extends AbstractBuilder<C, O, T, B, M>, M extends FlowBaseConnectorModel<C, O, T>>
    extends ConnectorModel.Builder<M, B> {
        protected @Nullable List<C> connections;
        protected @Nullable List<O> operations;
        protected @Nullable List<T> triggers;
        protected @Nullable TestConnectionModel testConnection;

        public B withConnections(List<C> connections) {
            this.connections = connections;
            return (B)((Object)((AbstractBuilder)this.getThis()));
        }

        public B withOperations(List<O> operations) {
            this.operations = operations;
            return (B)((Object)((AbstractBuilder)this.getThis()));
        }

        public B withTriggers(List<T> triggers) {
            this.triggers = triggers;
            return (B)((Object)((AbstractBuilder)this.getThis()));
        }

        public B withTestConnection(@Nullable TestConnectionModel testConnection) {
            this.testConnection = testConnection;
            return (B)((Object)((AbstractBuilder)this.getThis()));
        }

        private static boolean isEmptyOrNull(@Nullable List<?> list) {
            return list == null || list.isEmpty();
        }

        public M build() throws IllegalStateException {
            return (M)((FlowBaseConnectorModel)super.build());
        }
    }
}

