/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.flow.api.validator.rules.ValidatorUtils;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Message;
import com.mulesoft.connectivity.validation.rules.Rule;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class FlowMessageRule
extends Rule<Message> {
    public FlowMessageRule() {
        super(Message.class);
    }

    protected void validate(Validatable<Message> validatable, ValidationContext ctx) {
        Message m = (Message)validatable.getElement();
        DWType type = TypeUtils.resolveReferenceType((DWType)m.getType());
        if (validatable.hasAnyContext(new ValidatableType[]{ValidatableType.OPERATION, ValidatableType.TRIGGER}) && !m.isInput() && !this.isSupportedForOutput(type)) {
            ctx.addError(type.getLocation(), "Unsupported type at output: " + String.valueOf(type), "InvalidFlowType");
        }
    }

    private boolean isSupportedForOutput(DWType type) {
        if (ValidatorUtils.isSupportedSimpleType(type) || type instanceof NullType) {
            return true;
        }
        return type instanceof ArrayType || type instanceof UnionType || type instanceof ObjectType || type instanceof IntersectionType;
    }
}

