/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.BindingsModel;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.InParameterComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OperationComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OperationKind;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OutParameterComponent;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;

public class ProviderLoader {
    private final ComponentRegistry componentRegistry;
    private final TypeFactory typeFactory;

    public ProviderLoader(ComponentRegistry componentRegistry, TypeFactory typeFactory) {
        this.componentRegistry = componentRegistry;
        this.typeFactory = typeFactory;
    }

    public void load(ValueProviderModel valueProviderModel) {
        this.load((ProviderModel)valueProviderModel, OperationKind.VALUE_PROVIDER, valueProviderModel.isPaginated(), valueProviderModel.getProvidedValueType());
    }

    public void load(MetadataProviderModel metadataProviderModel) {
        this.load((ProviderModel)metadataProviderModel, OperationKind.TYPE_PROVIDER, false, null);
    }

    private void load(ProviderModel providerModel, OperationKind kind, boolean isPaginated, @Nullable TypeModel outputType) {
        BindingsModel bindings = BindingsModel.builder().paginated(isPaginated).build();
        String actualBindings = bindings.toString();
        if (bindings.isEmpty() && OperationKind.TYPE_PROVIDER.equals((Object)kind) || OperationKind.EVENT_SOURCE.equals((Object)kind)) {
            actualBindings = "";
        }
        Component operationComponent = ((OperationComponent.OperationComponentBuilder)((OperationComponent.OperationComponentBuilder)((Component.ComponentBuilder)((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name(providerModel.getName())).kind(kind.getValue())).outer(this.componentRegistry.getServiceComponent().getId())).binding(actualBindings)).build();
        operationComponent = (OperationComponent)this.componentRegistry.registerComponent(operationComponent);
        this.loadInputType(providerModel.getInputType(), (OperationComponent)operationComponent);
        if (outputType != null) {
            this.loadOutputType(outputType, (OperationComponent)operationComponent);
        }
    }

    private void loadInputType(TypeModel inputType, OperationComponent outer) {
        DWType dataType = inputType.getDataType();
        for (KeyValuePairType fieldType : com.mulesoft.connectivity.flow.internal.util.TypeUtils.properties(dataType)) {
            InParameterComponent inParameterComponent = (InParameterComponent)this.componentRegistry.registerComponent(((InParameterComponent.InParameterComponentBuilder)((InParameterComponent.InParameterComponentBuilder)((Component.ComponentBuilder)((InParameterComponent.InParameterComponentBuilder)((InParameterComponent.InParameterComponentBuilder)((InParameterComponent.InParameterComponentBuilder)InParameterComponent.builder().name(fieldType.getKeyName())).outer(outer.getId())).required(!fieldType.isOptionalKey())).nullable(com.mulesoft.connectivity.flow.internal.util.TypeUtils.isFieldTypeNullable(fieldType))).description(MetadataUtils.getDescription((DWType)fieldType.getValue()).orElse(""))).label(MetadataUtils.getLabel((DWType)fieldType).orElse(null))).build());
            Component parameterType = this.typeFactory.make(fieldType.getValue(), inParameterComponent);
            parameterType = this.componentRegistry.registerComponent(parameterType);
            inParameterComponent.setParameterType(parameterType.getId());
            this.componentRegistry.updateComponent(inParameterComponent);
        }
    }

    private void loadOutputType(TypeModel outputType, OperationComponent outer) {
        DWType dataType = outputType.getDataType();
        if (dataType instanceof ReferenceType) {
            dataType = TypeUtils.resolveReferenceType((DWType)((ReferenceType)dataType));
        }
        OutParameterComponent outParameterComponent = (OutParameterComponent)this.componentRegistry.registerComponent(((OutParameterComponent.OutParameterComponentBuilder)((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name(dataType.getClass().getSimpleName())).outer(outer.getId())).build());
        Component parameterType = this.typeFactory.make(dataType, outParameterComponent);
        parameterType = this.componentRegistry.registerComponent(parameterType);
        outParameterComponent.setParameterType(parameterType.getId());
        this.componentRegistry.updateComponent(outParameterComponent);
    }
}

