/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.PathTracker;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ProviderCapableTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import java.util.List;
import java.util.stream.Stream;
import org.mule.weave.v2.api.tooling.ts.DWType;

class DefaultTypeFactory
implements TypeFactory {
    private final List<TypeHandler> simpleHandlers;
    private final List<ProviderCapableTypeHandler> providerCapableTypeHandlers;
    private final ComponentRegistry componentRegistry;
    private final PathTracker pathTracker;

    public DefaultTypeFactory(ComponentRegistry componentRegistry, List<TypeHandler> simpleHandlers, List<ProviderCapableTypeHandler> providerCapableTypeHandlers) {
        this.componentRegistry = componentRegistry;
        this.simpleHandlers = simpleHandlers;
        this.providerCapableTypeHandlers = providerCapableTypeHandlers;
        this.pathTracker = new PathTracker();
    }

    @Override
    public Component make(DWType type, String typeName, Component outer) {
        TypeHandler handler = Stream.concat(this.simpleHandlers.stream(), this.providerCapableTypeHandlers.stream()).filter(x -> x.handles(type)).findFirst().orElseThrow(() -> new RuntimeException("No handler found for type " + type.getClass().getSimpleName() + "(" + typeName + ")"));
        return handler.make(type, typeName, outer, this);
    }

    @Override
    public Component make(DWType type, Component outer) {
        return this.make(type, "", outer);
    }

    @Override
    public Component makeWithProvider(ExecutableComponentModel<?> componentModel, DWType type, String typeName, Component outer) {
        ProviderCapableTypeHandler handler = this.providerCapableTypeHandlers.stream().filter(x -> x.handles(type)).findFirst().orElseThrow(() -> new RuntimeException("No handler found for type " + type.getClass().getSimpleName() + "(" + typeName + ")"));
        return handler.makeWithProvider(componentModel, type, typeName, outer, this);
    }

    @Override
    public Component makeWithProvider(ExecutableComponentModel<?> componentModel, DWType type, Component outer) {
        return this.makeWithProvider(componentModel, type, "", outer);
    }

    @Override
    public List<ProviderCapableTypeHandler> getProviderCapableTypeHandlers() {
        return this.providerCapableTypeHandlers;
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public PathTracker getPathTracker() {
        return this.pathTracker;
    }
}

