/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.ComponentPath;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class Patch {
    private final Map<String, ServicePatch> services = new HashMap<String, ServicePatch>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Patch fromResource(String patchResourcePath) {
        try (InputStream inputStream = Patch.class.getClassLoader().getResourceAsStream(patchResourcePath);){
            if (inputStream == null) throw new RuntimeException("Patch file not found: " + patchResourcePath);
            Gson gson = new GsonBuilder().registerTypeAdapter(ComponentPath.class, (Object)new ComponentPath.ComponentPathTypeAdapter()).create();
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                Patch patch = (Patch)gson.fromJson((Reader)reader, Patch.class);
                return patch;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ServicePatch getServicePatch(String serviceName) {
        return this.services.computeIfAbsent(serviceName, k -> new ServicePatch());
    }

    public boolean shouldExplodeReferenceType(String shortName, Component outer, TypeFactory typeFactory) {
        ComponentRegistry componentRegistry = typeFactory.getComponentRegistry();
        String serviceName = componentRegistry.getServiceComponent().getName();
        if (!this.services.containsKey(serviceName)) {
            return false;
        }
        ComponentPath path = componentRegistry.getPath(outer);
        Map<String, Set<ComponentPath>> dereferences = this.services.get((Object)serviceName).dereferences;
        return dereferences.containsKey(shortName) && dereferences.get(shortName).contains(path);
    }

    public boolean shouldApplySoftIntersectionResolution(Component outer, TypeFactory typeFactory) {
        ComponentRegistry componentRegistry = typeFactory.getComponentRegistry();
        String serviceName = componentRegistry.getServiceComponent().getName();
        if (!this.services.containsKey(serviceName)) {
            return false;
        }
        ComponentPath path = componentRegistry.getPath(outer);
        return this.services.get((Object)serviceName).softIntersectionResolution.contains(path);
    }

    public boolean shouldApplyOutParameterSoftIntersectionResolution(Component outer, TypeFactory typeFactory) {
        ComponentRegistry componentRegistry = typeFactory.getComponentRegistry();
        String serviceName = componentRegistry.getServiceComponent().getName();
        if (!this.services.containsKey(serviceName)) {
            return false;
        }
        ComponentPath path = componentRegistry.getPath(outer);
        return this.services.get((Object)serviceName).outParameterIntersectionResolution.contains(path);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Patch)) {
            return false;
        }
        Patch other = (Patch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ServicePatch> this$services = this.getServices();
        Map<String, ServicePatch> other$services = other.getServices();
        return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Patch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ServicePatch> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Patch(services=" + String.valueOf(this.getServices()) + ")";
    }

    @Generated
    public Map<String, ServicePatch> getServices() {
        return this.services;
    }

    public record ServicePatch(Map<String, Set<ComponentPath>> dereferences, Set<ComponentPath> softIntersectionResolution, Set<ComponentPath> outParameterIntersectionResolution) {
        public ServicePatch() {
            this(new HashMap<String, Set<ComponentPath>>(), new HashSet<ComponentPath>(), new HashSet<ComponentPath>());
        }

        public boolean isEmpty() {
            return this.dereferences.isEmpty() && this.softIntersectionResolution.isEmpty() && this.outParameterIntersectionResolution.isEmpty();
        }
    }
}

