/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.util;

import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import java.util.Arrays;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.ts.WeaveType;

public class TypeUtils {
    private TypeUtils() {
    }

    public static boolean isFieldTypeNullable(KeyValuePairType fieldType) {
        if (fieldType == null) {
            return false;
        }
        DWType fieldTypeValue = fieldType.getValue();
        if (!(fieldTypeValue instanceof UnionType)) {
            return false;
        }
        UnionType unionType = (UnionType)fieldTypeValue;
        return Arrays.stream(unionType.unionOf()).anyMatch(e -> e instanceof NullType);
    }

    public static KeyValuePairType[] properties(DWType inputType) {
        IntersectionType intersectionType;
        WeaveType weaveType;
        if (inputType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)inputType;
            return objectType.getProperties();
        }
        if (inputType instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)inputType;
            return TypeUtils.properties(referenceType.resolveType());
        }
        if (inputType instanceof IntersectionType && (weaveType = WeaveTypeSimplifier.resolveIntersection((WeaveType)((WeaveType)(intersectionType = (IntersectionType)inputType)))) instanceof ObjectType) {
            ObjectType objectType = (ObjectType)weaveType;
            return objectType.getProperties();
        }
        return new KeyValuePairType[0];
    }
}

