/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.ValidationMessageWithToString;
import com.mulesoft.connectivity.flow.api.validator.rules.FieldOrderRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowMetadataProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowOperationsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowValueProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.NoDynamicNamesRule;
import com.mulesoft.connectivity.flow.api.validator.rules.QueryBuilderUnionRule;
import com.mulesoft.connectivity.flow.api.validator.rules.ResultSetsInTriggersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.UnionRule;
import com.mulesoft.connectivity.flow.api.validator.rules.UnsupportedTypeRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.rules.ArrayRule;
import com.mulesoft.connectivity.validation.rules.ExecutorRule;
import com.mulesoft.connectivity.validation.rules.IntersectionRule;
import com.mulesoft.connectivity.validation.rules.MessageRule;
import com.mulesoft.connectivity.validation.rules.ObjectRule;
import com.mulesoft.connectivity.validation.rules.OperationRule;
import com.mulesoft.connectivity.validation.rules.ProviderReferenceRule;
import com.mulesoft.connectivity.validation.rules.ReferenceRule;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mule.weave.v2.api.tooling.message.ValidationMessage;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class OperationValidatorTest
extends AbstractValidatorTest {
    OperationValidatorTest() {
    }

    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowValueProvidersRule.class, FlowMetadataProvidersRule.class, FlowOperationsRule.class, OperationRule.class, ExecutorRule.class, MessageRule.class, ReferenceRule.class, ObjectRule.class, UnionRule.class, IntersectionRule.class, QueryBuilderUnionRule.class, ResultSetsInTriggersRule.class, FieldOrderRule.class, NoDynamicNamesRule.class, ArrayRule.class, UnsupportedTypeRule.class, ProviderReferenceRule.class});
    }

    private static String buildConnectorModule(String operation) {
        return String.format("%%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::flow::Annotations\nimport * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\n%s\n@FlowConnectorElement\nvar connector = {\n   operations: {\n      testOperation: testOperation   }\n}", operation);
    }

    @Test
    void acceptsConnectorWithNoOperations() {
        this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\ntype OperationInputType = {myProperty: String}\n\n@FlowConnectorElement\nvar connector = {\n}");
    }

    @Test
    void rejectsOperationWithMissingValue() {
        String operation = "@OperationElement() var testOperation = ";
        String script = OperationValidatorTest.buildConnectorModule(operation);
        CollectedMessages collectedMessages = this.assertCompileFailure(script);
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)2));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Missing Variable Expression i.e var a = 1", "MissingExpression", "\n8| @OperationElement() var testOperation = \n...\n@FlowConnectorElement\n");
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(1), "Invalid type for operation 'testOperation'. Expected: Operation Actual: Nothing", "connector", "\n12|       testOperation: testOperation   }\n                         ^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInvalidOperationsPropertyType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n   operations: []\n}");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for property 'operations'. Expected: Object; Actual: Array<Nothing>", "connector", "\n8|    operations: []\n      ^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsOperationWithNoExecutorWhenUsingExplicitType() {
        String operation = "@OperationElement()\nvar testOperation : Operation<{}, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Missing required property: `executor` required by `Operation<Object, Ob..., dw::Core::Object>>`.", "MissingRequiredProperty", "\n 9| var testOperation : Operation<{}, {}, ResultFailure<{}, Error>, Connection> = {\n  |  ...\n12| }\n");
    }

    @Test
    void rejectsOperationWithNoExecutorWhenUsingImplicitType() {
        String operation = "@OperationElement()\nvar testOperation = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Missing executor property in operation definition", "connector", "\n17|       testOperation: testOperation   }\n                         ^^^^^^^^^^^^^");
    }

    @Test
    void rejectsOperationWithInvalidExecutorTypeWhenUsingImplicitType() {
        String operation = "@OperationElement()\nvar testOperation = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: [],\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for property 'executor'. Expected: Function; Actual: Array<Nothing>", "connector", "\n12|     executor: [],\n                  ^^");
    }

    @Test
    void rejectsOperationWithInvalidExecutorParametersWhenUsingImplicitType() {
        String operation = "@OperationElement()\nvar testOperation = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter: Object, connection: Object, invalidParameter: Any): ResultSuccess<{}> | ResultFailure<{}, Error> -> success({})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for property 'executor'. Expected an executor function but got (parameter: Object, connection: Object, invalidParameter: Any) -> ResultSuccess<Object> | ResultFailure<Object, Error<dw::Core::String, dw::Core::String>>", "connector", "\n12|     executor: (parameter: Object, connection: Object, invalidParameter: Any): ResultSuccess<{}> | ResultFailure<{}, Error> -> success({})\n                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsOperationWithInvalidSuccessExecutorTypeWhenUsingImplicitType() {
        String operation = "@OperationElement()\nvar testOperation = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter: Object, connection) -> success( {})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Executor function return type must be of Result type", "connector", "\n12|     executor: (parameter: Object, connection) -> success( {})\n                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsOperationWithInvalidExecutorResultTypeWhenUsingImplicitType() {
        String operation = "@OperationElement()\nvar testOperation = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter: Object, connection: Object): ResultSuccess<{}> | {success: false} | {} -> success({})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Executor function return type must be of Result type", "connector", "\n12|     executor: (parameter: Object, connection: Object): ResultSuccess<{}> | {success: false} | {} -> success({})\n                                                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsOperationWithInvalidExecutorSuccessResultTypeWhenUsingImplicitType() {
        String operation = "@OperationElement()\nvar testOperation = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter: Object, connection: Object): {success: false} | {} -> success({})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Executor function return type must be of Result type", "connector", "\n12|     executor: (parameter: Object, connection: Object): {success: false} | {} -> success({})\n                                                           ^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInvalidOperationPropertyType() {
        String operation = "@OperationElement()\nvar testOperation = []\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for operation 'testOperation'. Expected: Operation Actual: Array<Nothing>", "connector", "\n14|       testOperation: testOperation   }\n                         ^^^^^^^^^^^^^");
    }

    @Test
    void acceptsOperationInputWithReferenceType() {
        String operation = "type OperationInputType = {myProperty: String}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {})\n}\n";
        this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
    }

    @Test
    void acceptsOperationInputWithReferenceTypeProperty() {
        String operation = "type MyInputType = {myProperty: String}\n\n@OperationElement()\nvar testOperation : Operation<{property: MyInputType}, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {})\n}\n";
        this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
    }

    @Test
    void rejectsInputObjectPropertyWithRecursiveObjectType() {
        String operation = "type MyInputType = {myProperty: MyInputType}\n\n@OperationElement()\nvar testOperation : Operation<{property: MyInputType}, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Recursive reference to type MyInputType at input.property.myProperty", "InvalidFlowType", "\n8| type MyInputType = {myProperty: MyInputType}\n                                   ^^^^^^^^^^^");
    }

    @Test
    void rejectsInputObjectPropertyWithRecursiveArrayType() {
        String operation = "type MyObject = {\n    value: MyArray\n}\ntype MyArray = Array<MyObject>\n\n@OperationElement()\nvar testOperation : Operation<{property: MyArray}, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Recursive reference to type MyObject at input.property[].value", "InvalidFlowType", "\n11| type MyArray = Array<MyObject>\n                         ^^^^^^^^");
    }

    @MethodSource(value={"getUnsupportedInputTypes"})
    @ParameterizedTest
    void rejectsUnsupportedInputTypes(AbstractValidatorTest.UnsupportedTypeTestParam param) {
        String operation = "@OperationElement()\nvar testOperation : Operation<" + param.type + ", {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), param.getExpectedMessage(param.reasons.get(0)), "InvalidFlowType", "\n81| type Executor<InputType <: Object, ResultType, ResultErrorType <: ResultFailure, ConnectionType <: Connection> = (InputType, ConnectionType) -> Result<ResultType, ResultErrorType>\n                                                                                                                      ^^^^^^^^^");
    }

    @ParameterizedTest
    @MethodSource(value={"getValidObjectTypes"})
    void acceptsInputObjectPropertyWithValidType(String type) {
        String operation = "@OperationElement()\nvar testOperation : Operation<" + type + ", {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {})\n}\n";
        this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
    }

    @MethodSource(value={"getInvalidObjectTypes"})
    @ParameterizedTest
    void rejectsInputObjectPropertyWithInvalidType(AbstractValidatorTest.UnsupportedTypeTestParam param) {
        List<ValidationMessageWithToString> errors = ValidationMessageWithToString.errorsFrom(this.doCompileFailureTest(param.type));
        MatcherAssert.assertThat(errors, (Matcher)Matchers.hasSize((int)param.reasons.size()));
        List<Matcher> matchers = param.reasons.stream().map(reason -> OperationValidatorTest.validationMessageMatcher((Matcher<String>)Matchers.equalToCompressingWhiteSpace((String)param.getExpectedMessage((AbstractValidatorTest.Reason)reason)), "InvalidFlowType", (Matcher<String>)Matchers.containsString((String)String.format("9| var testOperation : Operation<%s, {}, ResultFailure<{}, Error>, Connection> = {", param.type)))).toList();
        if (matchers.size() == 1) {
            MatcherAssert.assertThat((Object)((Object)errors.get(0)), (Matcher)matchers.get(0));
        } else {
            MatcherAssert.assertThat(errors, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{matchers}));
        }
    }

    @Test
    void rejectsObjectPropertyWithDynamicName() {
        CollectedMessages collectedMessages = this.doCompileFailureTest("{ _ : String}");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Generic Object property name definition is not supported: '_: String' at input", "InvalidFlowType", "\n9| var testOperation : Operation<{ _ : String}, {}, ResultFailure<{}, Error>, Connection> = {\n                                   ^^^^^^^^^^");
    }

    private CollectedMessages doCompileFailureTest(String typeModel) {
        return this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(String.format("@OperationElement()\nvar testOperation : Operation<%s, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success({})\n}\n", typeModel)));
    }

    @MethodSource(value={"getUnsupportedOutputTypes"})
    @ParameterizedTest
    void rejectsUnsupportedOutputTypes(AbstractValidatorTest.UnsupportedTypeTestParam param) {
        String operation = "import * from dw::core::Periods\n@OperationElement()\nvar testOperation : Operation<{}, " + param.type + ", ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( " + String.valueOf(param.outputValue) + ")\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), param.getExpectedMessage(param.reasons.get(0)), "InvalidFlowType", "\n259|    value: ResultType\n               ^^^^^^^^^^");
    }

    @MethodSource(value={"getUnsupportedComplexOutputTypes"})
    @ParameterizedTest
    void rejectsUnsupportedComplexOutputTypes(AbstractValidatorTest.UnsupportedTypeTestParam param) {
        String operation = "@OperationElement()\nvar testOperation : Operation<{}, " + param.type + ", ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( " + String.valueOf(param.outputValue) + ")\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), (Matcher<? super String>)Matchers.equalTo((Object)param.getExpectedMessage(param.reasons.get(0))), "InvalidFlowType", (Matcher<? super String>)Matchers.anything());
    }

    @Test
    void collapsesErrorMessages() {
        String operation = "type InputType = {\n    assigneeType: Array<{\n        projectKey: {\n            fields: {\n                description: String,\n                key: String,\n                name: {\n                   fields: {\n                      description: String,\n                      key: String,\n                      name: Any,\n                   },\n                },\n            },\n        },\n    }>,\n}\n@OperationElement()\nvar testOperation : Operation<InputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success({})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Unsupported type at input.assigneeType[].projectKey.fields.name.fields.name: Any", "InvalidFlowType", "\n18|                       name: Any,\n                                ^^^");
    }

    @ParameterizedTest
    @MethodSource(value={"getValidOutputTypes"})
    void acceptsValidOutputTypes(String type, String value) {
        String operation = "@OperationElement()\nvar testOperation : Operation<{}, " + type + ", ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success(" + value + ")\n}\n";
        this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
    }

    @Test
    void acceptsOutputWithReferenceType() {
        String operation = "type OperationOutputType = {myProperty: String}\n\n@OperationElement()\nvar testOperation : Operation<{}, OperationOutputType, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
    }

    @Test
    void acceptsConnectorWithValidMetaDataPropertyInputRefTest() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\ntype Ticket = {\n id: Number,\n title: String,\n objectType: String,\n extraFields: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) Object\n}\nvar createRecordOperation: Operation< Ticket, {}, ResultFailure<{}, Error>, HttpConnection> = { \nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({}) \n} \n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    }\n}\n");
    }

    @Test
    void rejectsConnectorWithInvalidMetaDataPropertyInputRefTest() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider1: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\ntype Ticket = {\n id: Number,\n title: String,\n objectType?: String,\n extraFields: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) Object\n}\nvar createRecordOperation: Operation< Ticket, {}, ResultFailure<{}, Error>, HttpConnection> = {\nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({})\n} \n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProvider1: metadataProvider1\n    }\n}\n");
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Cannot find metadata provider 'metadataProvider'.", "connector", "\n47|  extraFields: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) Object\n                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInvalidMetaDataPropertyInputTest() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider1: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\nvar createRecordOperation: Operation<@MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) {objectType?: String}, {}, ResultFailure<{}, Error>, HttpConnection> = {\nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({})\n}\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProvider1: metadataProvider1\n    }\n}\n");
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Cannot find metadata provider 'metadataProvider'.", "connector", "\n81| type Executor<InputType <: Object, ResultType, ResultErrorType <: ResultFailure, ConnectionType <: Connection> = (InputType, ConnectionType) -> Result<ResultType, ResultErrorType>\n                                                                                                                      ^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithNoMetaDataPropertyTest() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider1: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\nvar createRecordOperation: Operation<@MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) {objectType?: String}, {}, ResultFailure<{}, Error>, HttpConnection> = { \nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({}) \n} \n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           }\n}\n");
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Cannot find metadata provider 'metadataProvider'.", "connector", "\n81| type Executor<InputType <: Object, ResultType, ResultErrorType <: ResultFailure, ConnectionType <: Connection> = (InputType, ConnectionType) -> Result<ResultType, ResultErrorType>\n                                                                                                                      ^^^^^^^^^");
    }

    @Test
    void acceptsConnectorWithValidMetaDataPropertyInputTest() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\ntype Input = {\n  objectType : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\nvar createRecordOperation: Operation< @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) Input, {}, ResultFailure<{}, Error>, HttpConnection> = { \nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({}) \n} \n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    }\n}\n");
    }

    @Test
    void rejectsConnectorWithInvalidMetaDataPropertyOutputTest() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider1: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\nvar createRecordOperation: Operation<{objectType?: String}, @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) Object, ResultFailure<{}, Error>, HttpConnection> = { \nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({}) \n} \n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProvider1: metadataProvider1\n    }\n}\n");
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Cannot find metadata provider 'metadataProvider'.", "connector", "\n259|    value: ResultType\n               ^^^^^^^^^^");
    }

    @Test
    void acceptsConnectorWithValidMetaDataPropertyOutputTest() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\nvar createRecordOperation: Operation<{objectType?: String}, @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) Object, ResultFailure<{}, Error>, HttpConnection> = {\nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({})\n}\n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    }\n}\n");
    }

    @Test
    void rejectsConnectorWithInvalidMetaDataPropertyOutputRefTest() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider1: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\ntype Ticket = {\n id?: Number,\n title?: String,\n extraFields?: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) Object\n}\nvar createRecordOperation: Operation<{objectType?: String}, Ticket, ResultFailure<{}, Error>, HttpConnection> = { \nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({ }) \n} \n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProvider1: metadataProvider1\n    }\n}\n");
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Cannot find metadata provider 'metadataProvider'.", "connector", "\n46|  extraFields?: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) Object\n                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void acceptsConnectorWithValidMetaDataPropertyOutputRefTest() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\ntype OrderDynamic = {\n  orderId : String,\n  products : Array<Product>\n}\ntype Product = {\n  productId : String\n}\nvar extendNestedFields : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Order\", OrderDynamic)\n      withField createField(\"products\",\n          createArrayTypeValueDefinition(\n                      createExtendedObjectTypeValueDefinition(\"Product\", Product) withField  createField(\"description\", createStringTypeValueDefinition()))\n      )\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n      withField\n        createField(\"orderId\",createStringTypeValueDefinition(), true)\n      withField\n        createField(\"description\",createStringTypeValueDefinition(), false)\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Order\")\n      success(orderType)\n    else if (params.objectType == \"Account\")\n      success(accountType)\n    else if (params.objectType == \"OrderExtended\")\n      success(extendNestedFields)\n    else\n      failure({errorMessage: \"error\"})\ntype Ticket = {\n id?: Number,\n title?: String,\n extraFields?: @Description(value = \"The email address of the customer\") @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\" } }) Object\n}\ntype Input = {\n objectType: String\n}\nvar createRecordOperation: Operation< Input, Ticket,  ResultFailure<{}, Error>, HttpConnection> = { \nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({}) \n} \n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    }\n}\n");
    }

    @Test
    void skipsPaginatedOperation() {
        String operation = "import * from com::mulesoft::connectivity::decorator::Operation\n\n@OperationElement()\nvar baseOperation : Operation<{}, {}, {}, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( { })\n}\n@OperationElement()\nvar testOperation = baseOperation paginated((param, page)  -> do {\n         var items: Array<String> = []\n         ---\n         {\n           items: items,\n           nextPage: {\n                  args: {}\n                 }\n         }\n      }\n)\n";
        CollectedMessages collectedMessages = this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat((Object)collectedMessages.getWarnings().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2)));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getWarnings().get(collectedMessages.getWarnings().size() - 1), "Skipping validation of operation 'testOperation' because is defined with an intersection type", "connector", "\n515| ): PaginatedOperation<OpParam, OpParam, Page<ItemType, OpParam>, OpResultErrorType, OpConnectionType> = do {\n        ^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void skipsCustomizedPaginatedOperation() {
        String operation = "import * from com::mulesoft::connectivity::decorator::Operation\n\nvar baseOperation: Operation<{}, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success({})\n}\nvar paginatedBaseOperation = baseOperation paginated (param, pageValue) -> {\n                        items: [],\n                        nextPage: {\n                            args: param\n                        }\n                    }\n\nvar testOperation = paginatedBaseOperation mapInputPaginatedOperation (parameter: Object) -> {}\n";
        CollectedMessages collectedMessages = this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat((Object)collectedMessages.getWarnings().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2)));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getWarnings().get(collectedMessages.getWarnings().size() - 1), "Skipping validation of operation 'testOperation' because is defined with an intersection type", "connector", "\n59|     : PaginatedOperation<NewOpParam, NextOpParam, Page<ItemType, NextOpParam>, OpResultErrorType, OpConnectionType> =\n          ^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void validateTypeParameterIsNotPresent() {
        String operation = "import * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::decorator::Operation\nimport * from com::mulesoft::connectivity::decorator::PaginationStrategies\nimport serializeCookies, serializeHeaders, serializeUriParams, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization\nimport alwaysMapsTo, fromMapping, mapsTo, withTransformer from com::mulesoft::connectivity::codegen::Transformation\n\ntype T_company = {\n  \"type\"?: \"company\",\n  id?: String\n}\n\ntype T_pages_link = {\n  \"type\"?: \"pages\",\n  page?: Number,\n  next?: String | Null,\n  per_page?: Number,\n  total_pages?: Number\n}\n\ntype T_contact_attached_companies = {\n  \"type\"?: \"list\",\n  companies?: Array<T_company>,\n  total_count?: Number,\n  pages?: T_pages_link\n}\n\ntype O_contacts__id__companies_get_Type = {\n  \"200\": HttpResponse<T_contact_attached_companies>,\n  \"401\": HttpResponse<{}>,\n  \"404\": HttpResponse<{}>,\n  errorResponse: ResultFailure<O_contacts__id__companies_get_Type.\"404\", Error<\"status-404\", \"CLIENT_ERROR\">> | ResultFailure<O_contacts__id__companies_get_Type.\"401\", Error<\"status-401\", \"CLIENT_ERROR\">> | ResultFailure<HttpResponse<Any>, Error<\"status-unexpected\", String>>,\n  request: HttpRequestType<{uri : {id : String}}>,\n  response: O_contacts__id__companies_get_Type.\"200\"\n}\n\nvar O_contacts__id__companies_get = {\n  name: \"listCompaniesForAContact\",\n  displayName: \"listCompaniesForAContact\",\n  executor: (parameter: O_contacts__id__companies_get_Type.request, connection: HttpConnection): Result<O_contacts__id__companies_get_Type.response, O_contacts__id__companies_get_Type.errorResponse> -> do {\n      var uri = serializeUriParams(parameter.uri, {})\n      var query = parameter.query default {} withSerializationConfig {}\n      var headers = serializeHeaders(parameter.headers default {}, {})\n      var cookie = serializeCookies(parameter.cookie default {}, {})\n      var response = connection({\n        method: \"GET\",\n        path: \"/contacts/$(uri.id)/companies\",\n        queryParams: query,\n        headers: headers,\n        cookie: cookie,\n        (body: parameter.body) if (parameter.body?)\n      })\n      ---\n      response match {\n        case response200 if response200.status == 200 -> success(response200 as O_contacts__id__companies_get_Type.\"200\")\n        case response401 if response401.status == 401 -> failure(response401 as O_contacts__id__companies_get_Type.\"401\", {\n          kind: \"status-401\",\n          categories: [\"CLIENT_ERROR\"]\n        }, \"Unauthorized\")\n        case response404 if response404.status == 404 -> failure(response404 as O_contacts__id__companies_get_Type.\"404\", {\n          kind: \"status-404\",\n          categories: [\"CLIENT_ERROR\"]\n        }, \"Contact not found\")\n        else responsedefault-> failure(responsedefault, {\n          kind: \"status-unexpected\",\n          categories: []\n        }, \"Unexpected status code\")\n      }\n    }\n}\n\ntype flow_O_contacts__id__companies_get_request = {\n  id: O_contacts__id__companies_get_Type.request.uri.id\n}\n\nvar flow_O_contacts__id__companies_get_mapping = [\n  \"id\" mapsTo \"uri.id\",\n  {} alwaysMapsTo \"query\",\n  {} alwaysMapsTo \"headers\",\n  {} alwaysMapsTo \"cookie\"\n]\n\nvar O_contacts__id__companies_get_paginated = pageNumberPaginated(\n    O_contacts__id__companies_get mapInputOperation (param) -> param,\n    (page) -> page.body.data default [],\n    (param) -> param.query.page default 1,\n    (param, pageNumber) -> (param update { case query at .query! -> query update { case page at .page! -> pageNumber } })\n)\n\n@OperationElement()\nvar testOperation = O_contacts__id__companies_get_paginated withTransformer {\n  in: fromMapping<flow_O_contacts__id__companies_get_request, O_contacts__id__companies_get_Type.request>(flow_O_contacts__id__companies_get_mapping)\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Unsupported type at output.items[]: ItemType", "InvalidFlowType", "\n119|     items: Array<ItemType>,\n                      ^^^^^^^^");
    }

    @Test
    void acceptsInputUnionWithDiscriminatorAndFieldSelector() {
        String operation = "type OperationInputType = {myProperty: @Discriminator(value = {key: \"kind\"}) @FieldSelector() ( {kind: \"val1\", property1: String} | {kind: \"val2\", property2: String})}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
    }

    @Test
    void acceptsInputUnionWithDiscriminatorAndResultSetFilter() {
        String operation = "type MyUnion = {kind: \"val1\", property1: String} | {kind: \"val2\", property2: String}\ntype OperationInputType = {myProperty: @Discriminator(value = {key: \"kind\"}) @ResultSetFilter() MyUnion}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
    }

    @Test
    void acceptsInputUnionWithDiscriminatorAndFieldOrder() {
        String operation = "type MyUnion =\n QueryFieldNoOrder | QueryFieldOrder\ntype OperationInputType = {orderBy?: @FieldOrder() @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @MinSize(value= 1) @MaxSize(value= 2) MyUnion}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        this.assertCompileSuccessful(OperationValidatorTest.buildConnectorModule(operation));
    }

    @Test
    void rejectsFieldOrderWithoutInvalidOrder() {
        String operation = "type OperationInputType = {orderBy?: @FieldOrder() @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @MinSize(value= 1) @MaxSize(value= 2) ({kind: \"INVALID_VALUE\", property1: String} | {kind: \"SORTED\", property2: String})}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)2));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Field Order must have 'NOT_SORTED' and 'SORTED' kinds, at input: {\n  kind: \"INVALID_VALUE\", \n  property1: String\n} | {\n  kind: \"SORTED\", \n  property2: String\n}", "InvalidFlowType", "\n8| type OperationInputType = {orderBy?: @FieldOrder() @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @MinSize(value= 1) @MaxSize(value= 2) ({kind: \"INVALID_VALUE\", property1: String} | {kind: \"SORTED\", property2: String})}\n                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(1), "QueryFieldNoOrder must be the first option of orderBy field, at input: {\n  kind: \"INVALID_VALUE\", \n  property1: String\n} | {\n  kind: \"SORTED\", \n  property2: String\n}", "InvalidFlowType", "\n8| type OperationInputType = {orderBy?: @FieldOrder() @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @MinSize(value= 1) @MaxSize(value= 2) ({kind: \"INVALID_VALUE\", property1: String} | {kind: \"SORTED\", property2: String})}\n                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsInputUnionWithDiscriminatorAndWithoutFieldSelectorNorResultSetFilterNorFieldOrder() {
        String operation = "        type OperationInputType = {myProperty: @Discriminator(value = {key: \"kind\"}) ( {kind: \"val1\", property1: String} | {kind: \"val2\", property2: String})}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Unsupported type at input.myProperty: {\n  kind: \"val1\", \n  property1: String\n} | {\n  kind: \"val2\", \n  property2: String\n}", "InvalidFlowType", "\n8|         type OperationInputType = {myProperty: @Discriminator(value = {key: \"kind\"}) ( {kind: \"val1\", property1: String} | {kind: \"val2\", property2: String})}\n                                                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsInputUnionWithoutDiscriminator() {
        String operation = "type OperationInputType = {myProperty: @FieldSelector() ( {kind: \"val1\", property1: String} | {kind: \"val2\", property2: String})}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Union types should have a Discriminator annotation at input.myProperty: {\n  kind: \"val1\", \n  property1: String\n} | {\n  kind: \"val2\", \n  property2: String\n}", "InvalidFlowType", "\n8| type OperationInputType = {myProperty: @FieldSelector() ( {kind: \"val1\", property1: String} | {kind: \"val2\", property2: String})}\n                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsInputUnionWithDiscriminatorTypeWithoutField() {
        String operation = "type OperationInputType = {myProperty: @Discriminator(value = {key: \"kind\"}) @FieldSelector() ( {kind: \"val1\", property1: String} | {property2: String})}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Union member { property2: String } doesn't contain the field 'kind' which was declared with a Discriminator annotation at input.myProperty: {\n  kind: \"val1\", \n  property1: String\n} | { property2: String }", "InvalidFlowType", "\n8| type OperationInputType = {myProperty: @Discriminator(value = {key: \"kind\"}) @FieldSelector() ( {kind: \"val1\", property1: String} | {property2: String})}\n                                                                                                                                       ^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsInputUnionWithDiscriminatorDuplicatedValues() {
        String operation = "type OperationInputType = {myProperty: @Discriminator(value = {key: \"kind\"}) @FieldSelector() ( {kind: \"val1\", property1: String} | {kind: \"val1\", property2: String})}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Discriminator has duplicate value: 'val1'", "InvalidFlowType", "\n8| type OperationInputType = {myProperty: @Discriminator(value = {key: \"kind\"}) @FieldSelector() ( {kind: \"val1\", property1: String} | {kind: \"val1\", property2: String})}\n                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsInputUnionOfNulls() {
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule("type MyInput = Null | Null | Null\n@OperationElement()\nvar testOperation : Operation<{property: MyInput}, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {})\n}\n"));
        List<ValidationMessage> errors = collectedMessages.getErrors();
        MatcherAssert.assertThat(errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors.get(0).getMessage().getMessage(), (Matcher)Matchers.is((Object)"Unsupported type at input.property: Null | Null | Null"));
    }

    @Test
    void rejectsInputObjectPropertyWithRecursiveArray() {
        String operation = "type MyArray = Array<MyArray>\n\n@OperationElement()\nvar testOperation : Operation<{property: MyArray}, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    void rejectsInputObjectPropertyWithRecursiveIntersection() {
        String operation = "type MyIntersection = {\n    value: String\n} & MyIntersection\n@OperationElement()\nvar testOperation : Operation<{property: MyIntersection}, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {})\n}\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValidatorTest.buildConnectorModule(operation));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    void rejectsConnectorWithInvalidDynamicMetadataReferenceTest() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\ntype AccountDynamic = {\n  accountId : Object\n}\nvar accountType : TypeValueDefinition =\n    createExtendedObjectTypeValueDefinition(\"Account\", AccountDynamic)\n        withField createField(\"description\", createStringTypeValueDefinition())\nvar metadataProvider: MetadataProviderExecutor<{objectType: String, aRequiredParam: String}, {errorMessage: String}, HttpConnection> = (params, conn) ->\n    if (params.objectType == \"Account\")\n      success(accountType)\n    else\n      failure({errorMessage: \"error\"})\ntype Ticket = {\n id?: Number,\n title?: String,\n extraFields?: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\", \"unExisting\" : \"/title\"} }) Object\n}\nvar createRecordOperation: Operation<{}, Ticket, ResultFailure<{}, Error>, HttpConnection> = { \nname: \"createRecordOperation\", displayName: \"Create Record\",executor: (parameter, connection) -> success({ }) \n} \n@FlowConnectorElement()\nvar connector = {\n    name: \"DataWeaveExtension\",\n    displayName: \"Data Weave Extension\",\noperations: {\n              createRecordOperation: createRecordOperation\n           },\n    metadataProviders: {\n      metadataProvider: metadataProvider\n    }\n}\n");
        OperationValidatorTest.assertValidationMessage(collectedMessages.getErrors(), List.of(Triple.of((Object)"Invalid metadata provider reference at output.extraFields missing parameter 'aRequiredParam'", (Object)"InvalidFlowType", (Object)"\n23|  extraFields?: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\", \"unExisting\" : \"/title\"} }) Object\n                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"), Triple.of((Object)"Invalid metadata provider reference at output.extraFields parameter 'unExisting' does not match to any parameter defined in the metadata provider 'metadataProvider'", (Object)"InvalidFlowType", (Object)"\n23|  extraFields?: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\", \"unExisting\" : \"/title\"} }) Object\n                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"), Triple.of((Object)"Value passed into parameter selector 'objectType': Selector '/objectType' doesn't exist in the type: Object", (Object)"connector", (Object)"\n23|  extraFields?: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\", \"unExisting\" : \"/title\"} }) Object\n                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"), Triple.of((Object)"Value passed into parameter selector 'unExisting': Selector '/title' doesn't exist in the type: Object", (Object)"connector", (Object)"\n23|  extraFields?: @MetadataProvider(value = { name: \"metadataProvider\", arguments: {\"objectType\": \"/objectType\", \"unExisting\" : \"/title\"} }) Object\n                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^")));
    }
}

