/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowOperationsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowValueProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.NoDynamicNamesRule;
import com.mulesoft.connectivity.flow.api.validator.rules.RequiresValueProviderAnnotationRule;
import com.mulesoft.connectivity.flow.api.validator.rules.UnionRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.rules.ArrayRule;
import com.mulesoft.connectivity.validation.rules.ExecutorRule;
import com.mulesoft.connectivity.validation.rules.MessageRule;
import com.mulesoft.connectivity.validation.rules.ObjectRule;
import com.mulesoft.connectivity.validation.rules.OperationRule;
import com.mulesoft.connectivity.validation.rules.ProviderReferenceRule;
import com.mulesoft.connectivity.validation.rules.ReferenceRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class OperationValueProviderValidationTest
extends AbstractValidatorTest {
    OperationValueProviderValidationTest() {
    }

    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowValueProvidersRule.class, FlowOperationsRule.class, OperationRule.class, ExecutorRule.class, MessageRule.class, ReferenceRule.class, ObjectRule.class, UnionRule.class, NoDynamicNamesRule.class, ArrayRule.class, ProviderReferenceRule.class, RequiresValueProviderAnnotationRule.class});
    }

    protected static String buildConnectorModule(String operation, String valueProviders) {
        return "%dw 2.7\n" + String.format("import * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::flow::Annotations\n%s@FlowConnectorElement\nvar connector = {\n   operations: {\n      testOperation: testOperation\n   },\nvalueProviders: {%s}\n}", operation, valueProviders);
    }

    @Test
    void acceptsValueProviderWithoutArguments() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {myProperty: @ValuesFrom(value = { name: \"testValueProvider\" }) String}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        this.assertCompileSuccessful(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
    }

    @Test
    void acceptsValueProviderWithArguments() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {recordType: String}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {recordType: String, myProperty: @ValuesFrom(value = { name: \"testValueProvider\", arguments: {recordType: \"/recordType\" }  }) String}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        this.assertCompileSuccessful(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
    }

    @Test
    void rejectsValueProviderWrongName() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {myProperty: @ValuesFrom(value = { name: \"wrongName\" }) String}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Cannot find value provider 'wrongName'.", "connector", "\n11|                     (parameter: {}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {myProperty: @ValuesFrom(value = { name: \"wrongName\" }) String}\n                                                                                                                                                                                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsValueProviderMissingArgument() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {recordType: String}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {recordType: String, myProperty: @ValuesFrom(value = { name: \"testValueProvider\" }) String}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid value provider reference at input.myProperty missing parameter 'recordType'", "InvalidFlowType", "\n11|                     (parameter: {recordType: String}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {recordType: String, myProperty: @ValuesFrom(value = { name: \"testValueProvider\" }) String}\n                                                                                                                                                                                                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsValueProviderWithArgumentWithWrongPath() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {recordType: String}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {recordType: String, myProperty: @ValuesFrom(value = { name: \"testValueProvider\", arguments: {recordType: \"/objectType\" }  }) String}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Value passed into parameter selector 'recordType': Selector '/objectType' doesn't exist in the type: OperationInputType", "connector", "\n11|                     (parameter: {recordType: String}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {recordType: String, myProperty: @ValuesFrom(value = { name: \"testValueProvider\", arguments: {recordType: \"/objectType\" }  }) String}\n                                                                                                                                                                                                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsValueProviderWithExtraArguments() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {recordType: String}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {recordType: String, myProperty: @ValuesFrom(value = { name: \"testValueProvider\", arguments: {recordType: \"/recordType\", accountType: \"/recordType\" }  }) String}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid value provider reference at input.myProperty parameter 'accountType' does not match to any parameter defined in the value provider 'testValueProvider'", "InvalidFlowType", "\n11|                     (parameter: {recordType: String}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])type OperationInputType = {recordType: String, myProperty: @ValuesFrom(value = { name: \"testValueProvider\", arguments: {recordType: \"/recordType\", accountType: \"/recordType\" }  }) String}\n                                                                                                                                                                                                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void acceptsRequiresValueProvider() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\", properties: {fieldType: String}}}] as Array<ProvidedValue<String, FieldType>>)\ntype OperationInputType = {myProperty: CustomFieldsSelection<@ValuesFrom(value = { name: \"testValueProvider\" }) String>}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        this.assertCompileSuccessful(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
    }

    @Test
    void rejectsRequiresValueProviderWithoutValueProvider() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\", properties: {fieldType: \"String\"}}}] as Array<ProvidedValue<String, {}>>)\ntype OperationInputType = {myProperty: CustomFieldsSelection<String>}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Property at input.myProperty.fields[] requires a value provider but none was defined.", "InvalidFlowType", "\n88|   fields: Array<@RequiresValueProvider(value = {providedValueType: String, displayPropertiesType: FieldType}) F>\n                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsRequiresValueProviderWrongValueType() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {}, connection) -> success({}), (response: Object) -> [{value: 1, displayValue: {label: \"label1\", properties: {fieldType: \"String\"}}}] as Array<ProvidedValue<Number, FieldType>>)\ntype OperationInputType = {myProperty: CustomFieldsSelection<@ValuesFrom(value = { name: \"testValueProvider\" }) String>}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid value provider at input.myProperty.fields[] required value type is dw::Core::String but received Number", "InvalidFlowType", "\n88|   fields: Array<@RequiresValueProvider(value = {providedValueType: String, displayPropertiesType: FieldType}) F>\n                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsRequiresValueProviderWrongDisplayPropertiesType() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\", properties: {aField: \"String\"}}}] as Array<ProvidedValue<String, {aField: String}>>)\ntype OperationInputType = {myProperty: CustomFieldsSelection<@ValuesFrom(value = { name: \"testValueProvider\" }) String>}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        CollectedMessages collectedMessages = this.assertCompileFailure(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        OperationValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid value provider at input.myProperty.fields[] required display properties type is com::mulesoft::connectivity::flow::QueryBuilder::FieldType but received {| aField: \"String\" |}", "InvalidFlowType", "\n88|   fields: Array<@RequiresValueProvider(value = {providedValueType: String, displayPropertiesType: FieldType}) F>\n                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void acceptsValueProviderWithArgumentsInnerObject() {
        String operation = "import * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::Model\nvar testValueProvider = defineValueProvider(\n                    (parameter: {recordType: String}, connection) -> success({}), (response: Object) -> [{value: \"val1\", displayValue: {label: \"label1\"}}])\ntype OperationInputType = {myField: {recordType: String, myProperty: @ValuesFrom(value = { name: \"testValueProvider\", arguments: {recordType: \"recordType\" }}) String }}\n\n@OperationElement()\nvar testOperation : Operation<OperationInputType, {}, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success( {myProperty: \"foo\"})\n}\n";
        String valueProviders = "testValueProvider: testValueProvider";
        this.assertCompileSuccessful(OperationValueProviderValidationTest.buildConnectorModule(operation, valueProviders));
    }
}

