/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowConnectionsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowMetadataProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowOperationsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowTriggersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowValueProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.ReferenceTypesUniqueNamesRule;
import com.mulesoft.connectivity.flow.api.validator.rules.RequiresValueProviderAnnotationRule;
import com.mulesoft.connectivity.flow.api.validator.rules.UnionRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.rules.ArrayRule;
import com.mulesoft.connectivity.validation.rules.ExecutorRule;
import com.mulesoft.connectivity.validation.rules.IntersectionRule;
import com.mulesoft.connectivity.validation.rules.MessageRule;
import com.mulesoft.connectivity.validation.rules.MetadataProviderRule;
import com.mulesoft.connectivity.validation.rules.ObjectRule;
import com.mulesoft.connectivity.validation.rules.OperationRule;
import com.mulesoft.connectivity.validation.rules.ProviderReferenceRule;
import com.mulesoft.connectivity.validation.rules.ReferenceRule;
import com.mulesoft.connectivity.validation.rules.TriggerRule;
import com.mulesoft.connectivity.validation.rules.ValueProviderRule;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ReferenceTypeUniqueNamesValidatorTest
extends AbstractValidatorTest {
    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowValueProvidersRule.class, FlowMetadataProvidersRule.class, FlowOperationsRule.class, FlowTriggersRule.class, FlowConnectionsRule.class, ValueProviderRule.class, MetadataProviderRule.class, OperationRule.class, ExecutorRule.class, MessageRule.class, TriggerRule.class, ReferenceRule.class, ObjectRule.class, UnionRule.class, IntersectionRule.class, ArrayRule.class, ProviderReferenceRule.class, RequiresValueProviderAnnotationRule.class, ReferenceTypesUniqueNamesRule.class});
    }

    @Test
    void rejectConnectorDuplicatedNameAccountUpdate() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::decorator::Operation\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from test001::Module\ntype AccountUpdate = {id: String, name: String, email: String}\n@OperationElement()\nvar getAccounts : Operation<AccountUpdateWrapper, HttpResponse<{items: Array<AccountUpdate>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n  name: \"DataWeaveExtension\",\n  displayName: \"Data Weave Extension\",\n  operations: {\n    getAccounts: getAccounts\n  },\n  valueProviders: {},\n}");
        ReferenceTypeUniqueNamesValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Name AccountUpdate already used by anonymous::AccountUpdate for type test001::Module::AccountUpdate", "connector", "\n14| var getAccounts : Operation<AccountUpdateWrapper, HttpResponse<{items: Array<AccountUpdate>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n                                                                                 ^^^^^^^^^^^^^");
    }

    @Test
    void acceptsConnectorNotDuplicatedNames() {
        this.assertCompileSuccessful("%dw 2.7\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::decorator::Operation\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from test001::Module\n@OperationElement()\nvar getAccounts : Operation<AccountUpdate, HttpResponse<{items: Array<AccountUpdate>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n  name: \"DataWeaveExtension\",\n  displayName: \"Data Weave Extension\",\n  operations: {\n    getAccounts: getAccounts\n  },\n  valueProviders: {},\n}");
    }
}

