/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowConnectionsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowMetadataProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowOperationsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowTriggersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowValueProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.UniqueNameRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class UniqueNameValidatorTest
extends AbstractValidatorTest {
    UniqueNameValidatorTest() {
    }

    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowValueProvidersRule.class, FlowMetadataProvidersRule.class, FlowOperationsRule.class, FlowTriggersRule.class, FlowConnectionsRule.class, UniqueNameRule.class});
    }

    @Test
    void acceptsConnector() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\n\nvar testValueProvider = defineValueProvider(???, ???)\n\n@FlowConnectorElement\nvar connector = {\n    operations: {testOperation: {}},\n    triggers: {testTrigger: {}},\n    valueProviders: {testValueProvider: testValueProvider},\n}");
    }

    @Test
    void acceptsEmptyConnector() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n}");
    }

    @Test
    void rejectsDuplicateOperationName() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    operations: {repeatedName: {}, repeatedName: {}},\n}");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        UniqueNameValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Duplicated operation name 'repeatedName' found.", "connector", "\n8|     operations: {repeatedName: {}, repeatedName: {}},\n                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsDuplicateTriggerName() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    triggers: {repeatedName: {}, repeatedName: {}},\n}");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        UniqueNameValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Duplicated trigger name 'repeatedName' found.", "connector", "\n8|     triggers: {repeatedName: {}, repeatedName: {}},\n                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsDuplicatedValueProviderName() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\n\nvar repeatedName = defineValueProvider(???, ???)\n\n@FlowConnectorElement\nvar connector = {\n    valueProviders: {repeatedName: repeatedName, repeatedName: repeatedName},\n}");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        UniqueNameValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Duplicated value provider name 'repeatedName' found.", "connector", "\n11|     valueProviders: {repeatedName: repeatedName, repeatedName: repeatedName},\n                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsDuplicatedMetadataProviderName() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::metadata::Builder\n\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n\nvar repeatedName: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, Any> =\n    (key, conn) -> success(orderType)\n\n@FlowConnectorElement\nvar connector = {\n    metadataProviders: {repeatedName: repeatedName, repeatedName: repeatedName},\n}");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        UniqueNameValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Duplicated metadata provider name 'repeatedName' found.", "connector", "\n15|     metadataProviders: {repeatedName: repeatedName, repeatedName: repeatedName},\n                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsDuplicatedName() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::metadata::Builder\n\nvar repeatedNameVP = defineValueProvider(???, ???)\n\nvar orderType : TypeValueDefinition =\n    createObjectTypeValueDefinition(\"Order\")\n\nvar repeatedNameMP: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, Any> =\n    (key, conn) -> success(orderType)\n\n@FlowConnectorElement\nvar connector = {\n    operations: {repeatedName: {}},\n    triggers: {repeatedName: {}},\n    valueProviders: {repeatedName: repeatedNameVP},\n    metadataProviders: {repeatedName: repeatedNameMP},\n}");
        collectedMessages.getErrors().stream().map(m -> m.getMessage().getMessage()).forEach(System.out::println);
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        UniqueNameValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Duplicated construct name 'repeatedName' found in: [VALUE_PROVIDER, METADATA_PROVIDER, OPERATION, TRIGGER]", "connector", "\n17| var connector = {\n        ^^^^^^^^^");
    }
}

