/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowValueProvidersRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.rules.ValueProviderRule;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class ValueProviderValidationTest
extends AbstractValidatorTest {
    ValueProviderValidationTest() {
    }

    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowValueProvidersRule.class, ValueProviderRule.class});
    }

    @Test
    void acceptsConnectorWithValidValueProviderPropertyType() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::decorator::Operation\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from test001::Module\n// Just a custom operation at the connector level\nvar accountsValueProvider = defineValueProvider(getAccounts.executor,\n\t(response: HttpResponse<{items: Array<Account>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name }}))\n@OperationElement()\nvar getAccounts : Operation< {}, HttpResponse<{items: Array<{id: String, name: String, email: String}>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n              {\n                id: \"2\",\n                name: \"Two\",\n                email: \"two@acme.com\"\n              },\n              {\n                id: \"3\",\n                name: \"Three\",\n                email: \"three@acme.com\"\n              },\n              {\n                id: \"4\",\n                name: \"Four\",\n                email: \"four@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                            getAccounts: getAccounts\n                    },\n                    valueProviders: {\n                       accountsValueProvider: accountsValueProvider\n                    }\n                }\n");
    }

    @Test
    void acceptsConnectorWithAnotherValidValueProviderPropertyType() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::decorator::Operation\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from test001::Module\n// Just a custom operation at the connector level\nvar accountsValueProvider = defineValueProvider(getAccounts.executor,\n\t(response: HttpResponse<{items: Array<Account>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name }}))\n@OperationElement()\nvar getAccounts : Operation< {items : Array<Number>}, HttpResponse<{items: Array<{id: String, name: String, email: String}>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n              {\n                id: \"2\",\n                name: \"Two\",\n                email: \"two@acme.com\"\n              },\n              {\n                id: \"3\",\n                name: \"Three\",\n                email: \"three@acme.com\"\n              },\n              {\n                id: \"4\",\n                name: \"Four\",\n                email: \"four@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                            getAccounts: getAccounts\n                    },\n                    valueProviders: {\n                       accountsValueProvider: accountsValueProvider\n                    }\n                }\n");
    }

    @Test
    void rejectsConnectorWithInValidValueProviderPropertyNullType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from com::mulesoft::connectivity::decorator::Operation\n\nimport * from test001::Module\n\n// Just a custom operation at the connector level\n\nvar accountsValueProvider =defineValueProvider(getAccounts.executor,\n\t(response: HttpResponse<{items: Array<Account>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name }}))\n\n@OperationElement()\nvar getAccounts : Operation<Null, HttpResponse<{items: Array<{id: String, name: String, email: String}>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n              {\n                id: \"2\",\n                name: \"Two\",\n                email: \"two@acme.com\"\n              },\n              {\n                id: \"3\",\n                name: \"Three\",\n                email: \"three@acme.com\"\n              },\n              {\n                id: \"4\",\n                name: \"Four\",\n                email: \"four@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                            getAccounts: getAccounts\n                    },\n                    valueProviders: {\n                       accountsValueProvider: accountsValueProvider\n                    }\n}\n");
        ValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for value provider input type. Expected: Object; Actual: Null", "connector", "\n63|                        accountsValueProvider: accountsValueProvider\n                                                  ^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void acceptsConnectorWithValidValueProviderPropertyEmptyRefType() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\n\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from com::mulesoft::connectivity::decorator::Operation\n\nimport * from test001::Module\n\ntype ParametersValueProvider = {}\n\nvar valueProviderWithInputRef : ValueProvider<ParametersValueProvider, {}, String, {}, HttpConnection> = \n    (p : ParametersValueProvider, c : HttpConnection) -> success([\n        {\n            value : \"value1\", \n            displayValue: {\n                label: \"Value 1\"\n            }\n        }\n    ])\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                    },\n                    valueProviders: {\n                       accountsValueProvider: valueProviderWithInputRef\n                    }\n}\n");
    }

    @Test
    void rejectsConnectorWithInValidValueProviderPropertyUnionRefType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from com::mulesoft::connectivity::decorator::Operation\n\nimport * from test001::Module\n\ntype ParametersValueProvider = \n{id: String} & { items : Number}\n\nvar valueProviderWithInputRef : ValueProvider<ParametersValueProvider, {}, String, {}, HttpConnection> = \n    (p : ParametersValueProvider, c : HttpConnection) -> success([\n        {\n            value : \"value1\", \n            displayValue: {\n                label: \"Value 1\"\n            }\n        }\n    ])\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                    },\n                    valueProviders: {\n                       accountsValueProvider: valueProviderWithInputRef\n                    }\n}\n");
        ValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for value provider input type. Expected: Object; Actual: { id: String } & { items: Number }", "connector", "\n34|                        accountsValueProvider: valueProviderWithInputRef\n                                                  ^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void acceptsConnectorWithValidValueProviderPropertyRefType() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\n\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from com::mulesoft::connectivity::decorator::Operation\n\nimport * from test001::Module\n\ntype ParametersValueProvider = { id : String }\n\nvar valueProviderWithInputRef : ValueProvider<ParametersValueProvider, {}, String, {}, HttpConnection> = \n    (p : ParametersValueProvider, c : HttpConnection) -> success([\n        {\n            value : \"value1\", \n            displayValue: {\n                label: \"Value 1\"\n            }\n        }\n    ])\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                    },\n                    valueProviders: {\n                       accountsValueProvider: valueProviderWithInputRef\n                    }\n}\n");
    }

    @Test
    void rejectsConnectorWithInValidValueProviderPropertyReferenceType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from com::mulesoft::connectivity::decorator::Operation\n\nimport * from test001::Module\n\n// Just a custom operation at the connector level\n\nvar accountsValueProvider =defineValueProvider(getAccounts.executor,\n\t(response: HttpResponse<{items: Array<Account>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name }}))\n\n@OperationElement()\nvar getAccounts : Operation< Int32, HttpResponse<{items: Array<{id: String, name: String, email: String}>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n              {\n                id: \"2\",\n                name: \"Two\",\n                email: \"two@acme.com\"\n              },\n              {\n                id: \"3\",\n                name: \"Three\",\n                email: \"three@acme.com\"\n              },\n              {\n                id: \"4\",\n                name: \"Four\",\n                email: \"four@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                            getAccounts: getAccounts\n                    },\n                    valueProviders: {\n                       accountsValueProvider: accountsValueProvider\n                    }\n}\n");
        ValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for value provider input type. Expected: Object; Actual: Number", "connector", "\n63|                        accountsValueProvider: accountsValueProvider\n                                                  ^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInValidValueProviderPropertyStringType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from com::mulesoft::connectivity::decorator::Operation\n\nimport * from test001::Module\n\n// Just a custom operation at the connector level\n\nvar accountsValueProvider =defineValueProvider(getAccounts.executor,\n\t(response: HttpResponse<{items: Array<Account>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name }}))\n\n@OperationElement()\nvar getAccounts : Operation< String, HttpResponse<{items: Array<{id: String, name: String, email: String}>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n              {\n                id: \"2\",\n                name: \"Two\",\n                email: \"two@acme.com\"\n              },\n              {\n                id: \"3\",\n                name: \"Three\",\n                email: \"three@acme.com\"\n              },\n              {\n                id: \"4\",\n                name: \"Four\",\n                email: \"four@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                            getAccounts: getAccounts\n                    },\n                    valueProviders: {\n                       accountsValueProvider: accountsValueProvider\n                    }\n}\n");
        ValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for value provider input type. Expected: Object; Actual: String", "connector", "\n63|                        accountsValueProvider: accountsValueProvider\n                                                  ^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInValidValueProviderPropertyNumberType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from com::mulesoft::connectivity::decorator::Operation\n\nimport * from test001::Module\n\n// Just a custom operation at the connector level\n\nvar accountsValueProvider =defineValueProvider(getAccounts.executor,\n\t(response: HttpResponse<{items: Array<Account>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name }}))\n\n@OperationElement()\nvar getAccounts : Operation< Number, HttpResponse<{items: Array<{id: String, name: String, email: String}>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n              {\n                id: \"2\",\n                name: \"Two\",\n                email: \"two@acme.com\"\n              },\n              {\n                id: \"3\",\n                name: \"Three\",\n                email: \"three@acme.com\"\n              },\n              {\n                id: \"4\",\n                name: \"Four\",\n                email: \"four@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                            getAccounts: getAccounts\n                    },\n                    valueProviders: {\n                       accountsValueProvider: accountsValueProvider\n                    }\n}\n");
        ValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for value provider input type. Expected: Object; Actual: Number", "connector", "\n63|                        accountsValueProvider: accountsValueProvider\n                                                  ^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInValidValueProviderPropertyBooleanType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from com::mulesoft::connectivity::decorator::Operation\n\nimport * from test001::Module\n\n// Just a custom operation at the connector level\n\nvar accountsValueProvider =defineValueProvider(getAccounts.executor,\n\t(response: HttpResponse<{items: Array<Account>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name }}))\n\n@OperationElement()\nvar getAccounts : Operation< Boolean, HttpResponse<{items: Array<{id: String, name: String, email: String}>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n              {\n                id: \"2\",\n                name: \"Two\",\n                email: \"two@acme.com\"\n              },\n              {\n                id: \"3\",\n                name: \"Three\",\n                email: \"three@acme.com\"\n              },\n              {\n                id: \"4\",\n                name: \"Four\",\n                email: \"four@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                            getAccounts: getAccounts\n                    },\n                    valueProviders: {\n                       accountsValueProvider: accountsValueProvider\n                    }\n}\n");
        ValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for value provider input type. Expected: Object; Actual: Boolean", "connector", "\n63|                        accountsValueProvider: accountsValueProvider\n                                                  ^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithInValidValueProviderPropertyArrayType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\n\nimport TestConnector from Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::metadata::Builder\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::Types\nimport * from com::mulesoft::connectivity::decorator::Operation\n\nimport * from test001::Module\n\n// Just a custom operation at the connector level\n\nvar accountsValueProvider =defineValueProvider(getAccounts.executor,\n\t(response: HttpResponse<{items: Array<Account>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name }}))\n\n@OperationElement()\nvar getAccounts : Operation< Array<Number>, HttpResponse<{items: Array<{id: String, name: String, email: String}>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {\n    name: \"getAccounts\",\n    displayName: \"Get Accounts\",\n    executor: (parameter, connection) -> success({\n          contentType: \"application/json\",\n          status: 200,\n          headers: {},\n          cookies: {},\n          body: {\n            items: [\n              {\n                id: \"1\",\n                name: \"One\",\n                email: \"one@acme.com\"\n              },\n              {\n                id: \"2\",\n                name: \"Two\",\n                email: \"two@acme.com\"\n              },\n              {\n                id: \"3\",\n                name: \"Three\",\n                email: \"three@acme.com\"\n              },\n              {\n                id: \"4\",\n                name: \"Four\",\n                email: \"four@acme.com\"\n              },\n            ]\n          }\n    })\n}\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n                    operations: {\n                            // getAccounts: getAccounts\n                    },\n                    valueProviders: {\n                       accountsValueProvider: accountsValueProvider\n                    }\n}\n");
        ValueProviderValidationTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for value provider input type. Expected: Object; Actual: Array<Number>", "connector", "\n63|                        accountsValueProvider: accountsValueProvider\n                                                  ^^^^^^^^^^^^^^^^^^^^^");
    }
}

