/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ObjectTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.R256TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandlerTestUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ObjectTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PropertyComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.TypeType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.WeaveType;

public class ObjectTypeHandlerTest {
    private final DataWeaveScriptingEngine engine = new DataWeaveScriptingEngine();

    @Nested
    @DisplayName(value="Anonymous Objects")
    public class Anonymous {
        private DWType dwType;
        private ComponentRegistry componentRegistry;
        TypeFactory typeFactory;
        ObjectTypeHandler objectTypeHandler;
        private Component serviceComponent = ((ServiceComponent.ServiceComponentBuilder)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).description("service description")).build();
        private Component outerComponent = ((ObjectTypeComponent.ObjectTypeComponentBuilder)((ObjectTypeComponent.ObjectTypeComponentBuilder)((ObjectTypeComponent.ObjectTypeComponentBuilder)ObjectTypeComponent.builder().outer("1")).name("OuterComponent")).description("This is the outer component for the tested one")).build();

        @BeforeEach
        void setUp() {
            String script = "%dw 2.8\n\ntype Root = {\n   a: String,\n}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)ObjectTypeHandlerTest.this.engine.inferTypeOf(script).get();
            this.dwType = ((TypeType)weaveType).getType();
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.objectTypeHandler = new ObjectTypeHandler(this.componentRegistry);
            this.componentRegistry.registerComponent(this.serviceComponent);
            this.componentRegistry.registerComponent(this.outerComponent);
        }

        @Test
        @DisplayName(value="WHEN call 'make' THEN creates it without any name")
        public void testAnonymousWithEmptyName() {
            Component actualComponent = this.objectTypeHandler.make(this.dwType, "", this.outerComponent, this.typeFactory);
            Assertions.assertEquals((Object)"", (Object)actualComponent.getName(), (String)"component.name should be empty");
            Assertions.assertEquals((Object)this.outerComponent.getId(), (Object)actualComponent.getOuter(), (String)("component.outer should be " + this.outerComponent.getId()));
        }

        @Test
        @DisplayName(value="WHEN call 'make' with another anonymous in the componentRegistry THEN distinguish by outer (name, componentType, outer)")
        public void testAnonymousDoesNotTakeAsAnother() {
            ObjectTypeComponent annonymousObjectAlreadyInTheRegistry = ((ObjectTypeComponent.ObjectTypeComponentBuilder)((ObjectTypeComponent.ObjectTypeComponentBuilder)((ObjectTypeComponent.ObjectTypeComponentBuilder)ObjectTypeComponent.builder().outer("1")).name("")).description("This is the annonymous object already in the registry")).build();
            this.componentRegistry.registerComponent((Component)annonymousObjectAlreadyInTheRegistry);
            Component actualComponent = this.objectTypeHandler.make(this.dwType, "", this.outerComponent, this.typeFactory);
            Assertions.assertNotEquals((Object)annonymousObjectAlreadyInTheRegistry.getId(), (Object)actualComponent.getId(), (String)("component.id should not be " + annonymousObjectAlreadyInTheRegistry.getId()));
        }
    }

    @Nested
    @DisplayName(value="Edge Cases")
    public class EdgeCases {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private ObjectTypeHandler objectTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.objectTypeHandler = new ObjectTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN object type with duplicate property names WHEN processed THEN creates both properties")
        public void testCollisionKeyHandling() {
            String script = "%dw 2.8\ntype Root = {\n  a: String,\n  a: Number\n}\n---\nRoot\n";
            TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            List<PropertyComponent> properties = this.componentRegistry.getComponents().values().stream().filter(c -> c.getName().equals("a") && c instanceof PropertyComponent).map(PropertyComponent.class::cast).toList();
            Assertions.assertEquals((int)2, (int)properties.size(), (String)"Should have both properties 'a' with collision handling");
            Set propertyTypes = properties.stream().map(p -> TypeHandlerTestUtils.findById(p.getPropertyType(), this.componentRegistry.getComponents())).filter(PrimitiveTypeComponent.class::isInstance).map(PrimitiveTypeComponent.class::cast).map(Component::getName).collect(Collectors.toSet());
            Assertions.assertTrue((boolean)propertyTypes.contains("String"), (String)"Should contain String type");
            Assertions.assertTrue((boolean)propertyTypes.contains("Double"), (String)"Should contain Double type");
        }

        @Test
        @DisplayName(value="GIVEN object with field that has description annotation WHEN processed THEN description is set on Property not on type")
        public void testPropertyWithDescription() {
            String script = "%dw 2.8\ntype Root = {\n  field1: Array<String> <~ {description: \"the description\"}\n}\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            Component property = TypeHandlerTestUtils.findComponent("field1", this.componentRegistry);
            Assertions.assertNull((Object)actualComponent.getDescription(), (String)"The description shouldn't be set on the ObjectType");
            Assertions.assertEquals((Object)"the description", (Object)property.getDescription(), (String)"The description should be set on the Property component");
        }
    }

    @Nested
    @DisplayName(value="Property Modifiers")
    public class PropertyModifiers {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private ObjectTypeHandler objectTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.objectTypeHandler = new ObjectTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN object type with optional field WHEN processed THEN marks property as not required")
        public void testOptionalFieldType() {
            String script = "%dw 2.8\ntype Root = {\n  optionalField?: Boolean\n}\n---\nRoot\n";
            TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            PropertyComponent property = TypeHandlerTestUtils.findProperty("optionalField", this.componentRegistry);
            Assertions.assertEquals((Object)"optionalField", (Object)property.getName());
            Assertions.assertFalse((boolean)property.isRequired(), (String)"Optional field should be marked as not required");
            Component propertyType = TypeHandlerTestUtils.findById(property.getPropertyType(), this.componentRegistry.getComponents());
            Assertions.assertNotNull((Object)propertyType, (String)"Property type not found");
            Assertions.assertInstanceOf(PrimitiveTypeComponent.class, (Object)propertyType);
            Assertions.assertEquals((Object)"Boolean", (Object)propertyType.getName());
        }

        @Test
        @DisplayName(value="GIVEN object type with union including Null WHEN processed THEN marks property as nullable")
        public void testNullableUnionFieldType() {
            String script = "%dw 2.8\ntype Root = {\n  nullableField: Boolean | Null\n}\n---\nRoot\n";
            TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            PropertyComponent property = TypeHandlerTestUtils.findProperty("nullableField", this.componentRegistry);
            Assertions.assertEquals((Object)"nullableField", (Object)property.getName());
            Assertions.assertTrue((boolean)property.isNullable(), (String)"Field with union including Null should be marked as nullable");
            Assertions.assertTrue((boolean)property.isRequired(), (String)"Field should still be required even if nullable");
            Component propertyType = TypeHandlerTestUtils.findById(property.getPropertyType(), this.componentRegistry.getComponents());
            Assertions.assertNotNull((Object)propertyType, (String)"Property type not found");
            Assertions.assertTrue((boolean)(propertyType instanceof PrimitiveTypeComponent));
            Assertions.assertEquals((Object)"Boolean", (Object)propertyType.getName());
        }

        @Test
        @DisplayName(value="GIVEN object type with string literal union WHEN processed THEN creates String primitive with enum handling")
        public void testStringLiteralFieldType() {
            String script = "%dw 2.8\ntype Root = {\n  literalField: \"Mariano\" | \"Pablo\" | \"Martin\"\n}\n---\nRoot\n";
            TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            PropertyComponent property = TypeHandlerTestUtils.findProperty("literalField", this.componentRegistry);
            Assertions.assertEquals((Object)"literalField", (Object)property.getName());
            Assertions.assertTrue((boolean)property.isRequired(), (String)"String literal field should be required by default");
            Component propertyType = TypeHandlerTestUtils.findById(property.getPropertyType(), this.componentRegistry.getComponents());
            Assertions.assertNotNull((Object)propertyType, (String)"Property type not found");
            Assertions.assertTrue((boolean)(propertyType instanceof PrimitiveTypeComponent));
            Assertions.assertEquals((Object)"String", (Object)propertyType.getName());
        }
    }

    @Nested
    @DisplayName(value="Complex Field Types")
    public class ComplexFieldTypes {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private ObjectTypeHandler objectTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.objectTypeHandler = new ObjectTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN object type with Array field WHEN processed THEN creates List component property")
        public void testArrayFieldType() {
            String script = "%dw 2.8\ntype Root = {\n  arrayField: Array<String>\n}\n---\nRoot\n";
            TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            PropertyComponent property = TypeHandlerTestUtils.findProperty("arrayField", this.componentRegistry);
            Assertions.assertEquals((Object)"arrayField", (Object)property.getName());
            Assertions.assertTrue((boolean)property.isRequired(), (String)"Array field should be required by default");
            Component propertyType = (Component)this.componentRegistry.getComponents().get(property.getPropertyType());
            Assertions.assertNotNull((Object)propertyType, (String)"Property type not found");
            Assertions.assertEquals((Object)"ListDataType", (Object)propertyType.getComponentType().getValue());
        }

        @Test
        @DisplayName(value="GIVEN object type with nested object field WHEN processed THEN creates nested ObjectTypeComponent")
        public void testNestedObjectFieldType() {
            String script = "%dw 2.8\ntype Root = {\n  nestedField: {a: String}\n}\n---\nRoot\n";
            TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            PropertyComponent property = TypeHandlerTestUtils.findProperty("nestedField", this.componentRegistry);
            Assertions.assertEquals((Object)"nestedField", (Object)property.getName());
            Assertions.assertTrue((boolean)property.isRequired(), (String)"Nested object field should be required by default");
            Component propertyType = TypeHandlerTestUtils.findById(property.getPropertyType(), this.componentRegistry.getComponents());
            Assertions.assertNotNull((Object)propertyType, (String)"Property type not found");
            Assertions.assertTrue((boolean)(propertyType instanceof ObjectTypeComponent));
            boolean nestedPropertyExists = this.componentRegistry.getComponents().values().stream().anyMatch(c -> c.getName().equals("a") && c instanceof PropertyComponent && c.getOuter().equals(propertyType.getId()));
            Assertions.assertTrue((boolean)nestedPropertyExists, (String)"Nested object should contain property 'a'");
        }
    }

    @Nested
    @DisplayName(value="Special Field Types")
    public class SpecialFieldTypes {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private ObjectTypeHandler objectTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.objectTypeHandler = new ObjectTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @ParameterizedTest(name="GIVEN object type with {0} field WHEN processed THEN creates {2} primitive property")
        @CsvSource(value={"anyField, Any, AnyType", "nullField, Null, AnyType"})
        @DisplayName(value="Special field types")
        public void testSpecialFieldTypes(String fieldName, String dataWeaveType, String expectedPrimitiveType) {
            String script = TypeHandlerTestUtils.createDataWeaveScript(fieldName, dataWeaveType);
            TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            PropertyComponent property = TypeHandlerTestUtils.findProperty(fieldName, this.componentRegistry);
            TypeHandlerTestUtils.assertBasicProperty(property, fieldName, expectedPrimitiveType, this.componentRegistry);
        }
    }

    @Nested
    @DisplayName(value="Primitive Field Types")
    public class PrimitiveFieldTypes {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private ObjectTypeHandler objectTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.objectTypeHandler = new ObjectTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @ParameterizedTest(name="GIVEN object type with {0} field WHEN processed THEN creates {2} primitive property")
        @CsvSource(value={"stringField, String, String", "numberField, Number, Double", "booleanField, Boolean, Boolean", "dateField, Date, Date", "dateTimeField, DateTime, Datetime"})
        @DisplayName(value="Standard primitive field types")
        public void testStandardPrimitiveFieldTypes(String fieldName, String dataWeaveType, String expectedPrimitiveType) {
            String script = TypeHandlerTestUtils.createDataWeaveScript(fieldName, dataWeaveType);
            TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            PropertyComponent property = TypeHandlerTestUtils.findProperty(fieldName, this.componentRegistry);
            TypeHandlerTestUtils.assertBasicProperty(property, fieldName, expectedPrimitiveType, this.componentRegistry);
        }

        @Test
        @DisplayName(value="GIVEN object type with Period field WHEN processed THEN falls back to String")
        public void testPeriodFieldTypeFallback() {
            String script = TypeHandlerTestUtils.createDataWeaveScript("periodField", "String");
            TypeHandlerTestUtils.processDataWeaveScript(script, this.objectTypeHandler, this.serviceComponent, this.typeFactory);
            PropertyComponent property = TypeHandlerTestUtils.findProperty("periodField", this.componentRegistry);
            TypeHandlerTestUtils.assertBasicProperty(property, "periodField", "String", this.componentRegistry);
        }
    }
}

