/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.ComponentPath;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.TypeType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.ReferenceType;
import org.mule.weave.v2.ts.WeaveType;

public class PatchTest {
    private ComponentRegistry componentRegistry;
    private TypeFactory typeFactory;

    @BeforeEach
    void setup() {
        this.componentRegistry = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        this.typeFactory = (TypeFactory)Mockito.mock(TypeFactory.class);
        Mockito.when((Object)this.typeFactory.getComponentRegistry()).thenReturn((Object)this.componentRegistry);
    }

    @Nested
    @DisplayName(value="Out Parameter Intersection Patching")
    class OutParameterIntersectionPatching {
        private final Patch patch = Patch.fromResource((String)"patch.json");

        OutParameterIntersectionPatching() {
        }

        @Test
        @DisplayName(value="GIVEN no patch for the service WHEN patchOutParameterIntersectionType is called THEN returns empty")
        public void testPatchOutParameterWithNoServicePatch() {
            Component outer = (Component)Mockito.mock(Component.class);
            Mockito.when((Object)PatchTest.this.componentRegistry.getServiceComponent()).thenReturn((Object)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("NotPatchedService")).build());
            Assertions.assertFalse((boolean)this.patch.shouldApplyOutParameterSoftIntersectionResolution(outer, PatchTest.this.typeFactory), (String)"should be false because no patch is defined for the service");
        }

        @Test
        @DisplayName(value="GIVEN 'outParameterIntersectionResolution' patch WHEN path not in set THEN returns empty")
        public void testPatchOutParameterWithNonMatchingPath() {
            Component outer = (Component)Mockito.mock(Component.class);
            String serviceName = "testService";
            ComponentPath path = ComponentPath.fromTopDown((String)"testService#SERVICE/myObject#OBJECT/myField#PROPERTY_TYPE");
            this.patch.getServicePatch(serviceName).outParameterIntersectionResolution().add(path);
            ComponentPath differentPath = ComponentPath.fromTopDown((String)"testService#SERVICE/differentObject#OBJECT/myField#PROPERTY_TYPE");
            Mockito.when((Object)PatchTest.this.componentRegistry.getServiceComponent()).thenReturn((Object)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name(serviceName)).build());
            Mockito.when((Object)PatchTest.this.componentRegistry.getPath(outer)).thenReturn((Object)differentPath);
            Assertions.assertFalse((boolean)this.patch.shouldApplyOutParameterSoftIntersectionResolution(outer, PatchTest.this.typeFactory), (String)"should be false because the path is not in the outParameterIntersectionResolution set");
        }

        @Test
        @DisplayName(value="GIVEN 'outParameterIntersectionResolution' patch WHEN path is in the set THEN returns new DWType")
        public void testPatchOutParameterWithMatchingPath() {
            DataWeaveScriptingEngine engine = new DataWeaveScriptingEngine();
            String script = "%dw 2.8\ntype Root = {age: Number} & Test & {id : Number}\n\ntype Test = {\n  name: String <~ {label: \"Label for Test.name\"}\n} <~ {label : \"Label for Test\"}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            Component outer = (Component)Mockito.mock(Component.class);
            String serviceName = "testService";
            ComponentPath path = ComponentPath.fromTopDown((String)"testService#SERVICE/myObject#OBJECT/myField#PROPERTY_TYPE");
            this.patch.getServicePatch(serviceName).outParameterIntersectionResolution().add(path);
            Mockito.when((Object)PatchTest.this.componentRegistry.getServiceComponent()).thenReturn((Object)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name(serviceName)).build());
            Mockito.when((Object)PatchTest.this.componentRegistry.getPath(outer)).thenReturn((Object)path);
            Assertions.assertTrue((boolean)this.patch.shouldApplyOutParameterSoftIntersectionResolution(outer, PatchTest.this.typeFactory), (String)"should be true because the path is in the outParameterIntersectionResolution set");
        }
    }

    @Nested
    @DisplayName(value="Intersection Type Patching")
    class IntersectionTypePatching {
        private final Patch patch = Patch.fromResource((String)"patch.json");

        IntersectionTypePatching() {
        }

        @Test
        @DisplayName(value="GIVEN no patch for the service WHEN patchIntersectionType is called THEN returns empty")
        public void testPatchIntersectionWithNoServicePatch() {
            Component outer = (Component)Mockito.mock(Component.class);
            Mockito.when((Object)PatchTest.this.componentRegistry.getServiceComponent()).thenReturn((Object)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("NotPatchedService")).build());
            Assertions.assertFalse((boolean)this.patch.shouldApplySoftIntersectionResolution(outer, PatchTest.this.typeFactory), (String)"should be false because no patch is defined for the service");
        }

        @Test
        @DisplayName(value="GIVEN 'softIntersectionResolution' patch WHEN path is not in the set THEN returns empty")
        public void testPatchIntersectionWithNonMatchingPath() {
            Component outer = (Component)Mockito.mock(Component.class);
            String serviceName = "testService";
            ComponentPath path = ComponentPath.fromTopDown((String)"testService#SERVICE/myObject#OBJECT/myField#PROPERTY_TYPE");
            this.patch.getServicePatch(serviceName).softIntersectionResolution().add(path);
            ComponentPath differentPath = ComponentPath.fromTopDown((String)"testService#SERVICE/differentObject#OBJECT/myField#PROPERTY_TYPE");
            Mockito.when((Object)PatchTest.this.componentRegistry.getServiceComponent()).thenReturn((Object)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name(serviceName)).build());
            Mockito.when((Object)PatchTest.this.componentRegistry.getPath(outer)).thenReturn((Object)differentPath);
            Assertions.assertFalse((boolean)this.patch.shouldApplySoftIntersectionResolution(outer, PatchTest.this.typeFactory), (String)"should be false because the path is not in the softIntersectionResolution set");
        }

        @Test
        @DisplayName(value="GIVEN 'softIntersectionResolution' patch WHEN path is in the set THEN returns new component")
        public void testPatchIntersectionWithMatchingPath() {
            DataWeaveScriptingEngine engine = new DataWeaveScriptingEngine();
            String script = "%dw 2.8\ntype Root = {age: Number} & Test & {id : Number}\n\ntype Test = {\n  name: String <~ {label: \"Label for Test.name\"}\n} <~ {label : \"Label for Test\"}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            Component outer = (Component)Mockito.mock(Component.class);
            String serviceName = "testService";
            String typeName = "TestType";
            ComponentPath path = ComponentPath.fromTopDown((String)"testService#SERVICE/myObject#OBJECT/myField#PROPERTY_TYPE");
            this.patch.getServicePatch(serviceName).softIntersectionResolution().add(path);
            Mockito.when((Object)PatchTest.this.componentRegistry.getServiceComponent()).thenReturn((Object)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name(serviceName)).build());
            Mockito.when((Object)PatchTest.this.componentRegistry.getPath(outer)).thenReturn((Object)path);
            Component newComponent = (Component)Mockito.mock(Component.class);
            Mockito.when((Object)PatchTest.this.typeFactory.make((DWType)ArgumentMatchers.any(WeaveType.class), ArgumentMatchers.anyString(), (Component)ArgumentMatchers.any(Component.class))).thenReturn((Object)newComponent);
            Assertions.assertTrue((boolean)this.patch.shouldApplySoftIntersectionResolution(outer, PatchTest.this.typeFactory), (String)"should be true because the path is in the softIntersectionResolution set");
        }
    }

    @Nested
    @DisplayName(value="Dereference Patching")
    class DereferencePatching {
        private final Patch patch = Patch.fromResource((String)"patch.json");

        DereferencePatching() {
        }

        @Test
        @DisplayName(value="GIVEN no 'dereference' patch for shortName WHEN patchDereference is called THEN returns empty")
        public void testPatchDereferenceWithNoMatchingShortName() {
            Component outer = (Component)Mockito.mock(Component.class);
            String shortName = "referenceTypeShortName";
            String serviceName = "testService";
            ComponentPath path = ComponentPath.fromTopDown((String)"testService#SERVICE/myObject#OBJECT/myField#PROPERTY_TYPE");
            this.patch.getServicePatch(serviceName).dereferences().put("anotherReferenceTypeShortName", Set.of(path));
            Mockito.when((Object)PatchTest.this.componentRegistry.getServiceComponent()).thenReturn((Object)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name(serviceName)).build());
            Mockito.when((Object)PatchTest.this.componentRegistry.getPath(outer)).thenReturn((Object)path);
            Assertions.assertFalse((boolean)this.patch.shouldExplodeReferenceType(shortName, outer, PatchTest.this.typeFactory), (String)"should be falsebecause no dereference patch is defined");
        }

        @Test
        @DisplayName(value="GIVEN a 'dereference' patch WHEN path is not in the set THEN returns empty")
        public void testPatchDereferenceWithNonMatchingPath() {
            Component outer = (Component)Mockito.mock(Component.class);
            String shortName = "referenceTypeShortName";
            String serviceName = "testService";
            ComponentPath path = ComponentPath.fromTopDown((String)"testService#SERVICE/myObject#OBJECT/myField#PROPERTY_TYPE");
            this.patch.getServicePatch(serviceName).dereferences().put(shortName, Set.of(path));
            ComponentPath differentPath = ComponentPath.fromTopDown((String)"testService#SERVICE/differentObject#OBJECT/myField#PROPERTY_TYPE");
            Mockito.when((Object)PatchTest.this.componentRegistry.getServiceComponent()).thenReturn((Object)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name(serviceName)).build());
            Mockito.when((Object)PatchTest.this.componentRegistry.getPath(outer)).thenReturn((Object)differentPath);
            Assertions.assertFalse((boolean)this.patch.shouldExplodeReferenceType(shortName, outer, PatchTest.this.typeFactory), (String)"should be false because no dereference patch is defined");
        }

        @Test
        @DisplayName(value="GIVEN a 'dereference' patch WHEN path is in the set THEN returns new component")
        public void testPatchDereferenceWithMatchingPath() {
            Component outer = (Component)Mockito.mock(Component.class);
            String shortName = "referenceTypeShortName";
            String serviceName = "testService";
            ComponentPath path = ComponentPath.fromTopDown((String)"testService#SERVICE/myObject#OBJECT/myField#PROPERTY_TYPE");
            this.patch.getServicePatch(serviceName).dereferences().put("referenceTypeShortName", Set.of(path));
            Mockito.when((Object)PatchTest.this.componentRegistry.getServiceComponent()).thenReturn((Object)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name(serviceName)).build());
            Mockito.when((Object)PatchTest.this.componentRegistry.getPath(outer)).thenReturn((Object)path);
            Component newComponent = (Component)Mockito.mock(Component.class);
            Mockito.when((Object)PatchTest.this.typeFactory.make((DWType)ArgumentMatchers.any(WeaveType.class), ArgumentMatchers.anyString(), (Component)ArgumentMatchers.any(Component.class))).thenReturn((Object)newComponent);
            ReferenceType referenceType = (ReferenceType)Mockito.mock(ReferenceType.class);
            Mockito.when((Object)referenceType.resolveType()).thenReturn((Object)((WeaveType)Mockito.mock(WeaveType.class)));
            Assertions.assertTrue((boolean)this.patch.shouldExplodeReferenceType(shortName, outer, PatchTest.this.typeFactory), (String)"should be true because dereference patch is defined");
        }
    }
}

