/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.model;

import com.mulesoft.connectivity.flow.internal.servicemodel.model.ComponentType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class ComponentTypeTest {
    @Test
    @DisplayName(value="fromValue should return the correct ComponentType for valid values")
    void testFromValueWithValidValues() {
        Assertions.assertEquals((Object)ComponentType.ARRAY, (Object)ComponentType.fromValue((String)"ListDataType"));
        Assertions.assertEquals((Object)ComponentType.IN_PARAMETER, (Object)ComponentType.fromValue((String)"InParameter"));
        Assertions.assertEquals((Object)ComponentType.OBJECT, (Object)ComponentType.fromValue((String)"ObjectDataType"));
        Assertions.assertEquals((Object)ComponentType.OPERATION, (Object)ComponentType.fromValue((String)"Operation"));
        Assertions.assertEquals((Object)ComponentType.OUT_PARAMETER, (Object)ComponentType.fromValue((String)"OutParameter"));
        Assertions.assertEquals((Object)ComponentType.PARAMETER_TYPE, (Object)ComponentType.fromValue((String)"ParameterType"));
        Assertions.assertEquals((Object)ComponentType.PRIMITIVE_TYPE, (Object)ComponentType.fromValue((String)"PrimitiveDataType"));
        Assertions.assertEquals((Object)ComponentType.PROPERTY_TYPE, (Object)ComponentType.fromValue((String)"Property"));
        Assertions.assertEquals((Object)ComponentType.SERVICE, (Object)ComponentType.fromValue((String)"Service"));
    }

    @Test
    @DisplayName(value="fromValue should return null for invalid values")
    void testFromValueWithInvalidValues() {
        Assertions.assertNull((Object)ComponentType.fromValue((String)"InvalidValue"));
        Assertions.assertNull((Object)ComponentType.fromValue((String)""));
        Assertions.assertNull((Object)ComponentType.fromValue((String)"ARRAY"));
        Assertions.assertNull((Object)ComponentType.fromValue((String)"listdatatype"));
        Assertions.assertNull((Object)ComponentType.fromValue((String)"ListDatatype"));
    }

    @Test
    @DisplayName(value="fromValue should return null for null value")
    void testFromValueWithNullValue() {
        Assertions.assertNull((Object)ComponentType.fromValue(null));
    }

    @Test
    @DisplayName(value="getValue should return the correct value for each ComponentType")
    void testGetValueForAllComponentTypes() {
        Assertions.assertEquals((Object)"ListDataType", (Object)ComponentType.ARRAY.getValue());
        Assertions.assertEquals((Object)"InParameter", (Object)ComponentType.IN_PARAMETER.getValue());
        Assertions.assertEquals((Object)"ObjectDataType", (Object)ComponentType.OBJECT.getValue());
        Assertions.assertEquals((Object)"Operation", (Object)ComponentType.OPERATION.getValue());
        Assertions.assertEquals((Object)"OutParameter", (Object)ComponentType.OUT_PARAMETER.getValue());
        Assertions.assertEquals((Object)"ParameterType", (Object)ComponentType.PARAMETER_TYPE.getValue());
        Assertions.assertEquals((Object)"PrimitiveDataType", (Object)ComponentType.PRIMITIVE_TYPE.getValue());
        Assertions.assertEquals((Object)"Property", (Object)ComponentType.PROPERTY_TYPE.getValue());
        Assertions.assertEquals((Object)"Service", (Object)ComponentType.SERVICE.getValue());
    }

    @Test
    @DisplayName(value="All ComponentTypes should have unique values")
    void testAllComponentTypesHaveUniqueValues() {
        ComponentType[] allTypes = ComponentType.values();
        Assertions.assertEquals((int)9, (int)allTypes.length, (String)"Should have exactly 9 ComponentTypes");
        for (ComponentType type : allTypes) {
            Assertions.assertEquals((Object)type, (Object)ComponentType.fromValue((String)type.getValue()), (String)("fromValue should return the same ComponentType for value: " + type.getValue()));
        }
    }

    @Test
    @DisplayName(value="ComponentType enum should contain all expected types")
    void testAllExpectedComponentTypesExist() {
        ComponentType[] allTypes = ComponentType.values();
        Assertions.assertTrue((boolean)this.containsType(allTypes, ComponentType.ARRAY));
        Assertions.assertTrue((boolean)this.containsType(allTypes, ComponentType.IN_PARAMETER));
        Assertions.assertTrue((boolean)this.containsType(allTypes, ComponentType.OBJECT));
        Assertions.assertTrue((boolean)this.containsType(allTypes, ComponentType.OPERATION));
        Assertions.assertTrue((boolean)this.containsType(allTypes, ComponentType.OUT_PARAMETER));
        Assertions.assertTrue((boolean)this.containsType(allTypes, ComponentType.PARAMETER_TYPE));
        Assertions.assertTrue((boolean)this.containsType(allTypes, ComponentType.PRIMITIVE_TYPE));
        Assertions.assertTrue((boolean)this.containsType(allTypes, ComponentType.PROPERTY_TYPE));
        Assertions.assertTrue((boolean)this.containsType(allTypes, ComponentType.SERVICE));
    }

    private boolean containsType(ComponentType[] types, ComponentType targetType) {
        for (ComponentType type : types) {
            if (type != targetType) continue;
            return true;
        }
        return false;
    }
}

