/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder;

import com.mulesoft.connectivity.flow.fixtures.QueryBuilderTestUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder.QueryBuilderParameterBinding;
import com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder.QueryBuilderSupport;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

@DisplayName(value="QueryBuilderSupport")
public class QueryBuilderSupportTest {
    private QueryBuilderSupport queryBuilderSupport;

    @BeforeEach
    void setUp() {
        this.queryBuilderSupport = new QueryBuilderSupport();
    }

    @Test
    @DisplayName(value="GIVEN field with @FieldSelector annotation WHEN processing parameter annotations THEN creates correct binding")
    void testProcessParameterAnnotationsWithFieldSelector() {
        String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\ntype TestType = {\n    projectedFields: @FieldSelector() Array<String>\n}\n---\nTestType\n";
        DWType compiledType = QueryBuilderTestUtils.compileScript(script);
        KeyValuePairType fieldType = this.getFieldFromType(compiledType, "projectedFields");
        QueryBuilderParameterBinding result = this.queryBuilderSupport.processParameterAnnotations(fieldType);
        Assertions.assertNotNull((Object)result, (String)"Parameter binding should be created");
        Assertions.assertTrue((boolean)result.isFieldSelector(), (String)"Should detect FieldSelector annotation");
        Assertions.assertFalse((boolean)result.isFilter(), (String)"Should not detect ResultSetFilter annotation");
    }

    @Test
    @DisplayName(value="GIVEN field with @ResultSetFilter annotation WHEN processing parameter annotations THEN creates correct binding")
    void testProcessParameterAnnotationsWithResultSetFilter() {
        String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\ntype TestType = {\n    filter: @ResultSetFilter() String\n}\n---\nTestType\n";
        DWType compiledType = QueryBuilderTestUtils.compileScript(script);
        KeyValuePairType fieldType = this.getFieldFromType(compiledType, "filter");
        QueryBuilderParameterBinding result = this.queryBuilderSupport.processParameterAnnotations(fieldType);
        Assertions.assertNotNull((Object)result, (String)"Parameter binding should be created");
        Assertions.assertFalse((boolean)result.isFieldSelector(), (String)"Should not detect FieldSelector annotation");
        Assertions.assertTrue((boolean)result.isFilter(), (String)"Should detect ResultSetFilter annotation");
    }

    @Test
    @DisplayName(value="GIVEN field with @FieldSelector annotation WHEN processing property annotations THEN creates correct binding")
    void testProcessPropertyAnnotationsWithFieldSelector() {
        String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\ntype TestType = {\n    projectedFields: @FieldSelector() Array<String>\n}\n---\nTestType\n";
        DWType compiledType = QueryBuilderTestUtils.compileScript(script);
        KeyValuePairType fieldType = this.getFieldFromType(compiledType, "projectedFields");
        QueryBuilderParameterBinding result = this.queryBuilderSupport.processPropertyAnnotations(fieldType);
        Assertions.assertNotNull((Object)result, (String)"Property binding should be created");
        Assertions.assertTrue((boolean)result.isFieldSelector(), (String)"Should detect FieldSelector annotation");
        Assertions.assertFalse((boolean)result.isFilter(), (String)"Should not detect ResultSetFilter annotation");
    }

    @Test
    @DisplayName(value="GIVEN field with @ResultSetFilter annotation WHEN checking isAnnotationResultSetFilter THEN returns true")
    void testIsAnnotationResultSetFilterWithAnnotation() {
        String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.resultSetFilter\")\nannotation ResultSetFilter(value: {} = {})\n\ntype TestType = {\n    filter: @ResultSetFilter() String\n}\n---\nTestType\n";
        DWType compiledType = QueryBuilderTestUtils.compileScript(script);
        KeyValuePairType fieldType = this.getFieldFromType(compiledType, "filter");
        boolean result = this.queryBuilderSupport.isAnnotationResultSetFilter(fieldType);
        Assertions.assertTrue((boolean)result, (String)"Should detect ResultSetFilter annotation");
    }

    @Test
    @DisplayName(value="GIVEN field without @ResultSetFilter annotation WHEN checking isAnnotationResultSetFilter THEN returns false")
    void testIsAnnotationResultSetFilterWithoutAnnotation() {
        String script = "%dw 2.8\n\ntype TestType = {\n    regularField: String\n}\n---\nTestType\n";
        DWType compiledType = QueryBuilderTestUtils.compileScript(script);
        KeyValuePairType fieldType = this.getFieldFromType(compiledType, "regularField");
        boolean result = this.queryBuilderSupport.isAnnotationResultSetFilter(fieldType);
        Assertions.assertFalse((boolean)result, (String)"Should not detect ResultSetFilter annotation on regular field");
    }

    @Test
    @DisplayName(value="GIVEN field with @FieldSelector annotation WHEN checking isAnnotationFieldSelector THEN returns true")
    void testIsAnnotationFieldSelectorWithAnnotation() {
        String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\ntype TestType = {\n    projectedFields: @FieldSelector() Array<String>\n}\n---\nTestType\n";
        DWType compiledType = QueryBuilderTestUtils.compileScript(script);
        KeyValuePairType fieldType = this.getFieldFromType(compiledType, "projectedFields");
        boolean result = this.queryBuilderSupport.isAnnotationFieldSelector(fieldType);
        Assertions.assertTrue((boolean)result, (String)"Should detect FieldSelector annotation");
    }

    @Test
    @DisplayName(value="GIVEN field without @FieldSelector annotation WHEN checking isAnnotationFieldSelector THEN returns false")
    void testIsAnnotationFieldSelectorWithoutAnnotation() {
        String script = "%dw 2.8\n\ntype TestType = {\n    regularField: String\n}\n---\nTestType\n";
        DWType compiledType = QueryBuilderTestUtils.compileScript(script);
        KeyValuePairType fieldType = this.getFieldFromType(compiledType, "regularField");
        boolean result = this.queryBuilderSupport.isAnnotationFieldSelector(fieldType);
        Assertions.assertFalse((boolean)result, (String)"Should not detect FieldSelector annotation on regular field");
    }

    @Test
    @DisplayName(value="GIVEN null field type WHEN processing annotations THEN returns false")
    void testAnnotationDetectionWithNullInput() {
        Assertions.assertFalse((boolean)this.queryBuilderSupport.isAnnotationResultSetFilter(null), (String)"Should return false for null input");
        Assertions.assertFalse((boolean)this.queryBuilderSupport.isAnnotationFieldSelector(null), (String)"Should return false for null input");
    }

    @Test
    @DisplayName(value="GIVEN field with @FieldSelector annotation WHEN making parameter discriminator THEN returns empty list for simple types")
    void testMakeParameterDiscriminatorWithSimpleFieldSelector() {
        String script = "%dw 2.8\n\n@AnnotationTarget(targets = [\"TypeExpression\"])\n@Metadata(key = \"flow.fieldSelector\")\nannotation FieldSelector(value: {} = {})\n\ntype TestType = {\n    projectedFields: @FieldSelector() Array<String>\n}\n---\nTestType\n";
        DWType compiledType = QueryBuilderTestUtils.compileScript(script);
        KeyValuePairType fieldType = this.getFieldFromType(compiledType, "projectedFields");
        List result = this.queryBuilderSupport.makeParameterDiscriminator(fieldType);
        Assertions.assertNotNull((Object)result, (String)"Result should not be null");
        Assertions.assertTrue((boolean)result.isEmpty(), (String)"Should return empty list for simple FieldSelector types");
    }

    private KeyValuePairType getFieldFromType(DWType compiledType, String fieldName) {
        if (compiledType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)compiledType;
            return Arrays.stream(objectType.getProperties()).filter(prop -> fieldName.equals(prop.getKeyName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Field '" + fieldName + "' not found in type"));
        }
        throw new IllegalArgumentException("Compiled type is not an ObjectType");
    }
}

