/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.serializer;

import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceModel;
import com.mulesoft.connectivity.flow.internal.servicemodel.serializer.ServiceModelSerializer;
import com.mulesoft.connectivity.flow.internal.servicemodel.serializer.r256.serializer.R256Serializer;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringPropertySerializationTest {
    private final ServiceModelSerializer serializer = new R256Serializer();

    @Test
    public void testSerializeEmptyString() {
        ServiceComponent serviceComponent = ((ServiceComponent.ServiceComponentBuilder)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("")).id("1")).build();
        ServiceModel serviceModel = ServiceModel.builder().components(Collections.singletonList(serviceComponent)).build();
        StringWriter writer = new StringWriter();
        R256Serializer r256Serializer = new R256Serializer();
        r256Serializer.serialize(serviceModel, (Writer)writer);
        String json = writer.toString();
        Assertions.assertEquals((Object)"{\"components\":[{\"componentType\":\"Service\",\"id\":\"1\"}]}", (Object)json.replaceAll("\\s+", ""));
        writer = new StringWriter();
        this.serializer.serialize(serviceModel, (Writer)writer);
        json = writer.toString();
        Assertions.assertEquals((Object)"{\"components\":[{\"componentType\":\"Service\",\"id\":\"1\"}]}", (Object)json.replaceAll("\\s+", ""));
    }

    @Test
    public void testSerializeNonEmptyString() {
        ServiceComponent serviceComponent = ((ServiceComponent.ServiceComponentBuilder)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("test")).id("1")).build();
        ServiceModel serviceModel = ServiceModel.builder().components(Collections.singletonList(serviceComponent)).build();
        StringWriter writer = new StringWriter();
        R256Serializer r256Serializer = new R256Serializer();
        r256Serializer.serialize(serviceModel, (Writer)writer);
        String json = writer.toString();
        Assertions.assertEquals((Object)"{\"components\":[{\"name\":\"test\",\"componentType\":\"Service\",\"id\":\"1\"}]}", (Object)json.replaceAll("\\s+", ""));
        writer = new StringWriter();
        this.serializer.serialize(serviceModel, (Writer)writer);
        json = writer.toString();
        Assertions.assertEquals((Object)"{\"components\":[{\"name\":\"test\",\"componentType\":\"Service\",\"id\":\"1\"}]}", (Object)json.replaceAll("\\s+", ""));
    }

    @Test
    public void testSerializeNullString() {
        ServiceComponent serviceComponent = ((ServiceComponent.ServiceComponentBuilder)((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name(null)).id("1")).build();
        ServiceModel serviceModel = ServiceModel.builder().components(Collections.singletonList(serviceComponent)).build();
        StringWriter writer = new StringWriter();
        R256Serializer r256Serializer = new R256Serializer();
        r256Serializer.serialize(serviceModel, (Writer)writer);
        String json = writer.toString();
        Assertions.assertEquals((Object)"{\"components\":[{\"componentType\":\"Service\",\"id\":\"1\"}]}", (Object)json.replaceAll("\\s+", ""));
        writer = new StringWriter();
        this.serializer.serialize(serviceModel, (Writer)writer);
        json = writer.toString();
        Assertions.assertEquals((Object)"{\"components\":[{\"componentType\":\"Service\",\"id\":\"1\"}]}", (Object)json.replaceAll("\\s+", ""));
    }
}

