/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.persistence;

import com.mulesoft.connectivity.flow.api.model.FlowBaseConnectorModel;
import com.mulesoft.connectivity.flow.api.persistence.AuthenticationTypeDeserializer;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;

public class FlowBasicModelDeserializer {
    private static final String NAME_PROPERTY = "name";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private static final String MODEL_REFERENCE_PROPERTY = "modelReference";
    private static final String CONNECTIONS_PROPERTY = "connections";
    private static final String TEST_CONNECTION_PROPERTY = "testConnection";
    private static final String OPERATIONS_PROPERTY = "operations";
    private static final String TRIGGERS_PROPERTY = "triggers";
    private static final String AUTHENTICATION_TYPE_PROPERTY = "authenticationType";
    private static final String IS_PAGINATED_PROPERTY = "isPaginated";

    public synchronized FlowBaseConnectorModel<?, ?, ?> deserialize(Map<?, ?> serialized) {
        return ((FlowBaseConnectorModel.Builder)((Object)((FlowBaseConnectorModel.Builder)((Object)((FlowBaseConnectorModel.Builder)((Object)((FlowBaseConnectorModel.Builder)((Object)((FlowBaseConnectorModel.Builder)((FlowBaseConnectorModel.Builder)((FlowBaseConnectorModel.Builder)new FlowBaseConnectorModel.Builder().withName(this.requireProperty(serialized, NAME_PROPERTY, String.class))).withDisplayName(this.requireProperty(serialized, DISPLAY_NAME_PROPERTY, String.class))).withModelReference((String)this.getProperty(serialized, MODEL_REFERENCE_PROPERTY))).withConnections(this.deserializeConnections((List)this.getProperty(serialized, CONNECTIONS_PROPERTY))))).withTestConnection(this.deserializeTestConnection((Map)this.getProperty(serialized, TEST_CONNECTION_PROPERTY))))).withOperations(this.deserializeOperations(this.requireProperty(serialized, OPERATIONS_PROPERTY, List.class))))).withTriggers(this.deserializeTriggers((List)this.getProperty(serialized, TRIGGERS_PROPERTY))))).build();
    }

    private @Nullable TestConnectionModel deserializeTestConnection(@Nullable Map<String, Object> serialized) {
        if (serialized != null) {
            return (TestConnectionModel)((TestConnectionModel.Builder)new TestConnectionModel.Builder().withModelReference((String)this.getProperty(serialized, MODEL_REFERENCE_PROPERTY))).build();
        }
        return null;
    }

    private List<BaseExecutableComponentModel<?>> deserializeOperations(List<?> serializedOperations) {
        return serializedOperations.stream().map(o -> this.deserializeOperation((Map)o)).toList();
    }

    private BaseExecutableComponentModel<?> deserializeOperation(Map<?, ?> serializedOperation) {
        BaseExecutableComponentModel.ExecutableComponentBuilder builder = new BaseExecutableComponentModel.ExecutableComponentBuilder();
        this.deserializeExecutableComponent(serializedOperation, builder);
        return (BaseExecutableComponentModel)builder.build();
    }

    private void deserializeExecutableComponent(Map<?, ?> serializedOperation, BaseExecutableComponentModel.ExecutableComponentBuilder builder) {
        String name = this.requireProperty(serializedOperation, NAME_PROPERTY, String.class);
        ((BaseExecutableComponentModel.ExecutableComponentBuilder)((BaseExecutableComponentModel.ExecutableComponentBuilder)((BaseExecutableComponentModel.ExecutableComponentBuilder)builder.withName(name)).withModelReference((String)this.getProperty(serializedOperation, MODEL_REFERENCE_PROPERTY))).withIsPaginated(this.requireProperty(serializedOperation, IS_PAGINATED_PROPERTY, Boolean.class).booleanValue())).withIsBase(true);
        Object extraVersionsObject = this.getProperty(serializedOperation, "extraVersions");
        if (extraVersionsObject != null) {
            TreeMap extraVersions = new TreeMap();
            Map extraVersionsMap = (Map)extraVersionsObject;
            BaseExecutableComponentModel.ExecutableComponentBuilder implementationBuilder = new BaseExecutableComponentModel.ExecutableComponentBuilder();
            implementationBuilder.withIsBase(false);
            implementationBuilder.withName(name);
            extraVersionsMap.forEach((version, versionObject) -> {
                Map versionMap = (Map)versionObject;
                int versionNumber = version instanceof String ? Integer.parseInt((String)version) : ((Number)version).intValue();
                implementationBuilder.withIsPaginated(this.requireProperty(versionMap, IS_PAGINATED_PROPERTY, Boolean.class).booleanValue());
                implementationBuilder.withModelReference(this.requireProperty(versionMap, MODEL_REFERENCE_PROPERTY, String.class));
                extraVersions.put(versionNumber, (BaseExecutableComponentModel)implementationBuilder.build());
            });
            builder.withVersions(extraVersions);
        }
    }

    private List<BaseExecutableComponentModel<?>> deserializeTriggers(@Nullable List<?> serializedTriggers) {
        return Objects.requireNonNullElse(serializedTriggers, List.of()).stream().map(m -> this.deserializeTrigger((Map)m)).toList();
    }

    private BaseExecutableComponentModel<?> deserializeTrigger(Map<?, ?> serializedTrigger) {
        BaseExecutableComponentModel.ExecutableComponentBuilder builder = new BaseExecutableComponentModel.ExecutableComponentBuilder();
        this.deserializeExecutableComponent(serializedTrigger, builder);
        return (BaseExecutableComponentModel)builder.build();
    }

    private List<BaseConnectionProviderModel> deserializeConnections(@Nullable List<Map<String, Object>> serializedConnections) {
        if (serializedConnections == null) {
            return List.of();
        }
        return serializedConnections.stream().map(serializedConnection -> (BaseConnectionProviderModel)((BaseConnectionProviderModel.Builder)((BaseConnectionProviderModel.Builder)((BaseConnectionProviderModel.Builder)new BaseConnectionProviderModel.Builder().withModelReference((String)this.getProperty((Map<?, ?>)serializedConnection, MODEL_REFERENCE_PROPERTY))).authenticationType(new AuthenticationTypeDeserializer().deserializeAuthenticationType(this.requireProperty((Map<?, ?>)serializedConnection, AUTHENTICATION_TYPE_PROPERTY, (Class)Map.class)))).testConnection(this.deserializeTestConnection((Map)this.getProperty((Map<?, ?>)serializedConnection, TEST_CONNECTION_PROPERTY)))).build()).toList();
    }

    private <T> @Nullable T getProperty(Map<?, ?> map, String property) {
        return (T)map.get(property);
    }

    private <T> T requireProperty(Map<?, ?> map, String property, Class<T> expectedClass) {
        Object o = map.get(property);
        if (o == null) {
            throw new NullPointerException("Missing property '" + property + "' while deserializing.");
        }
        if (!expectedClass.isInstance(o)) {
            throw new IllegalArgumentException("Expecting property '" + property + "' while deserializing to be " + expectedClass.getSimpleName() + ", but was " + o.getClass().getSimpleName());
        }
        return expectedClass.cast(o);
    }
}

