/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.validation.ConnectorValidationAnnotationProcessor;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.DynamicModuleComponentFactory;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.ParserConfiguration;
import org.mule.weave.v2.runtime.ParserConfigurationBuilder;
import scala.Option;

class ConnectorValidationAnnotationProcessorTest {
    ConnectorValidationAnnotationProcessorTest() {
    }

    @Test
    void executesValidators() {
        ValidationConfiguration validationConfiguration = ValidationConfiguration.withRuleClasses((Class[])new Class[]{Rule1.class, Rule2.class});
        ParserConfiguration parserConfiguration = new ParserConfigurationBuilder().addAnnotationProcessor(NameIdentifier.apply((String)"com::mulesoft::connectivity::flow::Metadata::FlowConnectorElement", (Option)Option.empty()), (DWAnnotationProcessor)new ConnectorValidationAnnotationProcessor(validationConfiguration)).build();
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)DynamicModuleComponentFactory.apply(), parserConfiguration);
        dataWeaveEngine.compile("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    operations: {testOperation: {}},\n    triggers: {testTrigger: {}},\n    valueProviders: {testValueProvider: {}},\n}--- \"test\"");
        MatcherAssert.assertThat((Object)Rule1.ran, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Rule2.ran, (Matcher)Matchers.is((Object)true));
    }

    public static class Rule1
    extends Rule<DWType> {
        static boolean ran = false;

        public Rule1() {
            super(DWType.class);
        }

        protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
            ran = true;
        }
    }

    public static class Rule2
    extends Rule<DWType> {
        static boolean ran = false;

        public Rule2() {
            super(DWType.class);
        }

        protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
            ran = true;
        }
    }
}

