/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ArrayTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.R256TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandlerTestUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ArrayTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.TypeType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.WeaveType;

public class ArrayTypeHandlerTest {
    private final DataWeaveScriptingEngine engine = new DataWeaveScriptingEngine();

    @Test
    @DisplayName(value="GIVEN an Array<String> with a description in its inner type WHEN called to make THEN the description is neither on the List nor the property type")
    public void testDescriptionIsNotAssignedToTheType() {
        String script = "%dw 2.8\ntype Root = Array<String> <~ {description: \"the description\"}\n---\nRoot\n";
        WeaveType weaveType = (WeaveType)this.engine.inferTypeOf(script).get();
        DWType dwType = ((TypeType)weaveType).getType();
        ComponentRegistry componentRegistry = new ComponentRegistry();
        R256TypeFactory typeFactory = new R256TypeFactory(componentRegistry, Patch.fromResource((String)"patch.json"));
        ServiceComponent serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
        componentRegistry.registerComponent((Component)serviceComponent);
        ArrayTypeHandler arrayTypeHandler = new ArrayTypeHandler(componentRegistry);
        ArrayTypeComponent actualComponent = (ArrayTypeComponent)arrayTypeHandler.make(dwType, "Root", null, (TypeFactory)typeFactory);
        Component primitiveType = TypeHandlerTestUtils.findById(actualComponent.getElementType(), componentRegistry.getComponents());
        Assertions.assertNull((Object)actualComponent.getDescription(), (String)"Array description should be null");
        Assertions.assertNull((Object)primitiveType.getDescription(), (String)"Primitive (the String inside Array<String>) description should be null");
        System.out.println(actualComponent);
    }
}

