/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.persistence;

import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ImplicitAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2PasswordAuthenticationType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class AuthenticationTypeDeserializer {
    private static final String REFRESH_URL = "refreshUrl";
    private static final String SCOPES = "scopes";
    private static final String AUTHORIZATION_URL = "authorizationUrl";
    private static final String TOKEN_URL = "tokenUrl";
    private static final String IN = "in";
    private static final String NAME = "name";
    private static final String TYPE_PROPERTY = "type";
    private static final String SUB_TYPE_PROPERTY = "subType";

    public AuthenticationType deserializeAuthenticationType(Map<?, ?> authenticationType) {
        String type = this.requireProperty(authenticationType, TYPE_PROPERTY, String.class);
        String subType = (String)this.getProperty(authenticationType, SUB_TYPE_PROPERTY);
        switch (HttpAuthenticationType.Type.fromString((String)type)) {
            case oauth2: {
                String refreshUrl = (String)this.getProperty(authenticationType, REFRESH_URL);
                List scopes = this.requireProperty(authenticationType, SCOPES, List.class);
                return switch (OAuth2AuthenticationType.GrantType.fromString((String)Objects.requireNonNull(subType, "oauth requires a subtype"))) {
                    default -> throw new IncompatibleClassChangeError();
                    case OAuth2AuthenticationType.GrantType.authorizationCode -> new OAuth2AuthCodeAuthenticationType(refreshUrl, scopes, this.requireProperty(authenticationType, AUTHORIZATION_URL, String.class), this.requireProperty(authenticationType, TOKEN_URL, String.class));
                    case OAuth2AuthenticationType.GrantType.clientCredentials -> new OAuth2ClientCredentialsAuthenticationType(refreshUrl, scopes, this.requireProperty(authenticationType, TOKEN_URL, String.class));
                    case OAuth2AuthenticationType.GrantType.implicit -> new OAuth2ImplicitAuthenticationType(refreshUrl, scopes, this.requireProperty(authenticationType, AUTHORIZATION_URL, String.class));
                    case OAuth2AuthenticationType.GrantType.password -> new OAuth2PasswordAuthenticationType(refreshUrl, scopes, this.requireProperty(authenticationType, TOKEN_URL, String.class));
                };
            }
            case apiKey: {
                String in = this.requireProperty(authenticationType, IN, String.class);
                String name = this.requireProperty(authenticationType, NAME, String.class);
                return new ApiKeyHttpAuthenticationType(subType, ApiKeyHttpAuthenticationType.In.fromString((String)in), name);
            }
        }
        return new HttpAuthenticationType(HttpAuthenticationType.Type.fromString((String)type), subType);
    }

    private <T> @Nullable T getProperty(Map<?, ?> map, String property) {
        return (T)map.get(property);
    }

    private <T> T requireProperty(Map<?, ?> map, String property, Class<T> expectedClass) {
        Object o = map.get(property);
        if (o == null) {
            throw new NullPointerException("Missing property '" + property + "' while deserializing.");
        }
        if (!expectedClass.isInstance(o)) {
            throw new IllegalArgumentException("Expecting property '" + property + "' while deserializing to be " + expectedClass.getSimpleName() + ", but was " + o.getClass().getSimpleName());
        }
        return expectedClass.cast(o);
    }
}

