/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformation;
import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformationFactory;
import com.mulesoft.connectivity.flow.internal.connection.Connections;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionsFactory {
    private final ConnectionInputTypeInformationFactory connectionInputTypeInformationFactory;

    public static ConnectionsFactory create() {
        return new ConnectionsFactory(new ConnectionInputTypeInformationFactory());
    }

    ConnectionsFactory(ConnectionInputTypeInformationFactory connectionInputTypeInformationFactory) {
        this.connectionInputTypeInformationFactory = connectionInputTypeInformationFactory;
    }

    public Connections fromConnectorModel(String connectorName, List<ConnectionProviderModel> connectionProviders) {
        return new Connections(this.inputTypesInformation(connectionProviders), this.getAuthListFromConnectorModel(connectorName, connectionProviders));
    }

    private List<ConnectionInputTypeInformation> inputTypesInformation(List<ConnectionProviderModel> connectionProviders) {
        return connectionProviders.stream().map(this.connectionInputTypeInformationFactory::createConnectionInputTypeInformation).toList();
    }

    private List<Map<String, Object>> getAuthListFromConnectorModel(String connectorName, List<ConnectionProviderModel> connectionProviders) {
        ArrayList<Map<String, Object>> authConnectorInfoList = new ArrayList<Map<String, Object>>();
        List<AuthenticationType> authTypesFromConnection = connectionProviders.stream().map(BaseConnectionProviderModel::getAuthenticationType).toList();
        for (AuthenticationType auth : authTypesFromConnection) {
            if (!(auth instanceof HttpAuthenticationType)) continue;
            HttpAuthenticationType httpAuth = (HttpAuthenticationType)auth;
            HashMap<String, String> authConnectorInfo = new HashMap<String, String>();
            authConnectorInfo.put("type", httpAuth.getType().name());
            authConnectorInfo.put("subType", httpAuth.getSubType().orElse(null));
            authConnectorInfoList.add(authConnectorInfo);
        }
        return authConnectorInfoList;
    }
}

