/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.validation.ConnectorValidationAnnotationProcessor;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Triple;
import org.hamcrest.CoreMatchers;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.provider.Arguments;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.api.tooling.message.ValidationMessage;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.ModuleParser;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.phase.CompilationPhase;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.ParsingContextFactory;
import org.mule.weave.v2.sdk.WeaveResource;
import scala.Option;

public abstract class AbstractValidatorTest {
    private final ParsingContext strictParsingContext = this.createParsingContext(true);
    private final ParsingContext nonStrictParsingContext = this.createParsingContext(false);

    protected abstract ValidationConfiguration getValidationConfiguration();

    protected CollectedMessages parseModule(boolean strictMode, String script) {
        ParsingContext parsingContext = strictMode ? this.strictParsingContext : this.nonStrictParsingContext;
        PhaseResult result = ModuleParser.parse((CompilationPhase)ModuleParser.typeCheckPhase(), (WeaveResource)WeaveResource.anonymous((String)script), (ParsingContext)parsingContext.withMessageCollector(MessageCollector.apply()));
        MessageCollector messageCollector = result.messages();
        return new CollectedMessages(List.of(messageCollector.getErrorValidationMessages()), List.of(messageCollector.getWarningValidationMessages()));
    }

    private ParsingContext createParsingContext(boolean strictMode) {
        return ParsingContextFactory.createParsingContext((boolean)strictMode).registerAnnotationProcessor(NameIdentifier.apply((String)"com::mulesoft::connectivity::flow::Metadata::FlowConnectorElement", (Option)Option.empty()), (DWAnnotationProcessor)new ConnectorValidationAnnotationProcessor(this.getValidationConfiguration()));
    }

    protected CollectedMessages assertCompileSuccessful(String scriptContent) {
        CollectedMessages collectedMessages = this.parseModule(true, scriptContent);
        MatcherAssert.assertThat(collectedMessages.getErrors().stream().map(m -> m.getMessage().getMessage()).toList(), (Matcher)CoreMatchers.describedAs((String)"no validation errors", (Matcher)Matchers.empty(), (Object[])new Object[0]));
        return collectedMessages;
    }

    protected CollectedMessages assertCompileFailure(String scriptContent) {
        CollectedMessages collectedMessages = this.parseModule(false, scriptContent);
        if (collectedMessages.getErrors().isEmpty()) {
            Assertions.fail((String)"Script compilation was supposed to fail when validation operation");
        }
        return collectedMessages;
    }

    protected static void assertValidationMessage(List<ValidationMessage> validationMessages, List<Triple<String, String, String>> expectedMessages) {
        MatcherAssert.assertThat(validationMessages, (Matcher)Matchers.hasSize((int)expectedMessages.size()));
        validationMessages = new ArrayList<ValidationMessage>(validationMessages);
        validationMessages.sort(Comparator.comparing(vm -> vm.getMessage().getMessage()));
        expectedMessages = new ArrayList<Triple<String, String, String>>(expectedMessages);
        expectedMessages.sort(Comparator.comparing(Triple::getLeft));
        for (int x = 0; x < validationMessages.size(); ++x) {
            Triple<String, String, String> expected = expectedMessages.get(x);
            AbstractValidatorTest.assertValidationMessage(validationMessages.get(x), (String)expected.getLeft(), (String)expected.getMiddle(), (String)expected.getRight());
        }
    }

    protected static void assertValidationMessage(ValidationMessage validationMessage, String message, String kind, String locationText) {
        AbstractValidatorTest.assertValidationMessage(validationMessage, (Matcher<? super String>)CoreMatchers.equalTo((Object)message), kind, (Matcher<? super String>)CoreMatchers.equalTo((Object)locationText));
    }

    protected static void assertValidationMessage(ValidationMessage validationMessage, Matcher<? super String> messageMatcher, String kind, Matcher<? super String> locationTextMatcher) {
        MatcherAssert.assertThat((Object)validationMessage.getMessage().getMessage(), messageMatcher);
        MatcherAssert.assertThat((Object)validationMessage.getMessage().getKind(), (Matcher)CoreMatchers.equalTo((Object)kind));
        MatcherAssert.assertThat((Object)validationMessage.getLocation(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)validationMessage.getLocation().toStringRepresentation(), locationTextMatcher);
    }

    protected static Matcher<ValidationMessage> validationMessageMatcher(Matcher<String> messageMatcher, String kind, Matcher<String> locationTextMatcher) {
        return Matchers.allOf((Matcher)new FeatureMatcher<ValidationMessage, String>(messageMatcher, "message", "message"){

            protected String featureValueOf(ValidationMessage actual) {
                return actual.getMessage().getMessage();
            }
        }, (Matcher)new FeatureMatcher<ValidationMessage, String>(Matchers.equalTo((Object)kind), "kind", "kind"){

            protected String featureValueOf(ValidationMessage actual) {
                return actual.getMessage().getKind();
            }
        }, (Matcher)new FeatureMatcher<ValidationMessage, String>(locationTextMatcher, "location", "location"){

            protected String featureValueOf(ValidationMessage actual) {
                return actual.getLocation().toStringRepresentation();
            }
        });
    }

    static List<Arguments> getValidTypes() {
        return List.of(Arguments.of((Object[])new Object[]{"Boolean", "true"}), Arguments.of((Object[])new Object[]{"Number", "777"}), Arguments.of((Object[])new Object[]{"String", "\"foo\""}), Arguments.of((Object[])new Object[]{"DateTime", "|2003-10-01T23:57:59-08:00|"}), Arguments.of((Object[])new Object[]{"Date", "|2003-10-01-08:00|"}), Arguments.of((Object[])new Object[]{"Time", "|23:57:59-08:00|"}));
    }

    static List<UnsupportedTypeTestParam> getInvalidTypes() {
        return Stream.of("Any", "Binary", "LocalDateTime", "LocalTime", "Nothing", "Period", "Regex", "TimeZone", "Range", "() -> String").map(t -> new UnsupportedTypeTestParam.Builder((String)t).build()).toList();
    }

    static UnsupportedTypeTestParam[] getUnsupportedInputTypes() {
        ArrayList<UnsupportedTypeTestParam> result = new ArrayList<UnsupportedTypeTestParam>();
        AbstractValidatorTest.getInvalidTypes().stream().map(param -> new UnsupportedTypeTestParam.Builder(param.type).withReason("input", param.type).withReasons(param.reasons).build()).forEach(result::add);
        result.add(new UnsupportedTypeTestParam.Builder("Null").withReason("input", "Null").build());
        result.add(new UnsupportedTypeTestParam.Builder("Array<String>").withReason("input", "Array<String>").build());
        result.add(new UnsupportedTypeTestParam.Builder("Null | String").withReason("input", "Null | String").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property1: String } & { property2: Number }").withReason("input", "{ property1: String } & { property2: Number }").build());
        return result.toArray(new UnsupportedTypeTestParam[0]);
    }

    static List<Arguments> getValidArrayTypes() {
        List result = AbstractValidatorTest.getValidTypes().stream().map(arguments -> Arguments.of((Object[])new Object[]{"Array<" + String.valueOf(arguments.get()[0]) + ">", "[" + String.valueOf(arguments.get()[1]) + "]"})).collect(Collectors.toCollection(ArrayList::new));
        result.addAll(AbstractValidatorTest.getValidUnionTypes().stream().map(arguments -> Arguments.of((Object[])new Object[]{"Array<" + String.valueOf(arguments.get()[0]) + ">", "[" + String.valueOf(arguments.get()[1]) + "]"})).toList());
        result.addAll(AbstractValidatorTest.getValidIntersectionTypes().stream().map(arguments -> Arguments.of((Object[])new Object[]{"Array<" + String.valueOf(arguments.get()[0]) + ">", "[" + String.valueOf(arguments.get()[1]) + "]"})).toList());
        result.add(Arguments.of((Object[])new Object[]{"Array<{property: String}>", "[{property: \"foo\"}]"}));
        result.add(Arguments.of((Object[])new Object[]{"Array<Array<String>>", "[[\"foo\"]]"}));
        result.add(Arguments.of((Object[])new Object[]{"Array<Array<{property: String}>>", "[[{property: \"foo\"}]]"}));
        result.add(Arguments.of((Object[])new Object[]{"Array<Array<{property1: String} & {property2: Number}>>", "[[{property1: \"foo\", property2: 777}]]"}));
        return result;
    }

    private static List<UnsupportedTypeTestParam> getInvalidArrayTypes() {
        List<UnsupportedTypeTestParam> result = AbstractValidatorTest.getInvalidTypes().stream().map(param -> new UnsupportedTypeTestParam.Builder("Array<" + param.type + ">").withReason("[]", param.type).build()).collect(Collectors.toList());
        result.add(new UnsupportedTypeTestParam.Builder("Array<Null>").withReason("[]", "Null").build());
        AbstractValidatorTest.getInvalidUnionTypes().stream().map(param -> new UnsupportedTypeTestParam.Builder("Array<" + param.type + ">").withReasons(param.reasons.stream().map(r -> new Reason("[]" + (r.path.isEmpty() ? "" : ".") + r.path, r.reason)).toList()).build()).forEach(result::add);
        result.add(new UnsupportedTypeTestParam.Builder("Array<{ property: Any }>").withReason("[].property", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Array<Array<Any>>").withReason("[][]", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Array<Array<{ property: Any }>>").withReason("[][].property", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Array<{ property: Array<Any> }>").withReason("[].property[]", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Array<String | String>").withReason("[]", "String | String").build());
        result.add(new UnsupportedTypeTestParam.Builder("Array<Array<{ property1: Any } & { property2: Number }>>").withReason("[][].property1", "Any").build());
        return result;
    }

    static List<Arguments> getValidIntersectionTypes() {
        ArrayList<Arguments> result = new ArrayList<Arguments>();
        result.add(Arguments.of((Object[])new Object[]{"{property1: String} & {property2: Number}", "{property1: \"foo\", property2: 777}"}));
        return result;
    }

    static List<UnsupportedTypeTestParam> getInvalidIntersectionTypes() {
        ArrayList<UnsupportedTypeTestParam> result = new ArrayList<UnsupportedTypeTestParam>();
        result.add(new UnsupportedTypeTestParam.Builder("{ property1: Any } & { property2: Number }").withReason("property1", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property1: String } & { property2: Any }").withReason("property2", "Any").build());
        return result;
    }

    static List<Arguments> getValidUnionTypes() {
        ArrayList<Arguments> result = new ArrayList<Arguments>();
        for (Arguments arguments : AbstractValidatorTest.getValidTypes()) {
            result.add(Arguments.of((Object[])new Object[]{"Null | " + String.valueOf(arguments.get()[0]), arguments.get()[1]}));
        }
        result.add(Arguments.of((Object[])new Object[]{"Null | {property: String}", "null"}));
        result.add(Arguments.of((Object[])new Object[]{"{property: String} | Null", "{property: \"foo\"}"}));
        result.add(Arguments.of((Object[])new Object[]{"Null | {property: Array<String>}", "null"}));
        result.add(Arguments.of((Object[])new Object[]{"{property: Array<String>} | Null", "{property: []}"}));
        result.add(Arguments.of((Object[])new Object[]{"{property1: String} & {property2: Number} | Null", "{property1: \"foo\", property2: 777}"}));
        result.add(Arguments.of((Object[])new Object[]{"Null | {property1: String} & {property2: Number}", "null"}));
        result.add(Arguments.of((Object[])new Object[]{"1 | 2 | 3", "2"}));
        result.add(Arguments.of((Object[])new Object[]{"\"A\" | \"B\" | \"C\"", "\"B\""}));
        result.add(Arguments.of((Object[])new Object[]{"true | false", "true"}));
        result.add(Arguments.of((Object[])new Object[]{"1 | 2 | 3 | Null", "null"}));
        result.add(Arguments.of((Object[])new Object[]{"Null | true | false", "null"}));
        result.add(Arguments.of((Object[])new Object[]{"\"A\" | \"B\" | Null | \"C\"", "null"}));
        return result;
    }

    static List<UnsupportedTypeTestParam> getInvalidUnionTypes() {
        ArrayList<UnsupportedTypeTestParam> result = new ArrayList<UnsupportedTypeTestParam>();
        AbstractValidatorTest.getInvalidTypes().forEach(param -> result.add(new UnsupportedTypeTestParam.Builder("Null | " + param.type).withReason(param.type).build()));
        result.add(new UnsupportedTypeTestParam.Builder("Regex | Null").withReason("Regex").build());
        result.add(new UnsupportedTypeTestParam.Builder("Null | Null").withReason("Null").build());
        result.add(new UnsupportedTypeTestParam.Builder("Null | { property: Any }").withReason("property", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property: Any } | Null").withReason("property", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Null | { property: Array<Any> }").withReason("property[]", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property: Array<Any> } | Null").withReason("property[]", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property1: Any } & { property2: Number } | Null").withReason("property1", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Null | { property1: Any } & { property2: Number }").withReason("property1", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("String | Number | Boolean").build());
        result.add(new UnsupportedTypeTestParam.Builder("String | String").build());
        result.add(new UnsupportedTypeTestParam.Builder("Number | Number").build());
        result.add(new UnsupportedTypeTestParam.Builder("Boolean | Boolean").build());
        return result;
    }

    static List<Arguments> getValidObjectTypes() {
        ArrayList<Arguments> result = new ArrayList<Arguments>();
        result.addAll(AbstractValidatorTest.getValidTypes());
        result.addAll(AbstractValidatorTest.getValidArrayTypes());
        result.addAll(AbstractValidatorTest.getValidUnionTypes());
        result.addAll(AbstractValidatorTest.getValidIntersectionTypes());
        result.add(Arguments.of((Object[])new Object[]{"{property: String}", "{property: \"foo\"}"}));
        result.add(Arguments.of((Object[])new Object[]{"{property: Array<String>}", "{property: [\"foo\"]}"}));
        result.add(Arguments.of((Object[])new Object[]{"{property: Null | String}", "{property: null}"}));
        result.add(Arguments.of((Object[])new Object[]{"{property: 1 | 2 | 3}", "{property: 2}"}));
        return result.stream().map(argument -> Arguments.of((Object[])new Object[]{"{ property: " + String.valueOf(argument.get()[0]) + "}", "{ property: " + String.valueOf(argument.get()[1]) + "}"})).toList();
    }

    static List<UnsupportedTypeTestParam> getInvalidObjectTypes() {
        Function<UnsupportedTypeTestParam, UnsupportedTypeTestParam> mapToObjectProperty = param -> {
            ArrayList<Reason> reasons = new ArrayList<Reason>(param.reasons);
            return new UnsupportedTypeTestParam.Builder("{property: " + param.type + "}").withPath("input.property").withReasons(reasons).build();
        };
        ArrayList<UnsupportedTypeTestParam> result = new ArrayList<UnsupportedTypeTestParam>();
        result.addAll(AbstractValidatorTest.getInvalidTypes().stream().map(mapToObjectProperty).toList());
        result.addAll(AbstractValidatorTest.getInvalidUnionTypes().stream().map(mapToObjectProperty).toList());
        result.addAll(AbstractValidatorTest.getInvalidArrayTypes().stream().map(mapToObjectProperty).toList());
        result.addAll(AbstractValidatorTest.getInvalidIntersectionTypes().stream().map(mapToObjectProperty).toList());
        result.add(new UnsupportedTypeTestParam.Builder("{ property: Null }").withReason("input.property", "Null").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property: { property: Any }}").withReason("input.property.property", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property: { property: Array<Any> }}").withReason("input.property.property[]", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property: { property: String | String }}").withReason("input.property.property", "String | String").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property: { property: Array<Any> }}").withReason("input.property.property[]", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property: Array<Any> }").withReason("input.property[]", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{ property: Array<{ property: Any }> }").withReason("input.property[].property", "Any").build());
        return result;
    }

    static List<Arguments> getValidOutputTypes() {
        ArrayList<Arguments> result = new ArrayList<Arguments>();
        result.addAll(AbstractValidatorTest.getValidObjectTypes());
        result.addAll(AbstractValidatorTest.getValidTypes());
        result.addAll(AbstractValidatorTest.getValidArrayTypes());
        result.addAll(AbstractValidatorTest.getValidUnionTypes());
        result.addAll(AbstractValidatorTest.getValidIntersectionTypes());
        result.add(Arguments.of((Object[])new Object[]{"Null", "null"}));
        return result;
    }

    static List<UnsupportedTypeTestParam> getUnsupportedOutputTypes() {
        ArrayList<UnsupportedTypeTestParam> result = new ArrayList<UnsupportedTypeTestParam>();
        result.add(new UnsupportedTypeTestParam.Builder("Any").withOutputValue("{}").withReason("output", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Binary").withOutputValue("\"text\" as Binary").withReason("output", "Binary").build());
        result.add(new UnsupportedTypeTestParam.Builder("LocalDateTime").withOutputValue("|2003-10-01T23:57:59|").withReason("output", "LocalDateTime").build());
        result.add(new UnsupportedTypeTestParam.Builder("LocalTime").withOutputValue("|10:34:37.276399|").withReason("output", "LocalTime").build());
        result.add(new UnsupportedTypeTestParam.Builder("Period").withOutputValue("years(1)").withReason("output", "Period").build());
        result.add(new UnsupportedTypeTestParam.Builder("Regex").withOutputValue("/([a-z]*).[a-z]*/").withReason("output", "Regex").build());
        result.add(new UnsupportedTypeTestParam.Builder("TimeZone").withOutputValue("|-08:00|").withReason("output", "TimeZone").build());
        result.add(new UnsupportedTypeTestParam.Builder("Range").withOutputValue("1 to 15").withReason("output", "Range").build());
        result.add(new UnsupportedTypeTestParam.Builder("() -> String").withOutputValue("() -> \"foo\"").withReason("output", "() -> String").build());
        return result;
    }

    static List<UnsupportedTypeTestParam> getUnsupportedComplexOutputTypes() {
        ArrayList<UnsupportedTypeTestParam> result = new ArrayList<UnsupportedTypeTestParam>();
        result.add(new UnsupportedTypeTestParam.Builder("{property: Any}").withOutputValue("{property: \"foo\"}").withReason("output.property", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Array<Any>").withOutputValue("[1, 2, 3]").withReason("output[]", "Any").withReason("", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Array<{ property: Any }>").withOutputValue("[{property: \"foo\"}, {property: \"bar\"}]").withReason("output[].property", "Any").withReason("property", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{property: Array<Any>}").withOutputValue("{property: [\"foo\", \"bar\"]}").withReason("output.property[]", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("Null | Any").withOutputValue("null").withReason("output", "Any").withReason("", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("{property1: Any} & {property2: Number}").withOutputValue("{property1: \"foo\", property2: 123}").withReason("output.property1", "Any").build());
        result.add(new UnsupportedTypeTestParam.Builder("String | Number").withOutputValue("1").withReason("output", "String | Number").build());
        return result;
    }

    protected static class UnsupportedTypeTestParam {
        String type;
        String path;
        Object outputValue;
        List<Reason> reasons;

        protected UnsupportedTypeTestParam() {
        }

        public String toString() {
            return "UnsupportedTypeTestParam{type='" + this.type + "', path=" + this.path + ", outputValue=" + String.valueOf(this.outputValue) + ", reasons=" + String.valueOf(this.reasons) + "}";
        }

        protected String getExpectedMessage(Reason reason) {
            return "Unsupported type at " + this.getPath(reason) + ": " + reason.reason();
        }

        public String getPath(Reason reason) {
            StringBuilder builder = new StringBuilder();
            if (this.path != null && !this.path.isEmpty()) {
                builder.append(this.path);
                if (reason.path != null && !reason.path.isEmpty() && !reason.path.startsWith("[]")) {
                    builder.append('.');
                }
            }
            if (reason.path != null && !reason.path.isEmpty()) {
                builder.append(reason.path);
            }
            return builder.toString();
        }

        static class Builder {
            private final UnsupportedTypeTestParam unsupportedTypeTestParam;
            private final List<Reason> reasons = new ArrayList<Reason>();

            public Builder(String type) {
                this.unsupportedTypeTestParam = new UnsupportedTypeTestParam();
                this.unsupportedTypeTestParam.type = type;
            }

            UnsupportedTypeTestParam build() {
                if (this.reasons.isEmpty()) {
                    this.withReason(this.unsupportedTypeTestParam.type);
                }
                this.unsupportedTypeTestParam.reasons = this.reasons;
                return this.unsupportedTypeTestParam;
            }

            Builder withOutputValue(Object outputValue) {
                this.unsupportedTypeTestParam.outputValue = outputValue;
                return this;
            }

            Builder withReason(String path, String reason) {
                this.reasons.add(new Reason(path, reason));
                return this;
            }

            Builder withReason(String reason) {
                this.reasons.add(new Reason("", reason));
                return this;
            }

            Builder withReasons(List<Reason> reasons) {
                this.reasons.addAll(reasons);
                return this;
            }

            public Builder withPath(String path) {
                this.unsupportedTypeTestParam.path = path;
                return this;
            }
        }
    }

    protected record Reason(String path, String reason) {
    }
}

