/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.IntersectionTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.R256TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandlerTestUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ObjectTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PropertyComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.TypeType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.WeaveType;

public class IntersectionTypeHandlerTest {
    private final DataWeaveScriptingEngine engine = new DataWeaveScriptingEngine();

    @Nested
    @DisplayName(value="Collision Handling")
    public class CollisionHandling {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private IntersectionTypeHandler intersectionTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.intersectionTypeHandler = new IntersectionTypeHandler(this.componentRegistry, new Patch());
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN intersection with conflicting array types WHEN processed THEN handles Union resolution")
        @Disabled
        public void testIntersectionArrayCollision() {
            String script = "%dw 2.8\ntype Root = Array<{age: Number}> & Array<Test>\n\ntype Test = {\n  name: String,\n  age: String\n}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)IntersectionTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.intersectionTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory), (String)"Array type collision intersection should throw RuntimeException");
            Assertions.assertTrue((boolean)exception.getMessage().contains("Not Heterogeneous Union"), (String)("Exception message should indicate non-heterogeneous union error, but was: " + exception.getMessage()));
        }

        @Test
        @DisplayName(value="GIVEN intersection with property type conflicts WHEN processed THEN handles Union errors gracefully")
        @Disabled
        public void testIntersectionPropertyTypeConflicts() {
            String script = "%dw 2.8\ntype Root = {prop: String} & {prop: Number}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)IntersectionTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.intersectionTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory), (String)"Property type conflict intersection should throw RuntimeException");
            Assertions.assertTrue((boolean)exception.getMessage().contains("Not Heterogeneous Union"), (String)("Exception message should indicate property type conflict results in union error, but was: " + exception.getMessage()));
        }

        @Test
        @DisplayName(value="GIVEN complex intersection with nested conflicts WHEN processed THEN handles Union resolution errors")
        @Disabled
        public void testComplexIntersectionWithNestedConflicts() {
            String script = "%dw 2.8\ntype Root = {\n  outer: {\n    prop: String,\n    nested: {value: Number}\n  }\n} & {\n  outer: {\n    prop: String,\n    nested: {value: String, extra: Boolean}\n  }\n}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)IntersectionTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.intersectionTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory), (String)"Complex nested conflict intersection should throw RuntimeException");
            Assertions.assertTrue((boolean)exception.getMessage().contains("Not Heterogeneous Union"), (String)("Exception message should indicate complex nested conflicts result in union error, but was: " + exception.getMessage()));
        }

        @Test
        @DisplayName(value="GIVEN intersection without conflicts WHEN processed THEN merges successfully")
        public void testIntersectionWithoutConflicts() {
            String script = "%dw 2.8\ntype Root = {a: String} & {b: Number}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)IntersectionTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            Component actualComponent = this.intersectionTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"Non-conflicting intersection should produce a valid component");
            Assertions.assertEquals((Object)"Root", (Object)actualComponent.getName(), (String)"Component name should be 'Root' for non-conflicting intersection");
            Assertions.assertTrue((boolean)(actualComponent instanceof ObjectTypeComponent), (String)("Non-conflicting intersection should resolve to an object type, but got: " + actualComponent.getClass().getSimpleName()));
            PropertyComponent aProperty = TypeHandlerTestUtils.findProperty("a", this.componentRegistry);
            PropertyComponent bProperty = TypeHandlerTestUtils.findProperty("b", this.componentRegistry);
            TypeHandlerTestUtils.assertPropertyType(aProperty, "String", this.componentRegistry);
            TypeHandlerTestUtils.assertPropertyType(bProperty, "Double", this.componentRegistry);
        }
    }

    @Nested
    @DisplayName(value="Primitive Intersections")
    public class PrimitiveIntersections {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private IntersectionTypeHandler intersectionTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.intersectionTypeHandler = new IntersectionTypeHandler(this.componentRegistry, new Patch());
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN intersection involving incompatible primitives WHEN processed THEN handles NothingType gracefully")
        public void testIntersectionWithIncompatiblePrimitives() {
            String script = "%dw 2.8\ntype Root = Number & String\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)IntersectionTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.intersectionTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory), (String)"Incompatible primitive intersection should throw RuntimeException");
            Assertions.assertTrue((boolean)exception.getMessage().contains("No handler found for type NothingType"), (String)("Exception message should indicate NothingType handler is missing, but was: " + exception.getMessage()));
        }

        @Test
        @DisplayName(value="GIVEN intersection of compatible primitive types WHEN processed THEN produces correct result")
        public void testIntersectionCompatiblePrimitives() {
            String script = "%dw 2.8\ntype Root = String & String\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)IntersectionTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            Component actualComponent = this.intersectionTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"Compatible primitive intersection should produce a valid component");
            Assertions.assertTrue((boolean)(actualComponent instanceof PrimitiveTypeComponent), (String)("Compatible primitive intersection should produce a primitive type, but got: " + actualComponent.getClass().getSimpleName()));
            Assertions.assertEquals((Object)"String", (Object)actualComponent.getName(), (String)"String & String intersection should resolve to String type");
        }
    }

    @Nested
    @DisplayName(value="Basic Intersections")
    public class BasicIntersections {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private IntersectionTypeHandler intersectionTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.intersectionTypeHandler = new IntersectionTypeHandler(this.componentRegistry, new Patch());
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN intersection of object types without collision WHEN processed THEN merges all properties")
        public void testIntersectionWithoutCollision() {
            String script = "%dw 2.8\ntype Root = {age: Number} & Test & {id : Number}\n\ntype Test = {\n  name: String <~ {label: \"Label for Test.name\"}\n} <~ {label : \"Label for Test\"}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)IntersectionTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            Component actualComponent = this.intersectionTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory);
            Assertions.assertInstanceOf(ObjectTypeComponent.class, (Object)actualComponent, (String)("Intersection should resolve to ObjectTypeComponent, but got: " + actualComponent.getClass().getSimpleName()));
            Assertions.assertEquals((Object)"Root", (Object)actualComponent.getName(), (String)"Component name should be 'Root'");
            Assertions.assertEquals((Object)this.serviceComponent.getId(), (Object)actualComponent.getOuter(), (String)"Component outer should reference the service component");
            PropertyComponent ageProperty = TypeHandlerTestUtils.findProperty("age", this.componentRegistry);
            PropertyComponent nameProperty = TypeHandlerTestUtils.findProperty("name", this.componentRegistry);
            PropertyComponent idProperty = TypeHandlerTestUtils.findProperty("id", this.componentRegistry);
            String ageParent = ageProperty.getOuter();
            String nameParent = nameProperty.getOuter();
            String idParent = idProperty.getOuter();
            Assertions.assertEquals((Object)ageParent, (Object)nameParent, (String)"Age parent should be the same as Name parent");
            Assertions.assertEquals((Object)nameParent, (Object)idParent, (String)"Id parent should be the same as Name parent");
            TypeHandlerTestUtils.assertPropertyType(ageProperty, "Double", this.componentRegistry);
            TypeHandlerTestUtils.assertPropertyType(nameProperty, "String", this.componentRegistry);
            TypeHandlerTestUtils.assertPropertyType(idProperty, "Double", this.componentRegistry);
            Assertions.assertTrue((boolean)ageProperty.isRequired(), (String)"Age property should be required by default");
            Assertions.assertTrue((boolean)nameProperty.isRequired(), (String)"Name property should be required by default");
            Assertions.assertTrue((boolean)idProperty.isRequired(), (String)"Id property should be required by default");
            Assertions.assertEquals((Object)"Label for Test.name", (Object)nameProperty.getLabel(), (String)"Name property should preserve label from Test type");
        }

        @Test
        @DisplayName(value="GIVEN intersection with metadata preservation WHEN processed THEN preserves all metadata")
        public void testIntersectionWithMetadataPreservation() {
            String script = "%dw 2.8\ntype Root = {age: Number <~ {description: \"Age description\"}} & Test\n\ntype Test = {\n  name: String <~ {label: \"Name label\", description: \"Name description\"}\n} <~ {description: \"Test type description\"}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)IntersectionTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            Component actualComponent = this.intersectionTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory);
            Assertions.assertTrue((boolean)(actualComponent instanceof ObjectTypeComponent), (String)("Intersection with metadata should resolve to ObjectTypeComponent, but got: " + actualComponent.getClass().getSimpleName()));
            PropertyComponent ageProperty = TypeHandlerTestUtils.findProperty("age", this.componentRegistry);
            PropertyComponent nameProperty = TypeHandlerTestUtils.findProperty("name", this.componentRegistry);
            Assertions.assertEquals((Object)"Age description", (Object)ageProperty.getDescription(), (String)"Age property should preserve description from first intersection type");
            Assertions.assertEquals((Object)"Name label", (Object)nameProperty.getLabel(), (String)"Name property should preserve label from Test type");
            Assertions.assertEquals((Object)"Name description", (Object)nameProperty.getDescription(), (String)"Name property should preserve description from Test type");
        }
    }
}

